/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x9.DHValidationParms;

public class DHDomainParameters
extends ASN1Object {
    private ASN1Integer p;
    private ASN1Integer g;
    private ASN1Integer q;
    private ASN1Integer j;
    private DHValidationParms validationParms;

    public static DHDomainParameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DHDomainParameters.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DHDomainParameters getInstance(Object obj) {
        if (obj == null || obj instanceof DHDomainParameters) {
            return (DHDomainParameters)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new DHDomainParameters((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid DHDomainParameters: " + obj.getClass().getName());
    }

    public DHDomainParameters(ASN1Integer p2, ASN1Integer g2, ASN1Integer q2, ASN1Integer j2, DHValidationParms validationParms) {
        if (p2 == null) {
            throw new IllegalArgumentException("'p' cannot be null");
        }
        if (g2 == null) {
            throw new IllegalArgumentException("'g' cannot be null");
        }
        if (q2 == null) {
            throw new IllegalArgumentException("'q' cannot be null");
        }
        this.p = p2;
        this.g = g2;
        this.q = q2;
        this.j = j2;
        this.validationParms = validationParms;
    }

    private DHDomainParameters(ASN1Sequence seq) {
        if (seq.size() < 3 || seq.size() > 5) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration e2 = seq.getObjects();
        this.p = ASN1Integer.getInstance(e2.nextElement());
        this.g = ASN1Integer.getInstance(e2.nextElement());
        this.q = ASN1Integer.getInstance(e2.nextElement());
        ASN1Encodable next = DHDomainParameters.getNext(e2);
        if (next != null && next instanceof ASN1Integer) {
            this.j = ASN1Integer.getInstance(next);
            next = DHDomainParameters.getNext(e2);
        }
        if (next != null) {
            this.validationParms = DHValidationParms.getInstance(next.toASN1Primitive());
        }
    }

    private static ASN1Encodable getNext(Enumeration e2) {
        return e2.hasMoreElements() ? (ASN1Encodable)e2.nextElement() : null;
    }

    public ASN1Integer getP() {
        return this.p;
    }

    public ASN1Integer getG() {
        return this.g;
    }

    public ASN1Integer getQ() {
        return this.q;
    }

    public ASN1Integer getJ() {
        return this.j;
    }

    public DHValidationParms getValidationParms() {
        return this.validationParms;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.p);
        v2.add(this.g);
        v2.add(this.q);
        if (this.j != null) {
            v2.add(this.j);
        }
        if (this.validationParms != null) {
            v2.add(this.validationParms);
        }
        return new DERSequence(v2);
    }
}

