/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class ExtendedKeyUsage
extends ASN1Object {
    Hashtable usageTable = new Hashtable();
    ASN1Sequence seq;

    public static ExtendedKeyUsage getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ExtendedKeyUsage.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static ExtendedKeyUsage getInstance(Object obj) {
        if (obj instanceof ExtendedKeyUsage) {
            return (ExtendedKeyUsage)obj;
        }
        if (obj != null) {
            return new ExtendedKeyUsage(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ExtendedKeyUsage(KeyPurposeId usage) {
        this.seq = new DERSequence(usage);
        this.usageTable.put(usage, usage);
    }

    public ExtendedKeyUsage(ASN1Sequence seq) {
        this.seq = seq;
        Enumeration e2 = seq.getObjects();
        while (e2.hasMoreElements()) {
            Object o2 = e2.nextElement();
            if (!(o2 instanceof ASN1ObjectIdentifier)) {
                throw new IllegalArgumentException("Only ASN1ObjectIdentifiers allowed in ExtendedKeyUsage.");
            }
            this.usageTable.put(o2, o2);
        }
    }

    public ExtendedKeyUsage(Vector usages) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        Enumeration e2 = usages.elements();
        while (e2.hasMoreElements()) {
            ASN1Primitive o2 = (ASN1Primitive)e2.nextElement();
            v2.add(o2);
            this.usageTable.put(o2, o2);
        }
        this.seq = new DERSequence(v2);
    }

    public boolean hasKeyPurposeId(KeyPurposeId keyPurposeId) {
        return this.usageTable.get(keyPurposeId) != null;
    }

    public Vector getUsages() {
        Vector temp = new Vector();
        Enumeration it = this.usageTable.elements();
        while (it.hasMoreElements()) {
            temp.addElement(it.nextElement());
        }
        return temp;
    }

    public int size() {
        return this.usageTable.size();
    }

    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

