/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.util;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERApplicationSpecific;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERExternal;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.encoders.Hex;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static void _dumpAsString(String indent, boolean verbose, ASN1Primitive obj, StringBuffer buf) {
        String nl = System.getProperty("line.separator");
        if (obj instanceof ASN1Sequence) {
            Enumeration e2 = ((ASN1Sequence)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            if (obj instanceof BERSequence) {
                buf.append("BER Sequence");
            } else if (obj instanceof DERSequence) {
                buf.append("DER Sequence");
            } else {
                buf.append("Sequence");
            }
            buf.append(nl);
            while (e2.hasMoreElements()) {
                Object o2 = e2.nextElement();
                if (o2 == null || o2.equals(new DERNull())) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o2 instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(tab, verbose, (ASN1Primitive)o2, buf);
                    continue;
                }
                ASN1Dump._dumpAsString(tab, verbose, ((ASN1Encodable)o2).toASN1Primitive(), buf);
            }
        } else if (obj instanceof DERTaggedObject) {
            String tab = indent + TAB;
            buf.append(indent);
            if (obj instanceof BERTaggedObject) {
                buf.append("BER Tagged [");
            } else {
                buf.append("Tagged [");
            }
            DERTaggedObject o3 = (DERTaggedObject)obj;
            buf.append(Integer.toString(o3.getTagNo()));
            buf.append(']');
            if (!o3.isExplicit()) {
                buf.append(" IMPLICIT ");
            }
            buf.append(nl);
            if (o3.isEmpty()) {
                buf.append(tab);
                buf.append("EMPTY");
                buf.append(nl);
            } else {
                ASN1Dump._dumpAsString(tab, verbose, o3.getObject(), buf);
            }
        } else if (obj instanceof BERSet) {
            Enumeration e3 = ((ASN1Set)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            buf.append("BER Set");
            buf.append(nl);
            while (e3.hasMoreElements()) {
                Object o4 = e3.nextElement();
                if (o4 == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o4 instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(tab, verbose, (ASN1Primitive)o4, buf);
                    continue;
                }
                ASN1Dump._dumpAsString(tab, verbose, ((ASN1Encodable)o4).toASN1Primitive(), buf);
            }
        } else if (obj instanceof DERSet) {
            Enumeration e4 = ((ASN1Set)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            buf.append("DER Set");
            buf.append(nl);
            while (e4.hasMoreElements()) {
                Object o5 = e4.nextElement();
                if (o5 == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o5 instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(tab, verbose, (ASN1Primitive)o5, buf);
                    continue;
                }
                ASN1Dump._dumpAsString(tab, verbose, ((ASN1Encodable)o5).toASN1Primitive(), buf);
            }
        } else if (obj instanceof ASN1ObjectIdentifier) {
            buf.append(indent + "ObjectIdentifier(" + ((ASN1ObjectIdentifier)obj).getId() + ")" + nl);
        } else if (obj instanceof DERBoolean) {
            buf.append(indent + "Boolean(" + ((DERBoolean)obj).isTrue() + ")" + nl);
        } else if (obj instanceof ASN1Integer) {
            buf.append(indent + "Integer(" + ((ASN1Integer)obj).getValue() + ")" + nl);
        } else if (obj instanceof BERConstructedOctetString) {
            ASN1OctetString oct = (ASN1OctetString)obj;
            buf.append(indent + "BER Constructed Octet String" + "[" + oct.getOctets().length + "] ");
            if (verbose) {
                buf.append(ASN1Dump.dumpBinaryDataAsString(indent, oct.getOctets()));
            } else {
                buf.append(nl);
            }
        } else if (obj instanceof DEROctetString) {
            ASN1OctetString oct = (ASN1OctetString)obj;
            buf.append(indent + "DER Octet String" + "[" + oct.getOctets().length + "] ");
            if (verbose) {
                buf.append(ASN1Dump.dumpBinaryDataAsString(indent, oct.getOctets()));
            } else {
                buf.append(nl);
            }
        } else if (obj instanceof DERBitString) {
            DERBitString bt = (DERBitString)obj;
            buf.append(indent + "DER Bit String" + "[" + bt.getBytes().length + ", " + bt.getPadBits() + "] ");
            if (verbose) {
                buf.append(ASN1Dump.dumpBinaryDataAsString(indent, bt.getBytes()));
            } else {
                buf.append(nl);
            }
        } else if (obj instanceof DERIA5String) {
            buf.append(indent + "IA5String(" + ((DERIA5String)obj).getString() + ") " + nl);
        } else if (obj instanceof DERUTF8String) {
            buf.append(indent + "UTF8String(" + ((DERUTF8String)obj).getString() + ") " + nl);
        } else if (obj instanceof DERPrintableString) {
            buf.append(indent + "PrintableString(" + ((DERPrintableString)obj).getString() + ") " + nl);
        } else if (obj instanceof DERVisibleString) {
            buf.append(indent + "VisibleString(" + ((DERVisibleString)obj).getString() + ") " + nl);
        } else if (obj instanceof DERBMPString) {
            buf.append(indent + "BMPString(" + ((DERBMPString)obj).getString() + ") " + nl);
        } else if (obj instanceof DERT61String) {
            buf.append(indent + "T61String(" + ((DERT61String)obj).getString() + ") " + nl);
        } else if (obj instanceof DERUTCTime) {
            buf.append(indent + "UTCTime(" + ((DERUTCTime)obj).getTime() + ") " + nl);
        } else if (obj instanceof DERGeneralizedTime) {
            buf.append(indent + "GeneralizedTime(" + ((DERGeneralizedTime)obj).getTime() + ") " + nl);
        } else if (obj instanceof BERApplicationSpecific) {
            buf.append(ASN1Dump.outputApplicationSpecific("BER", indent, verbose, obj, nl));
        } else if (obj instanceof DERApplicationSpecific) {
            buf.append(ASN1Dump.outputApplicationSpecific("DER", indent, verbose, obj, nl));
        } else if (obj instanceof DEREnumerated) {
            DEREnumerated en = (DEREnumerated)obj;
            buf.append(indent + "DER Enumerated(" + en.getValue() + ")" + nl);
        } else if (obj instanceof DERExternal) {
            DERExternal ext = (DERExternal)obj;
            buf.append(indent + "External " + nl);
            String tab = indent + TAB;
            if (ext.getDirectReference() != null) {
                buf.append(tab + "Direct Reference: " + ext.getDirectReference().getId() + nl);
            }
            if (ext.getIndirectReference() != null) {
                buf.append(tab + "Indirect Reference: " + ext.getIndirectReference().toString() + nl);
            }
            if (ext.getDataValueDescriptor() != null) {
                ASN1Dump._dumpAsString(tab, verbose, ext.getDataValueDescriptor(), buf);
            }
            buf.append(tab + "Encoding: " + ext.getEncoding() + nl);
            ASN1Dump._dumpAsString(tab, verbose, ext.getExternalContent(), buf);
        } else {
            buf.append(indent + obj.toString() + nl);
        }
    }

    private static String outputApplicationSpecific(String type, String indent, boolean verbose, ASN1Primitive obj, String nl) {
        DERApplicationSpecific app = (DERApplicationSpecific)obj;
        StringBuffer buf = new StringBuffer();
        if (app.isConstructed()) {
            try {
                ASN1Sequence s2 = ASN1Sequence.getInstance(app.getObject(16));
                buf.append(indent + type + " ApplicationSpecific[" + app.getApplicationTag() + "]" + nl);
                Enumeration e2 = s2.getObjects();
                while (e2.hasMoreElements()) {
                    ASN1Dump._dumpAsString(indent + TAB, verbose, (ASN1Primitive)e2.nextElement(), buf);
                }
            }
            catch (IOException e3) {
                buf.append(e3);
            }
            return buf.toString();
        }
        return indent + type + " ApplicationSpecific[" + app.getApplicationTag() + "] (" + new String(Hex.encode(app.getContents())) + ")" + nl;
    }

    public static String dumpAsString(Object obj) {
        return ASN1Dump.dumpAsString(obj, false);
    }

    public static String dumpAsString(Object obj, boolean verbose) {
        StringBuffer buf = new StringBuffer();
        if (obj instanceof ASN1Primitive) {
            ASN1Dump._dumpAsString("", verbose, (ASN1Primitive)obj, buf);
        } else if (obj instanceof ASN1Encodable) {
            ASN1Dump._dumpAsString("", verbose, ((ASN1Encodable)obj).toASN1Primitive(), buf);
        } else {
            return "unknown object type " + obj.toString();
        }
        return buf.toString();
    }

    private static String dumpBinaryDataAsString(String indent, byte[] bytes) {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        indent = indent + TAB;
        buf.append(nl);
        for (int i2 = 0; i2 < bytes.length; i2 += 32) {
            if (bytes.length - i2 > 32) {
                buf.append(indent);
                buf.append(new String(Hex.encode(bytes, i2, 32)));
                buf.append(TAB);
                buf.append(ASN1Dump.calculateAscString(bytes, i2, 32));
                buf.append(nl);
                continue;
            }
            buf.append(indent);
            buf.append(new String(Hex.encode(bytes, i2, bytes.length - i2)));
            for (int j2 = bytes.length - i2; j2 != 32; ++j2) {
                buf.append("  ");
            }
            buf.append(TAB);
            buf.append(ASN1Dump.calculateAscString(bytes, i2, bytes.length - i2));
            buf.append(nl);
        }
        return buf.toString();
    }

    private static String calculateAscString(byte[] bytes, int off, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = off; i2 != off + len; ++i2) {
            if (bytes[i2] < 32 || bytes[i2] > 126) continue;
            buf.append((char)bytes[i2]);
        }
        return buf.toString();
    }
}

