/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class SignedData
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ASN1Integer version;
    private ASN1Set digestAlgorithms;
    private ContentInfo contentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signerInfos;

    public static SignedData getInstance(Object o2) {
        if (o2 instanceof SignedData) {
            return (SignedData)o2;
        }
        if (o2 != null) {
            return new SignedData(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public SignedData(ASN1Integer _version, ASN1Set _digestAlgorithms, ContentInfo _contentInfo, ASN1Set _certificates, ASN1Set _crls, ASN1Set _signerInfos) {
        this.version = _version;
        this.digestAlgorithms = _digestAlgorithms;
        this.contentInfo = _contentInfo;
        this.certificates = _certificates;
        this.crls = _crls;
        this.signerInfos = _signerInfos;
    }

    public SignedData(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        this.version = (ASN1Integer)e2.nextElement();
        this.digestAlgorithms = (ASN1Set)e2.nextElement();
        this.contentInfo = ContentInfo.getInstance(e2.nextElement());
        while (e2.hasMoreElements()) {
            ASN1Primitive o2 = (ASN1Primitive)e2.nextElement();
            if (o2 instanceof DERTaggedObject) {
                DERTaggedObject tagged = (DERTaggedObject)o2;
                switch (tagged.getTagNo()) {
                    case 0: {
                        this.certificates = ASN1Set.getInstance(tagged, false);
                        break;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance(tagged, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag value " + tagged.getTagNo());
                    }
                }
                continue;
            }
            this.signerInfos = (ASN1Set)o2;
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getCRLs() {
        return this.crls;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.version);
        v2.add(this.digestAlgorithms);
        v2.add(this.contentInfo);
        if (this.certificates != null) {
            v2.add(new DERTaggedObject(false, 0, this.certificates));
        }
        if (this.crls != null) {
            v2.add(new DERTaggedObject(false, 1, this.crls));
        }
        v2.add(this.signerInfos);
        return new BERSequence(v2);
    }
}

