/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.PKIMessage;

public class PKIMessages
extends ASN1Object {
    private ASN1Sequence content;

    private PKIMessages(ASN1Sequence seq) {
        this.content = seq;
    }

    public static PKIMessages getInstance(Object o2) {
        if (o2 instanceof PKIMessages) {
            return (PKIMessages)o2;
        }
        if (o2 != null) {
            return new PKIMessages(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PKIMessages(PKIMessage msg) {
        this.content = new DERSequence(msg);
    }

    public PKIMessages(PKIMessage[] msgs) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            v2.add(msgs[i2]);
        }
        this.content = new DERSequence(v2);
    }

    public PKIMessage[] toPKIMessageArray() {
        PKIMessage[] result = new PKIMessage[this.content.size()];
        for (int i2 = 0; i2 != result.length; ++i2) {
            result[i2] = PKIMessage.getInstance(this.content.getObjectAt(i2));
        }
        return result;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.content;
    }
}

