/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OOBCertHash
extends ASN1Object {
    private AlgorithmIdentifier hashAlg;
    private CertId certId;
    private DERBitString hashVal;

    private OOBCertHash(ASN1Sequence seq) {
        int index = seq.size() - 1;
        this.hashVal = DERBitString.getInstance(seq.getObjectAt(index--));
        for (int i2 = index; i2 >= 0; --i2) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)seq.getObjectAt(i2);
            if (tObj.getTagNo() == 0) {
                this.hashAlg = AlgorithmIdentifier.getInstance(tObj, true);
                continue;
            }
            this.certId = CertId.getInstance(tObj, true);
        }
    }

    public static OOBCertHash getInstance(Object o2) {
        if (o2 instanceof OOBCertHash) {
            return (OOBCertHash)o2;
        }
        if (o2 != null) {
            return new OOBCertHash(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.hashAlg;
    }

    public CertId getCertId() {
        return this.certId;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        this.addOptional(v2, 0, this.hashAlg);
        this.addOptional(v2, 1, this.certId);
        v2.add(this.hashVal);
        return new DERSequence(v2);
    }

    private void addOptional(ASN1EncodableVector v2, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v2.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

