/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.CertificateList;

public class CRLAnnContent
extends ASN1Object {
    private ASN1Sequence content;

    private CRLAnnContent(ASN1Sequence seq) {
        this.content = seq;
    }

    public static CRLAnnContent getInstance(Object o2) {
        if (o2 instanceof CRLAnnContent) {
            return (CRLAnnContent)o2;
        }
        if (o2 != null) {
            return new CRLAnnContent(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CRLAnnContent(CertificateList crl) {
        this.content = new DERSequence(crl);
    }

    public CertificateList[] getCertificateLists() {
        CertificateList[] result = new CertificateList[this.content.size()];
        for (int i2 = 0; i2 != result.length; ++i2) {
            result[i2] = CertificateList.getInstance(this.content.getObjectAt(i2));
        }
        return result;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.content;
    }
}

