/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.DoubleArray;
import org.apache.commons.math.util.FastMath;

public class ResizableDoubleArray
implements DoubleArray,
Serializable {
    public static final int ADDITIVE_MODE = 1;
    public static final int MULTIPLICATIVE_MODE = 0;
    private static final long serialVersionUID = -3485529955529426875L;
    protected float contractionCriteria = 2.5f;
    protected float expansionFactor = 2.0f;
    protected int expansionMode = 0;
    protected int initialCapacity = 16;
    protected double[] internalArray;
    protected int numElements = 0;
    protected int startIndex = 0;

    public ResizableDoubleArray() {
        this.internalArray = new double[this.initialCapacity];
    }

    public ResizableDoubleArray(int initialCapacity) {
        this.setInitialCapacity(initialCapacity);
        this.internalArray = new double[this.initialCapacity];
    }

    public ResizableDoubleArray(double[] initialArray) {
        if (initialArray == null) {
            this.internalArray = new double[this.initialCapacity];
        } else {
            this.internalArray = new double[initialArray.length];
            System.arraycopy(initialArray, 0, this.internalArray, 0, initialArray.length);
            this.initialCapacity = initialArray.length;
            this.numElements = initialArray.length;
        }
    }

    public ResizableDoubleArray(int initialCapacity, float expansionFactor) {
        this.expansionFactor = expansionFactor;
        this.setInitialCapacity(initialCapacity);
        this.internalArray = new double[initialCapacity];
        this.setContractionCriteria(expansionFactor + 0.5f);
    }

    public ResizableDoubleArray(int initialCapacity, float expansionFactor, float contractionCriteria) {
        this.expansionFactor = expansionFactor;
        this.setContractionCriteria(contractionCriteria);
        this.setInitialCapacity(initialCapacity);
        this.internalArray = new double[initialCapacity];
    }

    public ResizableDoubleArray(int initialCapacity, float expansionFactor, float contractionCriteria, int expansionMode) {
        this.expansionFactor = expansionFactor;
        this.setContractionCriteria(contractionCriteria);
        this.setInitialCapacity(initialCapacity);
        this.setExpansionMode(expansionMode);
        this.internalArray = new double[initialCapacity];
    }

    public ResizableDoubleArray(ResizableDoubleArray original) {
        ResizableDoubleArray.copy(original, this);
    }

    public synchronized void addElement(double value) {
        ++this.numElements;
        if (this.startIndex + this.numElements > this.internalArray.length) {
            this.expand();
        }
        this.internalArray[this.startIndex + (this.numElements - 1)] = value;
        if (this.shouldContract()) {
            this.contract();
        }
    }

    public synchronized void addElements(double[] values) {
        double[] tempArray = new double[this.numElements + values.length + 1];
        System.arraycopy(this.internalArray, this.startIndex, tempArray, 0, this.numElements);
        System.arraycopy(values, 0, tempArray, this.numElements, values.length);
        this.internalArray = tempArray;
        this.startIndex = 0;
        this.numElements += values.length;
    }

    public synchronized double addElementRolling(double value) {
        double discarded = this.internalArray[this.startIndex];
        if (this.startIndex + (this.numElements + 1) > this.internalArray.length) {
            this.expand();
        }
        ++this.startIndex;
        this.internalArray[this.startIndex + (this.numElements - 1)] = value;
        if (this.shouldContract()) {
            this.contract();
        }
        return discarded;
    }

    public synchronized double substituteMostRecentElement(double value) {
        if (this.numElements < 1) {
            throw MathRuntimeException.createArrayIndexOutOfBoundsException(LocalizedFormats.CANNOT_SUBSTITUTE_ELEMENT_FROM_EMPTY_ARRAY, new Object[0]);
        }
        double discarded = this.internalArray[this.startIndex + (this.numElements - 1)];
        this.internalArray[this.startIndex + (this.numElements - 1)] = value;
        return discarded;
    }

    protected void checkContractExpand(float contraction, float expansion) {
        if (contraction < expansion) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_EXPANSION_FACTOR, Float.valueOf(contraction), Float.valueOf(expansion));
        }
        if ((double)contraction <= 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_ONE, Float.valueOf(contraction));
        }
        if ((double)expansion <= 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.EXPANSION_FACTOR_SMALLER_THAN_ONE, Float.valueOf(expansion));
        }
    }

    public synchronized void clear() {
        this.numElements = 0;
        this.startIndex = 0;
        this.internalArray = new double[this.initialCapacity];
    }

    public synchronized void contract() {
        double[] tempArray = new double[this.numElements + 1];
        System.arraycopy(this.internalArray, this.startIndex, tempArray, 0, this.numElements);
        this.internalArray = tempArray;
        this.startIndex = 0;
    }

    public synchronized void discardFrontElements(int i2) {
        this.discardExtremeElements(i2, true);
    }

    public synchronized void discardMostRecentElements(int i2) {
        this.discardExtremeElements(i2, false);
    }

    private synchronized void discardExtremeElements(int i2, boolean front) {
        if (i2 > this.numElements) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.TOO_MANY_ELEMENTS_TO_DISCARD_FROM_ARRAY, i2, this.numElements);
        }
        if (i2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.CANNOT_DISCARD_NEGATIVE_NUMBER_OF_ELEMENTS, i2);
        }
        this.numElements -= i2;
        if (front) {
            this.startIndex += i2;
        }
        if (this.shouldContract()) {
            this.contract();
        }
    }

    protected synchronized void expand() {
        int newSize = 0;
        newSize = this.expansionMode == 0 ? (int)FastMath.ceil((float)this.internalArray.length * this.expansionFactor) : this.internalArray.length + FastMath.round(this.expansionFactor);
        double[] tempArray = new double[newSize];
        System.arraycopy(this.internalArray, 0, tempArray, 0, this.internalArray.length);
        this.internalArray = tempArray;
    }

    private synchronized void expandTo(int size) {
        double[] tempArray = new double[size];
        System.arraycopy(this.internalArray, 0, tempArray, 0, this.internalArray.length);
        this.internalArray = tempArray;
    }

    public float getContractionCriteria() {
        return this.contractionCriteria;
    }

    public synchronized double getElement(int index) {
        if (index >= this.numElements) {
            throw MathRuntimeException.createArrayIndexOutOfBoundsException(LocalizedFormats.INDEX_LARGER_THAN_MAX, index, this.numElements - 1);
        }
        if (index >= 0) {
            return this.internalArray[this.startIndex + index];
        }
        throw MathRuntimeException.createArrayIndexOutOfBoundsException(LocalizedFormats.CANNOT_RETRIEVE_AT_NEGATIVE_INDEX, index);
    }

    public synchronized double[] getElements() {
        double[] elementArray = new double[this.numElements];
        System.arraycopy(this.internalArray, this.startIndex, elementArray, 0, this.numElements);
        return elementArray;
    }

    public float getExpansionFactor() {
        return this.expansionFactor;
    }

    public int getExpansionMode() {
        return this.expansionMode;
    }

    synchronized int getInternalLength() {
        return this.internalArray.length;
    }

    public synchronized int getNumElements() {
        return this.numElements;
    }

    @Deprecated
    public synchronized double[] getValues() {
        return this.internalArray;
    }

    public synchronized double[] getInternalValues() {
        return this.internalArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContractionCriteria(float contractionCriteria) {
        this.checkContractExpand(contractionCriteria, this.getExpansionFactor());
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.contractionCriteria = contractionCriteria;
        }
    }

    public synchronized void setElement(int index, double value) {
        if (index < 0) {
            throw MathRuntimeException.createArrayIndexOutOfBoundsException(LocalizedFormats.CANNOT_SET_AT_NEGATIVE_INDEX, index);
        }
        if (index + 1 > this.numElements) {
            this.numElements = index + 1;
        }
        if (this.startIndex + index >= this.internalArray.length) {
            this.expandTo(this.startIndex + (index + 1));
        }
        this.internalArray[this.startIndex + index] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpansionFactor(float expansionFactor) {
        this.checkContractExpand(this.getContractionCriteria(), expansionFactor);
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.expansionFactor = expansionFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpansionMode(int expansionMode) {
        if (expansionMode != 0 && expansionMode != 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.UNSUPPORTED_EXPANSION_MODE, expansionMode, 0, "MULTIPLICATIVE_MODE", 1, "ADDITIVE_MODE");
        }
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.expansionMode = expansionMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInitialCapacity(int initialCapacity) {
        if (initialCapacity > 0) {
            ResizableDoubleArray resizableDoubleArray = this;
            synchronized (resizableDoubleArray) {
                this.initialCapacity = initialCapacity;
            }
        } else {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INITIAL_CAPACITY_NOT_POSITIVE, initialCapacity);
        }
    }

    public synchronized void setNumElements(int i2) {
        if (i2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INDEX_NOT_POSITIVE, i2);
        }
        if (this.startIndex + i2 > this.internalArray.length) {
            this.expandTo(this.startIndex + i2);
        }
        this.numElements = i2;
    }

    private synchronized boolean shouldContract() {
        if (this.expansionMode == 0) {
            return (float)this.internalArray.length / (float)this.numElements > this.contractionCriteria;
        }
        return (float)(this.internalArray.length - this.numElements) > this.contractionCriteria;
    }

    public synchronized int start() {
        return this.startIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(ResizableDoubleArray source, ResizableDoubleArray dest) {
        ResizableDoubleArray resizableDoubleArray = source;
        synchronized (resizableDoubleArray) {
            ResizableDoubleArray resizableDoubleArray2 = dest;
            synchronized (resizableDoubleArray2) {
                dest.initialCapacity = source.initialCapacity;
                dest.contractionCriteria = source.contractionCriteria;
                dest.expansionFactor = source.expansionFactor;
                dest.expansionMode = source.expansionMode;
                dest.internalArray = new double[source.internalArray.length];
                System.arraycopy(source.internalArray, 0, dest.internalArray, 0, dest.internalArray.length);
                dest.numElements = source.numElements;
                dest.startIndex = source.startIndex;
            }
        }
    }

    public synchronized ResizableDoubleArray copy() {
        ResizableDoubleArray result = new ResizableDoubleArray();
        ResizableDoubleArray.copy(this, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ResizableDoubleArray)) {
            return false;
        }
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            Object object2 = object;
            synchronized (object2) {
                boolean result = true;
                ResizableDoubleArray other = (ResizableDoubleArray)object;
                result = result && other.initialCapacity == this.initialCapacity;
                result = result && other.contractionCriteria == this.contractionCriteria;
                result = result && other.expansionFactor == this.expansionFactor;
                result = result && other.expansionMode == this.expansionMode;
                result = result && other.numElements == this.numElements;
                boolean bl = result = result && other.startIndex == this.startIndex;
                if (!result) {
                    return false;
                }
                return Arrays.equals(this.internalArray, other.internalArray);
            }
        }
    }

    public synchronized int hashCode() {
        int[] hashData = new int[]{new Float(this.expansionFactor).hashCode(), new Float(this.contractionCriteria).hashCode(), this.expansionMode, Arrays.hashCode(this.internalArray), this.initialCapacity, this.numElements, this.startIndex};
        return Arrays.hashCode(hashData);
    }
}

