/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.PascalDistribution;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.util.FastMath;
import org.apache.commons.math.util.MathUtils;

public class PascalDistributionImpl
extends AbstractIntegerDistribution
implements PascalDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfSuccesses;
    private double probabilityOfSuccess;

    public PascalDistributionImpl(int r2, double p2) {
        this.setNumberOfSuccessesInternal(r2);
        this.setProbabilityOfSuccessInternal(p2);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Deprecated
    public void setNumberOfSuccesses(int successes) {
        this.setNumberOfSuccessesInternal(successes);
    }

    private void setNumberOfSuccessesInternal(int successes) {
        if (successes < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_NUMBER_OF_SUCCESSES, successes);
        }
        this.numberOfSuccesses = successes;
    }

    @Deprecated
    public void setProbabilityOfSuccess(double p2) {
        this.setProbabilityOfSuccessInternal(p2);
    }

    private void setProbabilityOfSuccessInternal(double p2) {
        if (p2 < 0.0 || p2 > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, p2, 0.0, 1.0);
        }
        this.probabilityOfSuccess = p2;
    }

    protected int getDomainLowerBound(double p2) {
        return -1;
    }

    protected int getDomainUpperBound(double p2) {
        return 0x7FFFFFFE;
    }

    public double cumulativeProbability(int x2) throws MathException {
        double ret = x2 < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, x2 + 1);
        return ret;
    }

    public double probability(int x2) {
        double ret = x2 < 0 ? 0.0 : MathUtils.binomialCoefficientDouble(x2 + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * FastMath.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * FastMath.pow(1.0 - this.probabilityOfSuccess, x2);
        return ret;
    }

    public int inverseCumulativeProbability(double p2) throws MathException {
        int ret = p2 == 0.0 ? -1 : (p2 == 1.0 ? Integer.MAX_VALUE : super.inverseCumulativeProbability(p2));
        return ret;
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public double getNumericalMean() {
        double p2 = this.getProbabilityOfSuccess();
        double r2 = this.getNumberOfSuccesses();
        return r2 * p2 / (1.0 - p2);
    }

    public double getNumericalVariance() {
        double p2 = this.getProbabilityOfSuccess();
        double r2 = this.getNumberOfSuccesses();
        double pInv = 1.0 - p2;
        return r2 * p2 / (pInv * pInv);
    }
}

