/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.traversal;

import org.apache.batik.dom.AbstractNode;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class DOMTreeWalker
implements TreeWalker {
    protected Node root;
    protected int whatToShow;
    protected NodeFilter filter;
    protected boolean expandEntityReferences;
    protected Node currentNode;

    public DOMTreeWalker(Node n2, int what, NodeFilter nf, boolean exp) {
        this.root = n2;
        this.whatToShow = what;
        this.filter = nf;
        this.expandEntityReferences = exp;
        this.currentNode = this.root;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node n2) {
        if (n2 == null) {
            throw ((AbstractNode)this.root).createDOMException((short)9, "null.current.node", null);
        }
        this.currentNode = n2;
    }

    public Node parentNode() {
        Node result = this.parentNode(this.currentNode);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public Node firstChild() {
        Node result = this.firstChild(this.currentNode);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public Node lastChild() {
        Node result = this.lastChild(this.currentNode);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public Node previousSibling() {
        Node result = this.previousSibling(this.currentNode, this.root);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public Node nextSibling() {
        Node result = this.nextSibling(this.currentNode, this.root);
        if (result != null) {
            this.currentNode = result;
        }
        return result;
    }

    public Node previousNode() {
        Node n2;
        Node result = this.previousSibling(this.currentNode, this.root);
        if (result == null) {
            result = this.parentNode(this.currentNode);
            if (result != null) {
                this.currentNode = result;
            }
            return result;
        }
        Node last = n2 = this.lastChild(result);
        while (n2 != null) {
            last = n2;
            n2 = this.lastChild(last);
        }
        this.currentNode = last != null ? last : result;
        return this.currentNode;
    }

    public Node nextNode() {
        Node result = this.firstChild(this.currentNode);
        if (result != null) {
            this.currentNode = result;
            return this.currentNode;
        }
        result = this.nextSibling(this.currentNode, this.root);
        if (result != null) {
            this.currentNode = result;
            return this.currentNode;
        }
        Node parent = this.currentNode;
        do {
            if ((parent = this.parentNode(parent)) != null) continue;
            return null;
        } while ((result = this.nextSibling(parent, this.root)) == null);
        this.currentNode = result;
        return this.currentNode;
    }

    protected Node parentNode(Node n2) {
        if (n2 == this.root) {
            return null;
        }
        Node result = n2;
        do {
            if ((result = result.getParentNode()) != null) continue;
            return null;
        } while ((this.whatToShow & 1 << result.getNodeType() - 1) == 0 || this.filter != null && this.filter.acceptNode(result) != 1);
        return result;
    }

    protected Node firstChild(Node n2) {
        if (n2.getNodeType() == 5 && !this.expandEntityReferences) {
            return null;
        }
        Node result = n2.getFirstChild();
        if (result == null) {
            return null;
        }
        switch (this.acceptNode(result)) {
            case 1: {
                return result;
            }
            case 3: {
                Node t2 = this.firstChild(result);
                if (t2 == null) break;
                return t2;
            }
        }
        return this.nextSibling(result, n2);
    }

    protected Node lastChild(Node n2) {
        if (n2.getNodeType() == 5 && !this.expandEntityReferences) {
            return null;
        }
        Node result = n2.getLastChild();
        if (result == null) {
            return null;
        }
        switch (this.acceptNode(result)) {
            case 1: {
                return result;
            }
            case 3: {
                Node t2 = this.lastChild(result);
                if (t2 == null) break;
                return t2;
            }
        }
        return this.previousSibling(result, n2);
    }

    protected Node previousSibling(Node n2, Node root) {
        while (n2 != root) {
            Node result = n2.getPreviousSibling();
            if (result == null) {
                result = n2.getParentNode();
                if (result == null || result == root) {
                    return null;
                }
                if (this.acceptNode(result) == 3) {
                    n2 = result;
                    continue;
                }
                return null;
            }
            switch (this.acceptNode(result)) {
                case 1: {
                    return result;
                }
                case 3: {
                    Node t2 = this.lastChild(result);
                    if (t2 == null) break;
                    return t2;
                }
            }
            n2 = result;
        }
        return null;
    }

    protected Node nextSibling(Node n2, Node root) {
        while (n2 != root) {
            Node result = n2.getNextSibling();
            if (result == null) {
                result = n2.getParentNode();
                if (result == null || result == root) {
                    return null;
                }
                if (this.acceptNode(result) == 3) {
                    n2 = result;
                    continue;
                }
                return null;
            }
            switch (this.acceptNode(result)) {
                case 1: {
                    return result;
                }
                case 3: {
                    Node t2 = this.firstChild(result);
                    if (t2 == null) break;
                    return t2;
                }
            }
            n2 = result;
        }
        return null;
    }

    protected short acceptNode(Node n2) {
        if ((this.whatToShow & 1 << n2.getNodeType() - 1) != 0) {
            if (this.filter == null) {
                return 1;
            }
            return this.filter.acceptNode(n2);
        }
        return 3;
    }
}

