/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public abstract class AbstractDOMImplementation
implements DOMImplementation,
Serializable {
    protected final HashTable features = new HashTable();

    protected void registerFeature(String name, Object value) {
        this.features.put(name.toLowerCase(), value);
    }

    protected AbstractDOMImplementation() {
        this.registerFeature("Core", new String[]{"2.0", "3.0"});
        this.registerFeature("XML", new String[]{"1.0", "2.0", "3.0"});
        this.registerFeature("Events", new String[]{"2.0", "3.0"});
        this.registerFeature("UIEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("MouseEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("TextEvents", "3.0");
        this.registerFeature("KeyboardEvents", "3.0");
        this.registerFeature("MutationEvents", new String[]{"2.0", "3.0"});
        this.registerFeature("MutationNameEvents", "3.0");
        this.registerFeature("Traversal", "2.0");
        this.registerFeature("XPath", "3.0");
    }

    public boolean hasFeature(String feature, String version) {
        Object v2;
        if (feature == null || feature.length() == 0) {
            return false;
        }
        if (feature.charAt(0) == '+') {
            feature = feature.substring(1);
        }
        if ((v2 = this.features.get(feature.toLowerCase())) == null) {
            return false;
        }
        if (version == null || version.length() == 0) {
            return true;
        }
        if (v2 instanceof String) {
            return version.equals(v2);
        }
        String[] va = (String[])v2;
        int i2 = 0;
        while (i2 < va.length) {
            if (version.equals(va[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public Object getFeature(String feature, String version) {
        if (this.hasFeature(feature, version)) {
            return this;
        }
        return null;
    }

    public DocumentEventSupport createDocumentEventSupport() {
        return new DocumentEventSupport();
    }

    public EventSupport createEventSupport(AbstractNode n2) {
        return new EventSupport(n2);
    }

    public abstract Document createDocument(String var1, String var2, DocumentType var3) throws DOMException;

    public abstract DocumentType createDocumentType(String var1, String var2, String var3) throws DOMException;
}

