/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.apache.batik.bridge.svg12.AbstractContentSelector;
import org.apache.batik.bridge.svg12.ContentManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg12.XBLOMContentElement;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathPatternContentSelector
extends AbstractContentSelector {
    protected NSPrefixResolver prefixResolver = new NSPrefixResolver();
    protected XPath xpath;
    protected XPathContext context;
    protected SelectedNodes selectedContent;
    protected String expression;

    public XPathPatternContentSelector(ContentManager cm, XBLOMContentElement content, Element bound, String selector) {
        super(cm, content, bound);
        this.expression = selector;
        this.parse();
    }

    protected void parse() {
        this.context = new XPathContext();
        try {
            this.xpath = new XPath(this.expression, null, (PrefixResolver)this.prefixResolver, 1);
        }
        catch (TransformerException te) {
            AbstractDocument doc = (AbstractDocument)this.contentElement.getOwnerDocument();
            throw doc.createXPathException((short)51, "xpath.invalid.expression", new Object[]{this.expression, te.getMessage()});
        }
    }

    public NodeList getSelectedContent() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
        }
        return this.selectedContent;
    }

    boolean update() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
            return true;
        }
        this.parse();
        return this.selectedContent.update();
    }

    protected class NSPrefixResolver
    implements PrefixResolver {
        protected NSPrefixResolver() {
        }

        public String getBaseIdentifier() {
            return null;
        }

        public String getNamespaceForPrefix(String prefix) {
            return XPathPatternContentSelector.this.contentElement.lookupNamespaceURI(prefix);
        }

        public String getNamespaceForPrefix(String prefix, Node context) {
            return XPathPatternContentSelector.this.contentElement.lookupNamespaceURI(prefix);
        }

        public boolean handlesNullPrefixes() {
            return false;
        }
    }

    protected class SelectedNodes
    implements NodeList {
        protected ArrayList nodes = new ArrayList(10);

        public SelectedNodes() {
            this.update();
        }

        protected boolean update() {
            ArrayList oldNodes = (ArrayList)this.nodes.clone();
            this.nodes.clear();
            Node n2 = XPathPatternContentSelector.this.boundElement.getFirstChild();
            while (n2 != null) {
                this.update(n2);
                n2 = n2.getNextSibling();
            }
            int nodesSize = this.nodes.size();
            if (oldNodes.size() != nodesSize) {
                return true;
            }
            int i2 = 0;
            while (i2 < nodesSize) {
                if (oldNodes.get(i2) != this.nodes.get(i2)) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        protected boolean descendantSelected(Node n2) {
            n2 = n2.getFirstChild();
            while (n2 != null) {
                if (XPathPatternContentSelector.this.isSelected(n2) || this.descendantSelected(n2)) {
                    return true;
                }
                n2 = n2.getNextSibling();
            }
            return false;
        }

        protected void update(Node n2) {
            if (!XPathPatternContentSelector.this.isSelected(n2)) {
                try {
                    double matchScore = XPathPatternContentSelector.this.xpath.execute(XPathPatternContentSelector.this.context, n2, (PrefixResolver)XPathPatternContentSelector.this.prefixResolver).num();
                    if (matchScore != Double.NEGATIVE_INFINITY) {
                        if (!this.descendantSelected(n2)) {
                            this.nodes.add(n2);
                        }
                    } else {
                        n2 = n2.getFirstChild();
                        while (n2 != null) {
                            this.update(n2);
                            n2 = n2.getNextSibling();
                        }
                    }
                }
                catch (TransformerException te) {
                    AbstractDocument doc = (AbstractDocument)XPathPatternContentSelector.this.contentElement.getOwnerDocument();
                    throw doc.createXPathException((short)51, "xpath.error", new Object[]{XPathPatternContentSelector.this.expression, te.getMessage()});
                }
            }
        }

        public Node item(int index) {
            if (index < 0 || index >= this.nodes.size()) {
                return null;
            }
            return (Node)this.nodes.get(index);
        }

        public int getLength() {
            return this.nodes.size();
        }
    }
}

