/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class VCFStandardHeaderLines {
    private static final boolean REPAIR_BAD_DESCRIPTIONS = false;
    private static Standards<VCFFormatHeaderLine> formatStandards = new Standards();
    private static Standards<VCFInfoHeaderLine> infoStandards = new Standards();

    public static VCFHeader repairStandardHeaderLines(VCFHeader header) {
        LinkedHashSet<VCFHeaderLine> newLines = new LinkedHashSet<VCFHeaderLine>(header.getMetaDataInInputOrder().size());
        for (VCFHeaderLine line : header.getMetaDataInInputOrder()) {
            if (line instanceof VCFFormatHeaderLine) {
                line = formatStandards.repair((VCFFormatHeaderLine)line);
            } else if (line instanceof VCFInfoHeaderLine) {
                line = infoStandards.repair((VCFInfoHeaderLine)line);
            }
            newLines.add(line);
        }
        return new VCFHeader(newLines, header.getGenotypeSamples());
    }

    public static Set<String> addStandardFormatLines(Set<VCFHeaderLine> headerLines, boolean throwErrorForMissing, Collection<String> IDs) {
        return formatStandards.addToHeader(headerLines, IDs, throwErrorForMissing);
    }

    public static Set<String> addStandardFormatLines(Set<VCFHeaderLine> headerLines, boolean throwErrorForMissing, String ... IDs) {
        return VCFStandardHeaderLines.addStandardFormatLines(headerLines, throwErrorForMissing, Arrays.asList(IDs));
    }

    public static VCFFormatHeaderLine getFormatLine(String ID, boolean throwErrorForMissing) {
        return formatStandards.get(ID, throwErrorForMissing);
    }

    public static VCFFormatHeaderLine getFormatLine(String ID) {
        return formatStandards.get(ID, true);
    }

    private static void registerStandard(VCFFormatHeaderLine line) {
        formatStandards.add(line);
    }

    public static Set<String> addStandardInfoLines(Set<VCFHeaderLine> headerLines, boolean throwErrorForMissing, Collection<String> IDs) {
        return infoStandards.addToHeader(headerLines, IDs, throwErrorForMissing);
    }

    public static Set<String> addStandardInfoLines(Set<VCFHeaderLine> headerLines, boolean throwErrorForMissing, String ... IDs) {
        return VCFStandardHeaderLines.addStandardInfoLines(headerLines, throwErrorForMissing, Arrays.asList(IDs));
    }

    public static VCFInfoHeaderLine getInfoLine(String ID, boolean throwErrorForMissing) {
        return infoStandards.get(ID, throwErrorForMissing);
    }

    public static VCFInfoHeaderLine getInfoLine(String ID) {
        return VCFStandardHeaderLines.getInfoLine(ID, true);
    }

    private static void registerStandard(VCFInfoHeaderLine line) {
        infoStandards.add(line);
    }

    static {
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("GT", 1, VCFHeaderLineType.String, "Genotype"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("GQ", 1, VCFHeaderLineType.Integer, "Genotype Quality"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("DP", 1, VCFHeaderLineType.Integer, "Approximate read depth (reads with MQ=255 or with bad mates are filtered)"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("PL", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Normalized, Phred-scaled likelihoods for genotypes as defined in the VCF specification"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("AD", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Allelic depths for the ref and alt alleles in the order listed"));
        VCFStandardHeaderLines.registerStandard(new VCFFormatHeaderLine("FT", 1, VCFHeaderLineType.String, "Genotype-level filter"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("END", 1, VCFHeaderLineType.Integer, "Stop position of the interval"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("MLEAC", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Maximum likelihood expectation (MLE) for the allele counts (not necessarily the same as the AC), for each ALT allele, in the same order as listed"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("MLEAF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Maximum likelihood expectation (MLE) for the allele frequency (not necessarily the same as the AF), for each ALT allele, in the same order as listed"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("DS", 0, VCFHeaderLineType.Flag, "Were any of the samples downsampled?"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("DB", 0, VCFHeaderLineType.Flag, "dbSNP Membership"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("DP", 1, VCFHeaderLineType.Integer, "Approximate read depth; some reads may have been filtered"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("SB", 1, VCFHeaderLineType.Float, "Strand Bias"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("AF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele Frequency, for each ALT allele, in the same order as listed"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("AC", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Allele count in genotypes, for each ALT allele, in the same order as listed"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("AN", 1, VCFHeaderLineType.Integer, "Total number of alleles in called genotypes"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("MQ0", 1, VCFHeaderLineType.Integer, "Total Mapping Quality Zero Reads"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("MQ", 1, VCFHeaderLineType.Float, "RMS Mapping Quality"));
        VCFStandardHeaderLines.registerStandard(new VCFInfoHeaderLine("SOMATIC", 0, VCFHeaderLineType.Flag, "Somatic event"));
    }

    private static class Standards<T extends VCFCompoundHeaderLine> {
        private final Map<String, T> standards = new HashMap<String, T>();

        private Standards() {
        }

        public T repair(T line) {
            T standard = this.get(((VCFCompoundHeaderLine)line).getID(), false);
            if (standard != null) {
                boolean needsRepair;
                boolean badDesc;
                boolean badCountType = ((VCFCompoundHeaderLine)line).getCountType() != ((VCFCompoundHeaderLine)standard).getCountType();
                boolean badCount = ((VCFCompoundHeaderLine)line).isFixedCount() && !badCountType && ((VCFCompoundHeaderLine)line).getCount() != ((VCFCompoundHeaderLine)standard).getCount();
                boolean badType = ((VCFCompoundHeaderLine)line).getType() != ((VCFCompoundHeaderLine)standard).getType();
                boolean bl = badDesc = !((VCFCompoundHeaderLine)line).getDescription().equals(((VCFCompoundHeaderLine)standard).getDescription());
                boolean bl2 = badCountType || badCount || badType ? true : (needsRepair = false);
                if (needsRepair) {
                    return standard;
                }
                return line;
            }
            return line;
        }

        public Set<String> addToHeader(Set<VCFHeaderLine> headerLines, Collection<String> IDs, boolean throwErrorForMissing) {
            HashSet<String> missing = new HashSet<String>();
            for (String ID : IDs) {
                T line = this.get(ID, throwErrorForMissing);
                if (line == null) {
                    missing.add(ID);
                    continue;
                }
                headerLines.add((VCFHeaderLine)line);
            }
            return missing;
        }

        public void add(T line) {
            if (this.standards.containsKey(((VCFCompoundHeaderLine)line).getID())) {
                throw new TribbleException("Attempting to add multiple standard header lines for ID " + ((VCFCompoundHeaderLine)line).getID());
            }
            this.standards.put(((VCFCompoundHeaderLine)line).getID(), line);
        }

        public T get(String ID, boolean throwErrorForMissing) {
            VCFCompoundHeaderLine x2 = (VCFCompoundHeaderLine)this.standards.get(ID);
            if (throwErrorForMissing && x2 == null) {
                throw new TribbleException("Couldn't find a standard VCF header line for field " + ID);
            }
            return (T)x2;
        }
    }
}

