/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.variant.variantcontext.writer.AsyncVariantContextWriter;
import htsjdk.variant.variantcontext.writer.BCF2Writer;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VCFWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;

public class VariantContextWriterBuilder {
    public static final EnumSet<Options> DEFAULT_OPTIONS = EnumSet.of(Options.INDEX_ON_THE_FLY);
    public static final EnumSet<Options> NO_OPTIONS = EnumSet.noneOf(Options.class);
    public static final EnumSet<OutputType> FILE_TYPES = EnumSet.of(OutputType.VCF, OutputType.BCF, OutputType.BLOCK_COMPRESSED_VCF);
    public static final EnumSet<OutputType> STREAM_TYPES = EnumSet.of(OutputType.VCF_STREAM, OutputType.BCF_STREAM);
    private SAMSequenceDictionary refDict = null;
    private OutputType outType = OutputType.UNSPECIFIED;
    private File outFile = null;
    private OutputStream outStream = null;
    private IndexCreator idxCreator = null;
    private int bufferSize = Defaults.BUFFER_SIZE;
    private boolean createMD5 = Defaults.CREATE_MD5;
    private EnumSet<Options> options = DEFAULT_OPTIONS.clone();

    public VariantContextWriterBuilder() {
        if (Defaults.USE_ASYNC_IO) {
            this.options.add(Options.USE_ASYNC_IO);
        }
    }

    public VariantContextWriterBuilder setReferenceDictionary(SAMSequenceDictionary refDict) {
        this.refDict = refDict;
        return this;
    }

    public VariantContextWriterBuilder setOutputFile(File outFile) {
        this.outFile = outFile;
        this.outStream = null;
        this.determineOutputTypeFromFilename();
        return this;
    }

    public VariantContextWriterBuilder setOutputFile(String outFile) {
        this.outFile = new File(outFile);
        this.outStream = null;
        this.determineOutputTypeFromFilename();
        return this;
    }

    public VariantContextWriterBuilder setOutputFileType(OutputType outType) {
        if (!FILE_TYPES.contains((Object)outType)) {
            throw new IllegalArgumentException("Must choose a file type, not other output types.");
        }
        if (this.outFile == null || this.outStream != null) {
            throw new IllegalArgumentException("Cannot set a file type if the output is not to a file.");
        }
        this.outType = outType;
        return this;
    }

    public VariantContextWriterBuilder setOutputVCFStream(OutputStream outStream) {
        this.outStream = outStream;
        this.outFile = null;
        this.outType = OutputType.VCF_STREAM;
        return this;
    }

    public VariantContextWriterBuilder setOutputBCFStream(OutputStream outStream) {
        this.outStream = outStream;
        this.outFile = null;
        this.outType = OutputType.BCF_STREAM;
        return this;
    }

    public VariantContextWriterBuilder setOutputStream(OutputStream outStream) {
        return this.setOutputVCFStream(outStream);
    }

    public VariantContextWriterBuilder setIndexCreator(IndexCreator idxCreator) {
        this.idxCreator = idxCreator;
        return this;
    }

    public VariantContextWriterBuilder clearIndexCreator() {
        this.idxCreator = null;
        return this;
    }

    public VariantContextWriterBuilder setBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public VariantContextWriterBuilder unsetBuffering() {
        this.bufferSize = 0;
        return this;
    }

    public VariantContextWriterBuilder setCreateMD5(boolean createMD5) {
        this.createMD5 = createMD5;
        return this;
    }

    public VariantContextWriterBuilder setCreateMD5() {
        return this.setCreateMD5(true);
    }

    public VariantContextWriterBuilder unsetCreateMD5() {
        return this.setCreateMD5(false);
    }

    public VariantContextWriterBuilder setOptions(EnumSet<Options> options) {
        this.options = options;
        return this;
    }

    public VariantContextWriterBuilder setOption(Options option) {
        this.options.add(option);
        return this;
    }

    public VariantContextWriterBuilder unsetOption(Options option) {
        this.options.remove((Object)option);
        return this;
    }

    public VariantContextWriterBuilder clearOptions() {
        this.options = NO_OPTIONS;
        return this;
    }

    public VariantContextWriter build() {
        VariantContextWriter writer = null;
        OutputType typeToBuild = this.outType;
        if (this.options.contains((Object)Options.FORCE_BCF)) {
            if (FILE_TYPES.contains((Object)this.outType)) {
                typeToBuild = OutputType.BCF;
            } else if (STREAM_TYPES.contains((Object)this.outType)) {
                typeToBuild = OutputType.BCF_STREAM;
            }
        }
        OutputStream outStreamFromFile = this.outStream;
        if (FILE_TYPES.contains((Object)this.outType)) {
            try {
                outStreamFromFile = IOUtil.maybeBufferOutputStream(new FileOutputStream(this.outFile), this.bufferSize);
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeIOException("File not found: " + this.outFile, e2);
            }
            if (this.createMD5) {
                outStreamFromFile = new Md5CalculatingOutputStream(outStreamFromFile, new File(this.outFile.getAbsolutePath() + ".md5"));
            }
        }
        switch (typeToBuild) {
            case UNSPECIFIED: {
                throw new IllegalArgumentException("Must specify file or stream output type.");
            }
            case VCF: {
                if (this.refDict == null && this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("A reference dictionary is required for creating Tribble indices on the fly");
                }
                writer = this.createVCFWriter(this.outFile, outStreamFromFile);
                break;
            }
            case BLOCK_COMPRESSED_VCF: {
                this.idxCreator = this.refDict == null ? new TabixIndexCreator(TabixFormat.VCF) : new TabixIndexCreator(this.refDict, TabixFormat.VCF);
                writer = this.createVCFWriter(this.outFile, new BlockCompressedOutputStream(outStreamFromFile, this.outFile));
                break;
            }
            case BCF: {
                if (this.refDict == null && this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("A reference dictionary is required for creating Tribble indices on the fly");
                }
                writer = this.createBCFWriter(this.outFile, outStreamFromFile);
                break;
            }
            case VCF_STREAM: {
                if (this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("VCF index creation not supported for stream output.");
                }
                writer = this.createVCFWriter(null, this.outStream);
                break;
            }
            case BCF_STREAM: {
                if (this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("BCF index creation not supported for stream output.");
                }
                writer = this.createBCFWriter(null, this.outStream);
            }
        }
        if (this.options.contains((Object)Options.USE_ASYNC_IO)) {
            writer = new AsyncVariantContextWriter(writer, 2000);
        }
        return writer;
    }

    private void determineOutputTypeFromFilename() {
        this.outType = this.isBCF(this.outFile) ? OutputType.BCF : (this.isCompressedVCF(this.outFile) ? OutputType.BLOCK_COMPRESSED_VCF : (this.isVCF(this.outFile) ? OutputType.VCF : OutputType.UNSPECIFIED));
    }

    private boolean isVCF(File outFile) {
        return outFile != null && outFile.getName().endsWith(".vcf");
    }

    private boolean isBCF(File outFile) {
        return outFile != null && outFile.getName().endsWith(".bcf");
    }

    private boolean isCompressedVCF(File outFile) {
        if (outFile == null) {
            return false;
        }
        return AbstractFeatureReader.hasBlockCompressedExtension(outFile);
    }

    private VariantContextWriter createVCFWriter(File writerFile, OutputStream writerStream) {
        if (this.idxCreator == null) {
            return new VCFWriter(writerFile, writerStream, this.refDict, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), this.options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), this.options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD));
        }
        return new VCFWriter(writerFile, writerStream, this.refDict, this.idxCreator, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), this.options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), this.options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD));
    }

    private VariantContextWriter createBCFWriter(File writerFile, OutputStream writerStream) {
        if (this.idxCreator == null) {
            return new BCF2Writer(writerFile, writerStream, this.refDict, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES));
        }
        return new BCF2Writer(writerFile, writerStream, this.refDict, this.idxCreator, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES));
    }

    public static enum OutputType {
        UNSPECIFIED,
        VCF,
        BCF,
        BLOCK_COMPRESSED_VCF,
        VCF_STREAM,
        BCF_STREAM;

    }
}

