/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.TabixReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class TabixUtils {
    public static final String STANDARD_INDEX_EXTENSION = ".tbi";

    public static boolean less64(long u2, long v2) {
        return u2 < v2 ^ u2 < 0L ^ v2 < 0L;
    }

    public static SAMSequenceDictionary getSequenceDictionary(File tabixIndex) {
        if (tabixIndex == null) {
            throw new IllegalArgumentException();
        }
        try {
            BlockCompressedInputStream is = new BlockCompressedInputStream(tabixIndex);
            byte[] buf = new byte[32];
            is.read(buf, 0, 32);
            int len = TabixReader.readInt(is);
            buf = new byte[len];
            is.read(buf);
            ArrayList<SAMSequenceRecord> sequences = new ArrayList<SAMSequenceRecord>();
            int j2 = 0;
            for (int i2 = 0; i2 < buf.length; ++i2) {
                if (buf[i2] != 0) continue;
                byte[] b2 = new byte[i2 - j2];
                System.arraycopy(buf, j2, b2, 0, b2.length);
                sequences.add(new SAMSequenceRecord(new String(b2)));
                j2 = i2 + 1;
            }
            is.close();
            return new SAMSequenceDictionary(sequences);
        }
        catch (Exception e2) {
            throw new TribbleException("Unable to read tabix index: " + e2.getMessage());
        }
    }

    public static class TIntv {
        public int tid;
        public int beg;
        public int end;
    }

    public static class TIndex {
        public HashMap<Integer, TPair64[]> b;
        public long[] l;
    }

    public static class TPair64
    implements Comparable<TPair64> {
        public long u;
        public long v;

        public TPair64(long _u, long _v) {
            this.u = _u;
            this.v = _v;
        }

        public TPair64(TPair64 p2) {
            this.u = p2.u;
            this.v = p2.v;
        }

        @Override
        public int compareTo(TPair64 p2) {
            return this.u == p2.u ? 0 : (this.u < p2.u ^ this.u < 0L ^ p2.u < 0L ? -1 : 1);
        }
    }
}

