/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OverlapDetector<T> {
    private Map<Object, IntervalTree<Set<T>>> cache = new HashMap<Object, IntervalTree<Set<T>>>();
    private final int lhsBuffer;
    private final int rhsBuffer;

    public OverlapDetector(int lhsBuffer, int rhsBuffer) {
        this.lhsBuffer = lhsBuffer;
        this.rhsBuffer = rhsBuffer;
    }

    public void addLhs(T object, Interval interval) {
        Set alreadyThere;
        String seqId = interval.getSequence();
        IntervalTree<Set<Object>> tree = this.cache.get(seqId);
        if (tree == null) {
            tree = new IntervalTree();
            this.cache.put(seqId, tree);
        }
        int start = interval.getStart() + this.lhsBuffer;
        int end = interval.getEnd() - this.lhsBuffer;
        HashSet<T> objects = new HashSet<T>();
        objects.add(object);
        if (start <= end && (alreadyThere = (Set)tree.put(start, end, objects)) != null) {
            alreadyThere.add(object);
            tree.put(start, end, alreadyThere);
        }
    }

    public void addAll(List<T> objects, List<Interval> intervals) {
        if (objects.size() != intervals.size()) {
            throw new IllegalArgumentException("Objects and intervals must be the same size.");
        }
        for (int i2 = 0; i2 < objects.size(); ++i2) {
            this.addLhs(objects.get(i2), intervals.get(i2));
        }
    }

    public Collection<T> getAll() {
        HashSet all = new HashSet();
        for (IntervalTree<Set<T>> tree : this.cache.values()) {
            for (IntervalTree.Node<Set<T>> node : tree) {
                all.addAll(node.getValue());
            }
        }
        return all;
    }

    public Collection<T> getOverlaps(Interval rhs) {
        ArrayList matches = new ArrayList();
        String seqId = rhs.getSequence();
        IntervalTree<Set<T>> tree = this.cache.get(seqId);
        int start = rhs.getStart() + this.rhsBuffer;
        int end = rhs.getEnd() - this.rhsBuffer;
        if (tree != null && start <= end) {
            Iterator<IntervalTree.Node<Set<T>>> it = tree.overlappers(start, end);
            while (it.hasNext()) {
                IntervalTree.Node<Set<T>> node = it.next();
                matches.addAll(node.getValue());
            }
        }
        return matches;
    }
}

