/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import java.io.Closeable;
import java.text.MessageFormat;

public interface SamReader
extends Iterable<SAMRecord>,
Closeable {
    public SAMFileHeader getFileHeader();

    public Type type();

    public boolean hasIndex();

    public Indexing indexing();

    public SAMRecordIterator iterator();

    public SAMRecordIterator query(String var1, int var2, int var3, boolean var4);

    public SAMRecordIterator queryOverlapping(String var1, int var2, int var3);

    public SAMRecordIterator queryContained(String var1, int var2, int var3);

    public SAMRecordIterator query(QueryInterval[] var1, boolean var2);

    public SAMRecordIterator queryOverlapping(QueryInterval[] var1);

    public SAMRecordIterator queryContained(QueryInterval[] var1);

    public SAMRecordIterator queryUnmapped();

    public SAMRecordIterator queryAlignmentStart(String var1, int var2);

    public SAMRecord queryMate(SAMRecord var1);

    public static class AssertingIterator
    implements SAMRecordIterator {
        private final CloseableIterator<SAMRecord> wrappedIterator;
        private SAMRecord previous = null;
        private SAMRecordComparator comparator = null;

        static AssertingIterator of(CloseableIterator<SAMRecord> iterator) {
            return new AssertingIterator(iterator);
        }

        public AssertingIterator(CloseableIterator<SAMRecord> iterator) {
            this.wrappedIterator = iterator;
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            if (sortOrder == null || sortOrder == SAMFileHeader.SortOrder.unsorted) {
                this.comparator = null;
                return this;
            }
            this.comparator = sortOrder.getComparatorInstance();
            return this;
        }

        @Override
        public SAMRecord next() {
            SAMRecord result = (SAMRecord)this.wrappedIterator.next();
            if (this.comparator != null) {
                if (this.previous != null && this.comparator.fileOrderCompare(this.previous, result) > 0) {
                    throw new IllegalStateException(MessageFormat.format("Records {0} ({1}:{2}) should come after {3} ({4}:{5}) when sorting with {6}", this.previous.getReadName(), this.previous.getReferenceName(), this.previous.getAlignmentStart(), result.getReadName(), result.getReferenceName(), result.getAlignmentStart(), this.comparator.getClass().getName()));
                }
                this.previous = result;
            }
            return result;
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
        }
    }

    public static class PrimitiveSamReaderToSamReaderAdapter
    implements SamReader,
    Indexing {
        final PrimitiveSamReader p;

        public PrimitiveSamReaderToSamReaderAdapter(PrimitiveSamReader p2) {
            this.p = p2;
        }

        PrimitiveSamReader underlyingReader() {
            return this.p;
        }

        @Override
        public SAMRecordIterator queryOverlapping(String sequence, int start, int end) {
            return this.query(sequence, start, end, false);
        }

        @Override
        public SAMRecordIterator queryOverlapping(QueryInterval[] intervals) {
            return this.query(intervals, false);
        }

        @Override
        public SAMRecordIterator queryContained(String sequence, int start, int end) {
            return this.query(sequence, start, end, true);
        }

        @Override
        public SAMRecordIterator queryContained(QueryInterval[] intervals) {
            return this.query(intervals, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SAMRecord queryMate(SAMRecord rec) {
            if (!rec.getReadPairedFlag()) {
                throw new IllegalArgumentException("queryMate called for unpaired read.");
            }
            if (rec.getFirstOfPairFlag() == rec.getSecondOfPairFlag()) {
                throw new IllegalArgumentException("SAMRecord must be either first and second of pair, but not both.");
            }
            boolean firstOfPair = rec.getFirstOfPairFlag();
            SAMRecordIterator it = rec.getMateReferenceIndex() == -1 ? this.queryUnmapped() : this.queryAlignmentStart(rec.getMateReferenceName(), rec.getMateAlignmentStart());
            try {
                SAMRecord mateRec = null;
                while (it.hasNext()) {
                    SAMRecord next = (SAMRecord)it.next();
                    if (!next.getReadPairedFlag()) {
                        if (!rec.getReadName().equals(next.getReadName())) continue;
                        throw new SAMFormatException("Paired and unpaired reads with same name: " + rec.getReadName());
                    }
                    if ((!firstOfPair ? next.getSecondOfPairFlag() : next.getFirstOfPairFlag()) || !rec.getReadName().equals(next.getReadName())) continue;
                    if (mateRec != null) {
                        throw new SAMFormatException("Multiple SAMRecord with read name " + rec.getReadName() + " for " + (firstOfPair ? "second" : "first") + " end.");
                    }
                    mateRec = next;
                }
                SAMRecord sAMRecord = mateRec;
                return sAMRecord;
            }
            finally {
                it.close();
            }
        }

        @Override
        public boolean hasBrowseableIndex() {
            return this.hasIndex() && this.getIndex() instanceof BrowseableBAMIndex;
        }

        @Override
        public BrowseableBAMIndex getBrowseableIndex() {
            BAMIndex index = this.getIndex();
            if (!(index instanceof BrowseableBAMIndex)) {
                throw new SAMException("Cannot return index: index created by BAM is not browseable.");
            }
            return (BrowseableBAMIndex)BrowseableBAMIndex.class.cast(index);
        }

        @Override
        public SAMRecordIterator iterator() {
            return new AssertingIterator(this.p.getIterator());
        }

        @Override
        public SAMRecordIterator iterator(SAMFileSpan chunks) {
            return new AssertingIterator(this.p.getIterator(chunks));
        }

        @Override
        public void close() {
            this.p.close();
        }

        @Override
        public SAMFileSpan getFilePointerSpanningReads() {
            return this.p.getFilePointerSpanningReads();
        }

        @Override
        public SAMFileHeader getFileHeader() {
            return this.p.getFileHeader();
        }

        @Override
        public Type type() {
            return this.p.type();
        }

        @Override
        public boolean hasIndex() {
            return this.p.hasIndex();
        }

        @Override
        public Indexing indexing() {
            return this;
        }

        @Override
        public BAMIndex getIndex() {
            return this.p.getIndex();
        }

        @Override
        public SAMRecordIterator query(QueryInterval[] intervals, boolean contained) {
            return AssertingIterator.of(this.p.query(intervals, contained));
        }

        @Override
        public SAMRecordIterator query(String sequence, int start, int end, boolean contained) {
            return this.query(new QueryInterval[]{new QueryInterval(this.getFileHeader().getSequenceIndex(sequence), start, end)}, contained);
        }

        @Override
        public SAMRecordIterator queryUnmapped() {
            return AssertingIterator.of(this.p.queryUnmapped());
        }

        @Override
        public SAMRecordIterator queryAlignmentStart(String sequence, int start) {
            return AssertingIterator.of(this.p.queryAlignmentStart(sequence, start));
        }
    }

    public static interface PrimitiveSamReader {
        public Type type();

        public boolean hasIndex();

        public BAMIndex getIndex();

        public SAMFileHeader getFileHeader();

        public CloseableIterator<SAMRecord> getIterator();

        public CloseableIterator<SAMRecord> getIterator(SAMFileSpan var1);

        public SAMFileSpan getFilePointerSpanningReads();

        public CloseableIterator<SAMRecord> query(QueryInterval[] var1, boolean var2);

        public CloseableIterator<SAMRecord> queryAlignmentStart(String var1, int var2);

        public CloseableIterator<SAMRecord> queryUnmapped();

        public void close();

        public ValidationStringency getValidationStringency();
    }

    public static interface Indexing {
        public BAMIndex getIndex();

        public boolean hasBrowseableIndex();

        public BrowseableBAMIndex getBrowseableIndex();

        public SAMRecordIterator iterator(SAMFileSpan var1);

        public SAMFileSpan getFilePointerSpanningReads();
    }

    public static abstract class Type {
        public static Type BAM_TYPE = new TypeImpl("BAM", "bam", "bai");
        public static Type SAM_TYPE = new TypeImpl("SAM", "sam", null);

        abstract String name();

        abstract String fileExtension();

        abstract String indexExtension();

        static class TypeImpl
        extends Type {
            final String name;
            final String fileExtension;
            final String indexExtension;

            TypeImpl(String name, String fileExtension, String indexExtension) {
                this.name = name;
                this.fileExtension = fileExtension;
                this.indexExtension = indexExtension;
            }

            @Override
            String name() {
                return this.name;
            }

            @Override
            String fileExtension() {
                return this.fileExtension;
            }

            @Override
            String indexExtension() {
                return this.indexExtension;
            }

            public String toString() {
                return String.format("TypeImpl{name='%s', fileExtension='%s', indexExtension='%s'}", this.name, this.fileExtension, this.indexExtension);
            }
        }
    }
}

