/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;
import picard.sam.AbstractAlignmentMerger;

public class CleanSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Read SAM and perform various fix-ups.  " + "Currently, the only fix-ups are 1: to soft-clip an alignment that hangs off the end of its reference sequence; " + "and 2: to set MAPQ to 0 if a read is unmapped.";
    @Option(shortName="I", doc="Input SAM to be cleaned.")
    public File INPUT;
    @Option(shortName="O", doc="Where to write cleaned SAM.")
    public File OUTPUT;

    public static void main(String[] argv) {
        new CleanSam().instanceMainWithExit(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        ValidationStringency originalStringency = SAMFileReader.getDefaultValidationStringency();
        if (this.VALIDATION_STRINGENCY == ValidationStringency.STRICT) {
            SAMFileReader.setDefaultValidationStringency(ValidationStringency.LENIENT);
        }
        try {
            SAMFileReader reader = new SAMFileReader(this.INPUT);
            SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, this.OUTPUT);
            SAMRecordIterator it = reader.iterator();
            ProgressLogger progress = new ProgressLogger(Log.getInstance(CleanSam.class));
            while (it.hasNext()) {
                SAMRecord rec = (SAMRecord)it.next();
                AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(rec);
                if (rec.getReadUnmappedFlag() && 0 != rec.getMappingQuality()) {
                    rec.setMappingQuality(0);
                }
                writer.addAlignment(rec);
                progress.record(rec);
            }
            writer.close();
            it.close();
        }
        finally {
            SAMFileReader.setDefaultValidationStringency(originalStringency);
        }
        return 0;
    }
}

