/*
 * Decompiled with CFR 0.152.
 */
package picard.reference;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SequenceUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class ExtractSequences
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Extracts one or more intervals described in an interval_list file from a given reference sequence and writes them out in FASTA format. Requires a fasta index file to be present.";
    @Option(doc="Interval list describing intervals to be extracted from the reference sequence.")
    public File INTERVAL_LIST;
    @Option(shortName="R", doc="Reference sequence file.")
    public File REFERENCE_SEQUENCE;
    @Option(shortName="O", doc="Output fasta file.")
    public File OUTPUT;
    @Option(doc="Maximum line length for sequence data.")
    public int LINE_LENGTH = 80;

    public static void main(String[] args) {
        new ExtractSequences().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INTERVAL_LIST);
        IOUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        IntervalList intervals = IntervalList.fromFile(this.INTERVAL_LIST);
        ReferenceSequenceFile ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
        SequenceUtil.assertSequenceDictionariesEqual(intervals.getHeader().getSequenceDictionary(), ref.getSequenceDictionary());
        BufferedWriter out = IOUtil.openFileForBufferedWriting(this.OUTPUT);
        for (Interval interval : intervals) {
            ReferenceSequence seq = ref.getSubsequenceAt(interval.getSequence(), interval.getStart(), interval.getEnd());
            byte[] bases = seq.getBases();
            if (interval.isNegativeStrand()) {
                SequenceUtil.reverseComplement(bases);
            }
            try {
                out.write(">");
                out.write(interval.getName());
                out.write("\n");
                for (int i2 = 0; i2 < bases.length; ++i2) {
                    if (i2 > 0 && i2 % this.LINE_LENGTH == 0) {
                        out.write("\n");
                    }
                    out.write(bases[i2]);
                }
                out.write("\n");
            }
            catch (IOException ioe) {
                throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), ioe);
            }
        }
        CloserUtil.close(out);
        return 0;
    }
}

