/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import picard.PicardException;
import picard.analysis.BaseDistributionByCycleMetrics;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;
import picard.util.RExecutor;

public class CollectBaseDistributionByCycle
extends SinglePassSamProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Program to chart the nucleotide distribution per cycle in a SAM or BAM file.";
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Option(doc="If set to true, calculate the base distribution over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="If set to true calculate the base distribution over PF reads only.")
    public boolean PF_READS_ONLY = false;
    private HistogramGenerator hist;
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(CollectBaseDistributionByCycle.class);

    public static void main(String[] args) {
        System.exit(new CollectBaseDistributionByCycle().instanceMain(args));
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable(this.CHART_OUTPUT);
        List<SAMReadGroupRecord> readGroups = header.getReadGroups();
        if (readGroups.size() == 1) {
            this.plotSubtitle = StringUtil.asEmptyIfNull(readGroups.get(0).getLibrary());
        }
        this.hist = new HistogramGenerator();
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.isSecondaryOrSupplementary()) {
            return;
        }
        this.hist.addRecord(rec);
    }

    @Override
    protected void finish() {
        MetricsFile metrics = this.getMetricsFile();
        this.hist.addToMetricsFile(metrics);
        metrics.write(this.OUTPUT);
        if (this.hist.isEmpty()) {
            this.log.warn("No valid bases found in input file. No plot will be produced.");
        } else {
            int rResult = RExecutor.executeFromClasspath("picard/analysis/baseDistributionByCycle.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle);
            if (rResult != 0) {
                throw new PicardException("R script nucleotideDistributionByCycle.R failed with return code " + rResult);
            }
        }
    }

    private class HistogramGenerator {
        private int maxLengthSoFar = 0;
        private final long[][] firstReadTotalsByCycle = new long[5][this.maxLengthSoFar];
        private long[] firstReadCountsByCycle = new long[this.maxLengthSoFar];
        private final long[][] secondReadTotalsByCycle = new long[5][this.maxLengthSoFar];
        private long[] secondReadCountsByCycle = new long[this.maxLengthSoFar];
        private boolean seenSecondEnd = false;

        private HistogramGenerator() {
        }

        private int baseToInt(byte base) {
            switch (base) {
                case 65: 
                case 97: {
                    return 0;
                }
                case 67: 
                case 99: {
                    return 1;
                }
                case 71: 
                case 103: {
                    return 2;
                }
                case 84: 
                case 116: {
                    return 3;
                }
            }
            return 4;
        }

        void addRecord(SAMRecord rec) {
            byte[] bases = rec.getReadBases();
            if (bases == null) {
                return;
            }
            int length = bases.length;
            boolean rc = rec.getReadNegativeStrandFlag();
            this.ensureArraysBigEnough(length + 1);
            if (rec.getReadPairedFlag() && rec.getSecondOfPairFlag()) {
                this.seenSecondEnd = true;
                for (int i2 = 0; i2 < length; ++i2) {
                    int cycle = rc ? length - i2 : i2 + 1;
                    long[] lArray = this.secondReadTotalsByCycle[this.baseToInt(bases[i2])];
                    int n2 = cycle;
                    lArray[n2] = lArray[n2] + 1L;
                    int n3 = cycle;
                    this.secondReadCountsByCycle[n3] = this.secondReadCountsByCycle[n3] + 1L;
                }
            } else {
                for (int i3 = 0; i3 < length; ++i3) {
                    int cycle = rc ? length - i3 : i3 + 1;
                    long[] lArray = this.firstReadTotalsByCycle[this.baseToInt(bases[i3])];
                    int n4 = cycle;
                    lArray[n4] = lArray[n4] + 1L;
                    int n5 = cycle;
                    this.firstReadCountsByCycle[n5] = this.firstReadCountsByCycle[n5] + 1L;
                }
            }
        }

        private void ensureArraysBigEnough(int length) {
            if (length > this.maxLengthSoFar) {
                for (int i2 = 0; i2 < 5; ++i2) {
                    this.firstReadTotalsByCycle[i2] = Arrays.copyOf(this.firstReadTotalsByCycle[i2], length);
                    this.secondReadTotalsByCycle[i2] = Arrays.copyOf(this.secondReadTotalsByCycle[i2], length);
                }
                this.firstReadCountsByCycle = Arrays.copyOf(this.firstReadCountsByCycle, length);
                this.secondReadCountsByCycle = Arrays.copyOf(this.secondReadCountsByCycle, length);
                this.maxLengthSoFar = length;
            }
        }

        boolean isEmpty() {
            return this.maxLengthSoFar == 0;
        }

        public void addToMetricsFile(MetricsFile<BaseDistributionByCycleMetrics, ?> metrics) {
            BaseDistributionByCycleMetrics metric;
            int i2;
            int firstReadLength = 0;
            for (i2 = 0; i2 < this.maxLengthSoFar; ++i2) {
                if (0L == this.firstReadCountsByCycle[i2]) continue;
                metric = new BaseDistributionByCycleMetrics();
                metric.READ_END = 1;
                metric.CYCLE = i2;
                metric.PCT_A = 100.0 * (double)this.firstReadTotalsByCycle[0][i2] / (double)this.firstReadCountsByCycle[i2];
                metric.PCT_C = 100.0 * (double)this.firstReadTotalsByCycle[1][i2] / (double)this.firstReadCountsByCycle[i2];
                metric.PCT_G = 100.0 * (double)this.firstReadTotalsByCycle[2][i2] / (double)this.firstReadCountsByCycle[i2];
                metric.PCT_T = 100.0 * (double)this.firstReadTotalsByCycle[3][i2] / (double)this.firstReadCountsByCycle[i2];
                metric.PCT_N = 100.0 * (double)this.firstReadTotalsByCycle[4][i2] / (double)this.firstReadCountsByCycle[i2];
                metrics.addMetric(metric);
                firstReadLength = i2;
            }
            if (this.seenSecondEnd) {
                for (i2 = 0; i2 < this.maxLengthSoFar; ++i2) {
                    if (0L == this.secondReadCountsByCycle[i2]) continue;
                    metric = new BaseDistributionByCycleMetrics();
                    metric.READ_END = 2;
                    metric.CYCLE = i2 + firstReadLength;
                    metric.PCT_A = 100.0 * (double)this.secondReadTotalsByCycle[0][i2] / (double)this.secondReadCountsByCycle[i2];
                    metric.PCT_C = 100.0 * (double)this.secondReadTotalsByCycle[1][i2] / (double)this.secondReadCountsByCycle[i2];
                    metric.PCT_G = 100.0 * (double)this.secondReadTotalsByCycle[2][i2] / (double)this.secondReadCountsByCycle[i2];
                    metric.PCT_T = 100.0 * (double)this.secondReadTotalsByCycle[3][i2] / (double)this.secondReadCountsByCycle[i2];
                    metric.PCT_N = 100.0 * (double)this.secondReadTotalsByCycle[4][i2] / (double)this.secondReadCountsByCycle[i2];
                    metrics.addMetric(metric);
                }
            }
        }
    }
}

