/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.tribble.readers.AsciiLineReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.BisulfiteCounts;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public abstract class BaseAlignmentCounts
implements AlignmentCounts {
    private static Logger log = Logger.getLogger(BaseAlignmentCounts.class);
    public static final char[] nucleotides = new char[]{'a', 'c', 'g', 't', 'n'};
    private static Map<String, Set<Integer>> knownSnps;
    int start;
    int end;
    protected boolean countDeletedBasesCovered = false;
    private BisulfiteCounts bisulfiteCounts;

    public BaseAlignmentCounts(int start, int end, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        PreferenceManager prefs = PreferenceManager.getInstance();
        String snpsFile = prefs.get("KNOWN_SNPS_FILE", null);
        if (snpsFile != null && knownSnps == null) {
            BaseAlignmentCounts.loadKnownSnps(snpsFile);
        }
        this.start = start;
        this.end = end;
        this.countDeletedBasesCovered = prefs.getAsBoolean("SAM.COUNT_DELETED_BASES_COVERED");
        if (!Globals.isHeadless() && bisulfiteContext != null) {
            this.bisulfiteCounts = new BisulfiteCounts(bisulfiteContext, GenomeManager.getInstance().getCurrentGenome());
        }
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public String getChr() {
        return null;
    }

    @Override
    public BisulfiteCounts getBisulfiteCounts() {
        return this.bisulfiteCounts;
    }

    @Override
    public void incCounts(Alignment alignment) {
        if (this.bisulfiteCounts != null) {
            this.bisulfiteCounts.incrementCounts(alignment);
        }
        int alignmentStart = alignment.getAlignmentStart();
        int alignmentEnd = alignment.getAlignmentEnd();
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        if (blocks != null) {
            AlignmentBlock[] insertions;
            int lastBlockEnd = -1;
            int gapIdx = 0;
            char[] gapTypes = alignment.getGapTypes();
            for (AlignmentBlock b2 : blocks) {
                if (b2.getEnd() < this.start) continue;
                if (b2.getStart() > this.end) break;
                Strand strand = alignment.getReadStrand();
                if (b2.isSoftClipped() || strand == Strand.NONE) continue;
                boolean isNegativeStrand = strand == Strand.NEGATIVE;
                this.incBlockCounts(b2, isNegativeStrand);
                if (gapTypes != null && lastBlockEnd >= 0 && gapIdx < gapTypes.length) {
                    if (gapTypes[gapIdx] == 'D') {
                        for (int pos = lastBlockEnd; pos < b2.getStart(); ++pos) {
                            this.incrementDeletion(pos, isNegativeStrand);
                        }
                    }
                    ++gapIdx;
                }
                lastBlockEnd = b2.getEnd();
            }
            if ((insertions = alignment.getInsertions()) != null) {
                for (AlignmentBlock insBlock : insertions) {
                    if (insBlock.getEnd() < this.start) continue;
                    if (insBlock.getStart() <= this.end) {
                        this.incrementInsertion(insBlock);
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (int pos = alignmentStart; pos < alignmentEnd; ++pos) {
                byte q2 = 0;
                this.incPositionCount(pos, (byte)110, q2, alignment.isNegativeStrand());
            }
        }
    }

    @Override
    public String getValueStringAt(int pos) {
        if (pos < this.getStart() || pos >= this.getEnd()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int totalCount = this.getTotalCount(pos);
        buf.append("Total count: " + totalCount);
        for (char c2 : nucleotides) {
            int negCount = this.getNegCount(pos, (byte)c2);
            int posCount = this.getPosCount(pos, (byte)c2);
            int count = negCount + posCount;
            int percent = Math.round((float)count * 100.0f / (float)totalCount);
            char cU = Character.toUpperCase(c2);
            buf.append("<br>" + cU + "      : " + count);
            if (count == 0) continue;
            buf.append("  (" + percent + "%,     " + posCount + "+,   " + negCount + "- )");
        }
        int delCount = this.getDelCount(pos);
        int insCount = this.getInsCount(pos);
        buf.append("<br>---------------");
        if (delCount > 0 || insCount > 0) {
            buf.append("<br>DEL: " + delCount);
            buf.append("<br>INS: " + insCount);
        }
        return buf.toString();
    }

    @Override
    public boolean isMismatch(int pos, byte ref, String chr, float snpThreshold) {
        Set<Integer> filteredSnps;
        Set<Integer> set = filteredSnps = knownSnps == null ? null : knownSnps.get(chr);
        if (filteredSnps == null || !filteredSnps.contains(pos + 1)) {
            float threshold = snpThreshold * (float)this.getTotalQuality(pos);
            if (ref > 0) {
                if (ref < 96) {
                    ref = (byte)(ref + 32);
                }
                for (char c2 : nucleotides) {
                    if (c2 == ref || c2 == 'n' || !((float)this.getQuality(pos, (byte)c2) > threshold)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadKnownSnps(String snpFile) {
        if (knownSnps != null) {
            return;
        }
        knownSnps = new HashMap<String, Set<Integer>>();
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(new ResourceLocator(snpFile));
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                String chr = tokens[0];
                Set<Integer> snps = knownSnps.get(chr);
                if (snps == null) {
                    snps = new HashSet<Integer>(10000);
                    knownSnps.put(chr, snps);
                }
                snps.add(new Integer(tokens[1]));
            }
        }
        catch (Exception e2) {
            knownSnps = null;
            log.error("", e2);
            MessageUtils.showMessage("Error loading snps file: " + snpFile + " (" + e2.toString() + ")");
        }
        finally {
            reader.close();
        }
    }

    protected abstract void incPositionCount(int var1, byte var2, byte var3, boolean var4);

    protected abstract void incrementInsertion(AlignmentBlock var1);

    protected abstract void incrementDeletion(int var1, boolean var2);

    protected abstract void incBlockCounts(AlignmentBlock var1, boolean var2);
}

