/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.tls.CombinedHash;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsCompression;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsNullCipher;
import org.bouncycastle.crypto.tls.TlsNullCompression;
import org.bouncycastle.crypto.tls.TlsProtocolHandler;
import org.bouncycastle.crypto.tls.TlsUtils;

class RecordStream {
    private TlsProtocolHandler handler;
    private InputStream is;
    private OutputStream os;
    private TlsCompression readCompression = null;
    private TlsCompression writeCompression = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private TlsClientContext context = null;
    private CombinedHash hash = null;

    RecordStream(TlsProtocolHandler handler, InputStream is, OutputStream os) {
        this.handler = handler;
        this.is = is;
        this.os = os;
        this.writeCompression = this.readCompression = new TlsNullCompression();
        this.writeCipher = this.readCipher = new TlsNullCipher();
    }

    void init(TlsClientContext context) {
        this.context = context;
        this.hash = new CombinedHash(context);
    }

    void clientCipherSpecDecided(TlsCompression tlsCompression, TlsCipher tlsCipher) {
        this.writeCompression = tlsCompression;
        this.writeCipher = tlsCipher;
    }

    void serverClientSpecReceived() {
        this.readCompression = this.writeCompression;
        this.readCipher = this.writeCipher;
    }

    public void readData() throws IOException {
        short type = TlsUtils.readUint8(this.is);
        ProtocolVersion expectedVersion = ProtocolVersion.TLSv10;
        if (!expectedVersion.equals(TlsUtils.readVersion(this.is))) {
            throw new TlsFatalAlert(47);
        }
        int size = TlsUtils.readUint16(this.is);
        byte[] buf = this.decodeAndVerify(type, this.is, size);
        this.handler.processData(type, buf, 0, buf.length);
    }

    protected byte[] decodeAndVerify(short type, InputStream is, int len) throws IOException {
        byte[] buf = new byte[len];
        TlsUtils.readFully(buf, is);
        byte[] decoded = this.readCipher.decodeCiphertext(type, buf, 0, buf.length);
        OutputStream cOut = this.readCompression.decompress(this.buffer);
        if (cOut == this.buffer) {
            return decoded;
        }
        cOut.write(decoded, 0, decoded.length);
        cOut.flush();
        return this.getBufferContents();
    }

    protected void writeMessage(short type, byte[] message, int offset, int len) throws IOException {
        byte[] ciphertext;
        OutputStream cOut;
        if (type == 22) {
            this.updateHandshakeData(message, offset, len);
        }
        if ((cOut = this.writeCompression.compress(this.buffer)) == this.buffer) {
            ciphertext = this.writeCipher.encodePlaintext(type, message, offset, len);
        } else {
            cOut.write(message, offset, len);
            cOut.flush();
            byte[] compressed = this.getBufferContents();
            ciphertext = this.writeCipher.encodePlaintext(type, compressed, 0, compressed.length);
        }
        byte[] writeMessage = new byte[ciphertext.length + 5];
        TlsUtils.writeUint8(type, writeMessage, 0);
        TlsUtils.writeVersion(ProtocolVersion.TLSv10, writeMessage, 1);
        TlsUtils.writeUint16(ciphertext.length, writeMessage, 3);
        System.arraycopy(ciphertext, 0, writeMessage, 5, ciphertext.length);
        this.os.write(writeMessage);
        this.os.flush();
    }

    void updateHandshakeData(byte[] message, int offset, int len) {
        this.hash.update(message, offset, len);
    }

    byte[] getCurrentHash(byte[] sender) {
        boolean isTls;
        CombinedHash d2 = new CombinedHash(this.hash);
        boolean bl = isTls = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (!isTls && sender != null) {
            d2.update(sender, 0, sender.length);
        }
        return RecordStream.doFinal(d2);
    }

    protected void close() throws IOException {
        IOException e2 = null;
        try {
            this.is.close();
        }
        catch (IOException ex) {
            e2 = ex;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            e2 = ex;
        }
        if (e2 != null) {
            throw e2;
        }
    }

    protected void flush() throws IOException {
        this.os.flush();
    }

    private byte[] getBufferContents() {
        byte[] contents = this.buffer.toByteArray();
        this.buffer.reset();
        return contents;
    }

    private static byte[] doFinal(Digest d2) {
        byte[] bs = new byte[d2.getDigestSize()];
        d2.doFinal(bs, 0);
        return bs;
    }
}

