/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ess;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;

public class ContentHints
extends ASN1Object {
    private DERUTF8String contentDescription;
    private ASN1ObjectIdentifier contentType;

    public static ContentHints getInstance(Object o2) {
        if (o2 instanceof ContentHints) {
            return (ContentHints)o2;
        }
        if (o2 != null) {
            return new ContentHints(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private ContentHints(ASN1Sequence seq) {
        ASN1Encodable field = seq.getObjectAt(0);
        if (field.toASN1Primitive() instanceof DERUTF8String) {
            this.contentDescription = DERUTF8String.getInstance(field);
            this.contentType = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(1));
        } else {
            this.contentType = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
        }
    }

    public ContentHints(DERObjectIdentifier contentType) {
        this(new ASN1ObjectIdentifier(contentType.getId()));
    }

    public ContentHints(DERObjectIdentifier contentType, DERUTF8String contentDescription) {
        this(new ASN1ObjectIdentifier(contentType.getId()), contentDescription);
    }

    public ContentHints(ASN1ObjectIdentifier contentType) {
        this.contentType = contentType;
        this.contentDescription = null;
    }

    public ContentHints(ASN1ObjectIdentifier contentType, DERUTF8String contentDescription) {
        this.contentType = contentType;
        this.contentDescription = contentDescription;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public DERUTF8String getContentDescription() {
        return this.contentDescription;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.contentDescription != null) {
            v2.add(this.contentDescription);
        }
        v2.add(this.contentType);
        return new DERSequence(v2);
    }
}

