/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageList
extends DefaultComboBoxModel {
    private static final long serialVersionUID = 436559750018384074L;

    public AbstractDialogPage getPageByFullTitle(String title) {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            AbstractDialogPage page = (AbstractDialogPage)this.getElementAt(i2);
            if (!page.getFullTitle().equals(title)) continue;
            return page;
        }
        return null;
    }

    public int getPageIndexByFullTitle(String title) {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            AbstractDialogPage page = (AbstractDialogPage)this.getElementAt(i2);
            if (!page.getFullTitle().equals(title)) continue;
            return i2;
        }
        return -1;
    }

    public int getPageCount() {
        return this.getSize();
    }

    public void append(AbstractDialogPage page) {
        this.addElement(page);
    }

    public void remove(AbstractDialogPage page) {
        this.removeElement(page);
    }

    public void clear() {
        this.removeAllElements();
    }

    public void insertAfter(AbstractDialogPage page, String title) {
        int index = this.getPageIndexByFullTitle(title);
        if (index == -1 || index == this.getPageCount() - 1) {
            this.append(page);
        } else {
            this.insertElementAt(page, index + 1);
        }
    }

    public AbstractDialogPage getPage(int i2) {
        return (AbstractDialogPage)this.getElementAt(i2);
    }

    public List<String> getPageTitlesAsList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getPageCount(); ++i2) {
            AbstractDialogPage page = this.getPage(i2);
            list.add(page.getTitle());
        }
        return list;
    }

    public AbstractDialogPage getCurrentPage() {
        return (AbstractDialogPage)this.getSelectedItem();
    }

    public void setCurrentPage(AbstractDialogPage page) {
        this.setCurrentPage(page, null);
    }

    protected boolean setCurrentPage(AbstractDialogPage page, Object source) {
        AbstractDialogPage oldPage = this.getCurrentPage();
        if (oldPage != null && !oldPage.equals(page)) {
            oldPage.setAllowClosing(true);
            oldPage.firePageEvent(source, 3200);
            if (!oldPage.allowClosing()) {
                return false;
            }
            oldPage.firePageEvent(source, 3201);
        }
        if (!JideSwingUtilities.equals(oldPage, page)) {
            this.setSelectedItem(page);
        } else {
            AbstractDialogPage newPage = this.getCurrentPage();
            if (newPage != null) {
                newPage.firePageEvent(source, 3199);
            }
        }
        return true;
    }
}

