/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.DialogPageListCellRenderer;
import com.jidesoft.dialog.DialogPageTreeCellRenderer;
import com.jidesoft.dialog.MutableTreeNodeEx;
import com.jidesoft.dialog.PageList;
import com.jidesoft.dialog.ScrollableButtonPanel;
import com.jidesoft.dialog.StandardDialogPane;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MultiplePageDialogPane
extends StandardDialogPane {
    private static final long serialVersionUID = -8968638943947885121L;
    public static final int TAB_STYLE = 0;
    public static final int TREE_STYLE = 1;
    public static final int LIST_STYLE = 2;
    public static final int ICON_STYLE = 3;
    private int _style;
    private PageList _pageList;
    private JComponent _indexPanel;
    private JComponent _pagesPanel;
    private CardLayout _cardLayout;
    private Map<String, MutableTreeNode> _titleNodeMap;
    private JButton _okButton;
    private JButton _cancelButton;
    private JButton _applyButton;
    private AbstractAction _okAction;
    private AbstractAction _cancelAction;
    private TreeCellRenderer _treeCellRenderer;
    private ListCellRenderer _listCellRenderer;
    private JTabbedPane _tabbedPane;
    private String _initialPageTitle;
    public JTree _tree;

    public MultiplePageDialogPane() throws HeadlessException {
        this(0);
    }

    public MultiplePageDialogPane(int style) {
        this.setStyle(style);
    }

    public JComponent createBannerPanel() {
        return null;
    }

    public JComponent createContentPanel() {
        this._indexPanel = this.createIndexPanel();
        this._pagesPanel = this.createPagesPanel();
        if (this._pageList.getPageCount() > 0) {
            if (this.getInitialPageTitle() != null) {
                this.setCurrentPage(this.getInitialPageTitle());
            } else {
                this.setCurrentPage(this._pageList.getPage(0));
            }
        }
        return this.setupContentPanel(this._indexPanel, this._pagesPanel);
    }

    protected JComponent setupContentPanel(JComponent indexPanel, JComponent pagesPanel) {
        JPanel middlePanel = new JPanel(new BorderLayout());
        if (indexPanel != null) {
            middlePanel.add((Component)indexPanel, "Before");
        }
        if (pagesPanel != null) {
            middlePanel.add((Component)pagesPanel, "Center");
        }
        return middlePanel;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        Locale l2 = this.getLocale();
        this._okButton = new JButton(JideSwingUtilities.getOKString(l2));
        this._cancelButton = new JButton(JideSwingUtilities.getCancelString(l2));
        this._applyButton = new JButton();
        this._okButton.setName("OK");
        this._cancelButton.setName("CANCEL");
        this._applyButton.setName("APPLY");
        buttonPanel.addButton((AbstractButton)this._okButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)this._cancelButton, "CANCEL");
        buttonPanel.addButton((AbstractButton)this._applyButton, "ALTERNATIVE");
        this._okButton.setAction(this.getOKAction());
        this._cancelButton.setAction(this.getCancelAction());
        this._applyButton.setAction(new AbstractAction(ButtonResources.getResourceBundle(Locale.getDefault()).getString("Button.apply")){
            private static final long serialVersionUID = 3413994234663396927L;

            public void actionPerformed(ActionEvent e2) {
                if (MultiplePageDialogPane.this.getCurrentPage() != null) {
                    MultiplePageDialogPane.this.getCurrentPage().fireButtonEvent(3302, "APPLY");
                }
            }
        });
        this._applyButton.setMnemonic(ButtonResources.getResourceBundle(Locale.getDefault()).getString("Button.apply.mnemonic").charAt(0));
        this._applyButton.setEnabled(false);
        this.setDefaultCancelAction(this._cancelButton.getAction());
        this.setDefaultAction(this._okButton.getAction());
        return buttonPanel;
    }

    public JButton getOkButton() {
        return this._okButton;
    }

    public JButton getCancelButton() {
        return this._cancelButton;
    }

    public JButton getApplyButton() {
        return this._applyButton;
    }

    public void setCancelAction(AbstractAction cancelAction) {
        if (cancelAction == null) {
            throw new IllegalArgumentException("cancelAction cannot be null");
        }
        this._cancelAction = cancelAction;
        this.setDefaultCancelAction(cancelAction);
        if (this._cancelButton != null) {
            this._cancelButton.setAction(cancelAction);
        }
    }

    public AbstractAction getCancelAction() {
        return this._cancelAction;
    }

    public void setOKAction(AbstractAction okAction) {
        if (okAction == null) {
            throw new IllegalArgumentException("cancelAction cannot be null");
        }
        this._okAction = okAction;
        this.setDefaultAction(okAction);
        if (this._okAction != null) {
            this._okButton.setAction(okAction);
        }
    }

    public AbstractAction getOKAction() {
        return this._okAction;
    }

    protected JComponent createPagesPanel() {
        if (this._style == 0) {
            this._tabbedPane = this.createTabbedPane();
            this._tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e2) {
                    Component selectedComponent = MultiplePageDialogPane.this._tabbedPane.getSelectedComponent();
                    if (selectedComponent instanceof AbstractDialogPage) {
                        MultiplePageDialogPane.this.setCurrentPage((AbstractDialogPage)selectedComponent, MultiplePageDialogPane.this._tabbedPane);
                    }
                }
            });
            int i2 = 0;
            while (i2 < this._pageList.getPageCount()) {
                AbstractDialogPage page = this._pageList.getPage(i2);
                page.addButtonListener(this.getButtonPanel());
                this._tabbedPane.addTab(page.getTitle(), page.getIcon(), page, page.getDescription());
                this._tabbedPane.setEnabledAt(i2, page.isPageEnabled());
                final int index = i2++;
                page.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("enabled".equals(evt.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setEnabledAt(index, Boolean.TRUE.equals(evt.getNewValue()));
                        } else if ("icon".equals(evt.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setIconAt(index, (Icon)evt.getNewValue());
                        } else if ("title".equals(evt.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setTitleAt(index, (String)evt.getNewValue());
                        } else if ("description".equals(evt.getPropertyName())) {
                            MultiplePageDialogPane.this._tabbedPane.setToolTipTextAt(index, (String)evt.getNewValue());
                        }
                    }
                });
            }
            this._pageList.addListDataListener(new ListDataListener(){

                public void intervalAdded(ListDataEvent e2) {
                    for (int i2 = e2.getIndex0(); i2 <= e2.getIndex1(); ++i2) {
                        AbstractDialogPage page = MultiplePageDialogPane.this._pageList.getPage(i2);
                        MultiplePageDialogPane.this._tabbedPane.insertTab(page.getTitle(), page.getIcon(), page, page.getDescription(), i2);
                    }
                }

                public void intervalRemoved(ListDataEvent e2) {
                    for (int i2 = e2.getIndex1(); i2 >= e2.getIndex0(); --i2) {
                        MultiplePageDialogPane.this._tabbedPane.removeTabAt(i2);
                    }
                }

                public void contentsChanged(ListDataEvent e2) {
                }
            });
            return this._tabbedPane;
        }
        final JPanel pagesPanel = new JPanel();
        this._cardLayout = new CardLayout();
        pagesPanel.setLayout(this._cardLayout);
        for (int i3 = 0; i3 < this._pageList.getPageCount(); ++i3) {
            AbstractDialogPage page = this._pageList.getPage(i3);
            page.addButtonListener(this.getButtonPanel());
            page.setName(page.getFullTitle());
            page.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("title".equals(evt.getPropertyName())) {
                        for (int j2 = 0; j2 < pagesPanel.getComponentCount(); ++j2) {
                            Component c2 = pagesPanel.getComponent(j2);
                            Object source = evt.getSource();
                            if (!(source instanceof AbstractDialogPage) || c2 != source) continue;
                            pagesPanel.remove(j2);
                            String fullTitle = ((AbstractDialogPage)source).getFullTitle();
                            pagesPanel.add((AbstractDialogPage)source, fullTitle, j2);
                            ((AbstractDialogPage)source).setName(fullTitle);
                            MultiplePageDialogPane.this.getIndexPanel().repaint();
                            break;
                        }
                    }
                }
            });
            pagesPanel.add((Component)page, page.getFullTitle());
        }
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e2) {
                for (int i2 = e2.getIndex0(); i2 <= e2.getIndex1(); ++i2) {
                    AbstractDialogPage page = MultiplePageDialogPane.this._pageList.getPage(i2);
                    page.setName(page.getFullTitle());
                    pagesPanel.add(page, page.getFullTitle(), i2);
                }
            }

            public void intervalRemoved(ListDataEvent e2) {
                for (int i2 = e2.getIndex1(); i2 >= e2.getIndex0(); --i2) {
                    pagesPanel.remove(i2);
                }
            }

            public void contentsChanged(ListDataEvent e2) {
                Object o2;
                if (e2.getSource() instanceof PageList && (o2 = ((PageList)e2.getSource()).getSelectedItem()) instanceof AbstractDialogPage && ((AbstractDialogPage)o2).isPageEnabled()) {
                    MultiplePageDialogPane.this.setCurrentPage((AbstractDialogPage)o2);
                }
            }
        });
        return pagesPanel;
    }

    protected JTabbedPane createTabbedPane() {
        return new JTabbedPane(1);
    }

    public JComponent createIndexPanel() {
        switch (this._style) {
            case 3: {
                return this.createIconPanel();
            }
            case 2: {
                return this.createListPanel();
            }
            case 1: {
                return this.createTreePanel();
            }
        }
        return null;
    }

    public void setPageList(PageList pageList) {
        this._pageList = pageList;
    }

    public PageList getPageList() {
        return this._pageList;
    }

    public AbstractDialogPage getCurrentPage() {
        return this._pageList.getCurrentPage();
    }

    protected void setCurrentPage(String pageTitle) {
        if (this._pageList != null) {
            this.setCurrentPage(this._pageList.getPageByFullTitle(pageTitle));
        }
    }

    protected void setCurrentPage(AbstractDialogPage currentPage) {
        this.setCurrentPage(currentPage, null);
    }

    protected void setCurrentPage(AbstractDialogPage currentPage, Object source) {
        if (!this._pageList.setCurrentPage(currentPage, source)) {
            return;
        }
        if (currentPage != null) {
            this.showCurrentPage(currentPage);
        }
    }

    protected void showCurrentPage(AbstractDialogPage currentPage) {
        if (currentPage != null) {
            if (this.getStyle() == 0) {
                this._tabbedPane.setSelectedComponent(currentPage);
            } else {
                this._cardLayout.show(this._pagesPanel, currentPage.getFullTitle());
            }
            currentPage.focusDefaultFocusComponent();
        }
    }

    protected MutableTreeNode createTreeNode(AbstractDialogPage dialogPage) {
        return new MutableTreeNodeEx(dialogPage);
    }

    private JComponent createTreePanel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("", true);
        this._titleNodeMap = new HashMap<String, MutableTreeNode>((int)((double)this._pageList.getPageCount() * 0.75));
        for (int i2 = 0; i2 < this._pageList.getPageCount(); ++i2) {
            AbstractDialogPage dialogPage = this._pageList.getPage(i2);
            this.addPage(dialogPage, root, false);
        }
        this._tree = this.createTree(root);
        this.configureTree(this._tree);
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e2) {
                for (int i2 = e2.getIndex0(); i2 <= e2.getIndex1(); ++i2) {
                    AbstractDialogPage dialogPage = MultiplePageDialogPane.this._pageList.getPage(i2);
                    MultiplePageDialogPane.this.addPage(dialogPage, (DefaultMutableTreeNode)MultiplePageDialogPane.this._tree.getModel().getRoot(), true);
                }
            }

            public void intervalRemoved(ListDataEvent e2) {
                Set set = MultiplePageDialogPane.this._titleNodeMap.keySet();
                Vector<String> toBeRemoved = new Vector<String>();
                Iterator<Object> i$ = set.iterator();
                while (i$.hasNext()) {
                    DefaultMutableTreeNode treeNode;
                    String o2;
                    String title = o2 = (String)i$.next();
                    if (MultiplePageDialogPane.this._pageList.getPageByFullTitle(title) != null || (treeNode = (DefaultMutableTreeNode)MultiplePageDialogPane.this._titleNodeMap.get(title)) == null) continue;
                    toBeRemoved.add(title);
                    DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode.getParent();
                    if (parentNode == null) continue;
                    int index = parentNode.getIndex(treeNode);
                    parentNode.remove(treeNode);
                    ((DefaultTreeModel)MultiplePageDialogPane.this._tree.getModel()).nodesWereRemoved(parentNode, new int[]{index}, new Object[]{treeNode});
                }
                for (String o2 : toBeRemoved) {
                    MultiplePageDialogPane.this._titleNodeMap.remove(o2);
                }
            }

            public void contentsChanged(ListDataEvent e2) {
                TreeNode node;
                if (e2.getIndex0() == -1 && e2.getIndex1() == -1 && e2.getType() == 0 && MultiplePageDialogPane.this._titleNodeMap != null && MultiplePageDialogPane.this._pageList.getCurrentPage() != null && (node = (TreeNode)MultiplePageDialogPane.this._titleNodeMap.get(MultiplePageDialogPane.this._pageList.getCurrentPage().getFullTitle())) != null) {
                    ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                    while (node != null) {
                        list.add(0, node);
                        node = node.getParent();
                    }
                    TreePath treePath = new TreePath(list.toArray(new TreeNode[list.size()]));
                    MultiplePageDialogPane.this._tree.getSelectionModel().setSelectionPath(treePath);
                }
            }
        });
        JPanel indexPanel = new JPanel(new BorderLayout());
        indexPanel.add((Component)new JScrollPane(this._tree), "Center");
        return indexPanel;
    }

    protected JTree createTree(DefaultMutableTreeNode root) {
        UIManager.put("Tree.hash", Color.white);
        return new JTree(root);
    }

    protected void configureTree(final JTree tree) {
        tree.setToggleClickCount(1);
        tree.setCellRenderer(this.createTreeCellRenderer());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(false);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e2) {
                if (tree.getSelectionPath() == null) {
                    return;
                }
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)tree.getSelectionPath().getLastPathComponent();
                while (!treeNode.isLeaf()) {
                    final DefaultMutableTreeNode tn = treeNode;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            tree.expandPath(new TreePath(tn.getPath()));
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    treeNode = (DefaultMutableTreeNode)treeNode.getChildAt(0);
                }
                Object userObject = treeNode.getUserObject();
                if (userObject instanceof AbstractDialogPage && !userObject.equals(MultiplePageDialogPane.this.getCurrentPage()) && ((AbstractDialogPage)userObject).isPageEnabled()) {
                    MultiplePageDialogPane.this.setCurrentPage((AbstractDialogPage)userObject, tree);
                    if (MultiplePageDialogPane.this.getCurrentPage() != userObject) {
                        // empty if block
                    }
                }
            }
        });
    }

    private void addPage(final AbstractDialogPage dialogPage, DefaultMutableTreeNode root, boolean fireEvent) {
        if (dialogPage == null) {
            return;
        }
        final MutableTreeNode treeNode = this.createTreeNode(dialogPage);
        if (treeNode instanceof MutableTreeNodeEx) {
            ((MutableTreeNodeEx)treeNode).setEnabled(dialogPage.isPageEnabled());
        }
        if (dialogPage.getParentPage() == null) {
            this._titleNodeMap.put(dialogPage.getFullTitle(), treeNode);
            root.add(treeNode);
            if (fireEvent) {
                ((DefaultTreeModel)this._tree.getModel()).nodesWereInserted(root, new int[]{root.getIndex(treeNode)});
            }
        } else {
            this._titleNodeMap.put(dialogPage.getFullTitle(), treeNode);
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this._titleNodeMap.get(dialogPage.getParentPage().getFullTitle());
            if (parentNode != null) {
                parentNode.add(treeNode);
                if (fireEvent) {
                    ((DefaultTreeModel)this._tree.getModel()).nodesWereInserted(parentNode, new int[]{parentNode.getIndex(treeNode)});
                }
            }
        }
        dialogPage.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("icon".equals(evt.getPropertyName()) && treeNode instanceof MutableTreeNodeEx) {
                    ((MutableTreeNodeEx)treeNode).setEnabled(dialogPage.isPageEnabled());
                }
            }
        });
    }

    private JComponent createListPanel() {
        final DefaultListModel<AbstractDialogPage> listModel = new DefaultListModel<AbstractDialogPage>();
        for (int i2 = 0; i2 < this._pageList.getPageCount(); ++i2) {
            AbstractDialogPage optionsPanel = this._pageList.getPage(i2);
            listModel.addElement(optionsPanel);
        }
        final JList list = this.createList(listModel);
        if (list.getModel().getSize() > 0) {
            list.setSelectedIndex(0);
        }
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (list.getSelectedValue() == MultiplePageDialogPane.this.getCurrentPage()) {
                    return;
                }
                if (!e2.getValueIsAdjusting()) {
                    AbstractDialogPage page = (AbstractDialogPage)list.getSelectedValue();
                    if (page != null) {
                        MultiplePageDialogPane.this.setCurrentPage(page, list);
                        if (MultiplePageDialogPane.this.getCurrentPage() != page) {
                            list.setSelectedValue(MultiplePageDialogPane.this.getCurrentPage(), true);
                        }
                    } else {
                        list.setSelectedIndex(e2.getLastIndex());
                    }
                }
            }
        });
        list.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 10));
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e2) {
                for (int i2 = e2.getIndex0(); i2 <= e2.getIndex1(); ++i2) {
                    AbstractDialogPage optionsPanel = MultiplePageDialogPane.this._pageList.getPage(i2);
                    listModel.add(i2, optionsPanel);
                }
            }

            public void intervalRemoved(ListDataEvent e2) {
                for (int i2 = e2.getIndex1(); i2 >= e2.getIndex0(); --i2) {
                    listModel.remove(i2);
                }
            }

            public void contentsChanged(ListDataEvent e2) {
                if (e2.getIndex0() == -1 && e2.getIndex1() == -1 && e2.getType() == 0) {
                    int index = MultiplePageDialogPane.this._pageList.getPageIndexByFullTitle(MultiplePageDialogPane.this._pageList.getCurrentPage().getFullTitle());
                    list.setSelectedIndex(index);
                }
            }
        });
        JPanel indexPanel = new JPanel(new BorderLayout(4, 4));
        indexPanel.add((Component)new JideScrollPane(list), "Center");
        indexPanel.setOpaque(false);
        return indexPanel;
    }

    protected JList createList(DefaultListModel listModel) {
        JList list = new JList(listModel);
        list.setCellRenderer(this.createListCellRenderer());
        return list;
    }

    protected JComponent createIconPanel() {
        final ButtonPanel buttonsPanel = this.createIconButtonPanel();
        buttonsPanel.setGroupGap(0);
        buttonsPanel.setButtonGap(0);
        final ButtonGroup group = new ButtonGroup();
        for (int i2 = 0; i2 < this._pageList.getPageCount(); ++i2) {
            final AbstractDialogPage optionsPanel = this._pageList.getPage(i2);
            final JideButton button = this.createIconButton(optionsPanel.getTitle(), optionsPanel.getIcon());
            button.setToolTipText(optionsPanel.getDescription());
            button.setEnabled(optionsPanel.isPageEnabled());
            button.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -8913013217983540816L;

                public void actionPerformed(ActionEvent e2) {
                    MultiplePageDialogPane.this.setCurrentPage(optionsPanel, buttonsPanel);
                    if (MultiplePageDialogPane.this.getCurrentPage() == optionsPanel) {
                        group.setSelected(button.getModel(), true);
                    }
                }
            });
            optionsPanel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        button.setEnabled(Boolean.TRUE.equals(evt.getNewValue()));
                    } else if ("icon".equals(evt.getPropertyName())) {
                        button.setIcon((Icon)evt.getNewValue());
                    } else if ("title".equals(evt.getPropertyName())) {
                        button.setText((String)evt.getNewValue());
                    } else if ("description".equals(evt.getPropertyName())) {
                        button.setToolTipText((String)evt.getNewValue());
                    }
                }
            });
            buttonsPanel.addButton(button);
            group.add(button);
            if (i2 != 0) continue;
            group.setSelected(button.getModel(), true);
        }
        buttonsPanel.setOpaque(false);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane pane = new JScrollPane(buttonsPanel){
            private static final long serialVersionUID = 7258489670834946958L;

            public Dimension getPreferredSize() {
                if (buttonsPanel.getAlignment() == 1 || buttonsPanel.getAlignment() == 3) {
                    return new Dimension(buttonsPanel.getPreferredSize().width + this.getVerticalScrollBar().getPreferredSize().width, 5);
                }
                return new Dimension(5, buttonsPanel.getPreferredSize().height + this.getHorizontalScrollBar().getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        pane.setHorizontalScrollBarPolicy(31);
        buttonsPanel.setOpaque(false);
        this._pageList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e2) {
                for (int i2 = e2.getIndex0(); i2 <= e2.getIndex1(); ++i2) {
                    MultiplePageDialogPane.this.addPage(i2, group, buttonsPanel);
                }
                buttonsPanel.invalidate();
                buttonsPanel.doLayout();
            }

            public void intervalRemoved(ListDataEvent e2) {
                for (int i2 = e2.getIndex1(); i2 >= e2.getIndex0(); --i2) {
                    AbstractButton button = (AbstractButton)buttonsPanel.getComponent(i2);
                    buttonsPanel.remove(button);
                    group.remove(button);
                }
                buttonsPanel.invalidate();
                buttonsPanel.doLayout();
            }

            public void contentsChanged(ListDataEvent e2) {
                AbstractButton button;
                if (e2.getIndex0() == -1 && e2.getIndex1() == -1 && e2.getType() == 0 && (button = (AbstractButton)buttonsPanel.getButtonByName(MultiplePageDialogPane.this._pageList.getCurrentPage().getTitle())) != null) {
                    group.setSelected(button.getModel(), true);
                }
            }
        });
        pane.getViewport().setOpaque(false);
        return pane;
    }

    protected ButtonPanel createIconButtonPanel() {
        return new ScrollableButtonPanel(1, 0);
    }

    private JideButton addPage(int i2, final ButtonGroup group, final ButtonPanel buttonsPanel) {
        AbstractDialogPage optionsPanel = this._pageList.getPage(i2);
        final JideButton button = this.createIconButton(optionsPanel.getTitle(), optionsPanel.getIcon());
        button.addActionListener(new AbstractAction(optionsPanel.getTitle(), optionsPanel.getIcon()){
            private static final long serialVersionUID = -2375074433514421417L;

            public void actionPerformed(ActionEvent e2) {
                group.setSelected(button.getModel(), true);
                MultiplePageDialogPane.this.setCurrentPage(MultiplePageDialogPane.this._pageList.getPageByFullTitle(e2.getActionCommand()), buttonsPanel);
            }
        });
        buttonsPanel.addButton((AbstractButton)button, i2);
        group.add(button);
        return button;
    }

    protected JideButton createIconButton(String title, Icon icon) {
        JideButton button = new JideButton(title, icon);
        button.setName(title);
        button.setHorizontalAlignment(0);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        return button;
    }

    public int getStyle() {
        return this._style;
    }

    public void setStyle(int style) {
        if (style != 0 && style != 2 && style != 3 && style != 1) {
            throw new IllegalArgumentException("The value of style must be one of the following - TAB_STYLE, ICON_STYLE, LIST_STYLE or TREE_STYLE");
        }
        this._style = style;
    }

    public JComponent getIndexPanel() {
        return this._indexPanel;
    }

    public JComponent getPagesPanel() {
        return this._pagesPanel;
    }

    protected TreeCellRenderer getTreeCellRenderer() {
        return this._treeCellRenderer;
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this._treeCellRenderer = treeCellRenderer;
    }

    protected ListCellRenderer getListCellRenderer() {
        return this._listCellRenderer;
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this._listCellRenderer = listCellRenderer;
    }

    protected ListCellRenderer createListCellRenderer() {
        if (this.getListCellRenderer() == null) {
            this.setListCellRenderer(new DialogPageListCellRenderer());
        }
        return this.getListCellRenderer();
    }

    protected TreeCellRenderer createTreeCellRenderer() {
        if (this.getTreeCellRenderer() == null) {
            this.setTreeCellRenderer(new DialogPageTreeCellRenderer());
        }
        return this.getTreeCellRenderer();
    }

    public String getInitialPageTitle() {
        return this._initialPageTitle;
    }

    public void setInitialPageTitle(String initialPageTitle) {
        this._initialPageTitle = initialPageTitle;
    }
}

