/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Invariant(value={"reader != null"})
public class JavaTokenizer
implements Iterator<Token> {
    protected PushbackReader reader;
    protected Token nextToken;
    protected boolean hasErrors_;
    protected String errorMessage;
    protected int currentOffset;

    @Requires(value={"reader != null"})
    public JavaTokenizer(Reader reader) {
        this.reader = new PushbackReader(reader);
        this.nextToken = null;
        this.hasErrors_ = false;
        this.currentOffset = 0;
    }

    @Ensures(value={"!allowEOF ? result >= 0 : result >= -1"})
    protected int readChar(boolean bl) throws IOException {
        int n2 = this.reader.read();
        if (n2 != -1) {
            ++this.currentOffset;
        } else if (!bl) {
            throw new IOException();
        }
        return n2;
    }

    protected void unreadChar(int n2) throws IOException {
        if (n2 == -1) {
            return;
        }
        --this.currentOffset;
        this.reader.unread(n2);
    }

    @Requires(value={"nextToken == null"})
    @Ensures(value={"result == (nextToken != null)"})
    protected boolean lex() throws IOException {
        int n2 = this.currentOffset;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = this.readChar(true);
        if (n3 == -1) {
            return false;
        }
        stringBuilder.append((char)n3);
        block0 : switch (n3) {
            case 47: {
                n3 = this.readChar(true);
                switch (n3) {
                    case 47: {
                        stringBuilder.append((char)n3);
                        do {
                            n3 = this.readChar(false);
                            stringBuilder.append((char)n3);
                        } while (n3 != 10);
                        this.nextToken = new Token(TokenKind.COMMENT, stringBuilder.toString(), n2);
                        break block0;
                    }
                    case 42: {
                        stringBuilder.append((char)n3);
                        while (true) {
                            n3 = this.readChar(false);
                            stringBuilder.append((char)n3);
                            if (n3 != 42) continue;
                            n3 = this.readChar(false);
                            stringBuilder.append((char)n3);
                            if (n3 == 47) break;
                        }
                        this.nextToken = new Token(TokenKind.COMMENT, stringBuilder.toString(), n2);
                        break block0;
                    }
                }
                this.unreadChar(n3);
                this.nextToken = new Token(TokenKind.SYMBOL, stringBuilder.toString(), n2);
                break;
            }
            case 34: 
            case 39: {
                int n4 = n3;
                while (true) {
                    n3 = this.readChar(false);
                    stringBuilder.append((char)n3);
                    if (n3 == n4) break;
                    if (n3 != 92) continue;
                    stringBuilder.append((char)this.readChar(false));
                }
                this.nextToken = new Token(TokenKind.QUOTE, stringBuilder.toString(), n2);
                break;
            }
            default: {
                if (Character.isJavaIdentifierStart(n3)) {
                    while ((n3 = this.readChar(true)) != -1 && Character.isJavaIdentifierPart(n3)) {
                        stringBuilder.append((char)n3);
                    }
                    this.unreadChar(n3);
                    this.nextToken = new Token(TokenKind.WORD, stringBuilder.toString(), n2);
                    break;
                }
                if (Character.isWhitespace(n3)) {
                    while ((n3 = this.readChar(true)) != -1 && Character.isWhitespace(n3)) {
                        stringBuilder.append((char)n3);
                    }
                    this.unreadChar(n3);
                    this.nextToken = new Token(TokenKind.SPACE, stringBuilder.toString(), n2);
                    break;
                }
                this.nextToken = new Token(TokenKind.SYMBOL, stringBuilder.toString(), n2);
            }
        }
        return true;
    }

    public Token getNextToken() {
        if (this.nextToken == null) {
            try {
                if (!this.lex()) {
                    throw new NoSuchElementException();
                }
            }
            catch (IOException iOException) {
                this.errorMessage = iOException.getMessage();
                this.hasErrors_ = true;
                throw new NoSuchElementException();
            }
        }
        return this.nextToken;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public boolean hasErrors() {
        return this.hasErrors_;
    }

    @Requires(value={"hasErrors()"})
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean hasNext() {
        if (this.nextToken != null) {
            return true;
        }
        try {
            return this.lex();
        }
        catch (IOException iOException) {
            this.errorMessage = iOException.getMessage();
            this.hasErrors_ = true;
            return false;
        }
    }

    @Override
    public Token next() {
        Token token = this.getNextToken();
        this.nextToken = null;
        return token;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class Token {
        public final TokenKind kind;
        public final String text;
        public final int offset;

        protected Token(TokenKind tokenKind, String string, int n2) {
            this.kind = tokenKind;
            this.text = string;
            this.offset = n2;
        }
    }

    public static enum TokenKind {
        WORD,
        QUOTE,
        SYMBOL,
        COMMENT,
        SPACE;

    }
}

