/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.util.Elements;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;

public class ContractJavaFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    @Requires(value={"fileManager != null"})
    public ContractJavaFileManager(StandardJavaFileManager standardJavaFileManager) {
        super(standardJavaFileManager);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        String string2 = string.replace('.', '/');
        String string3 = ClassName.getRelativeName(string);
        string3 = string3.endsWith("$com$google$java$contract$H") ? string3 + JavaFileObject.Kind.CLASS.extension : string3 + ".contracts";
        FileObject fileObject2 = ((StandardJavaFileManager)this.fileManager).getFileForOutput(location, ClassName.getPackageName(string), string3, fileObject);
        return new SimpleOutputJavaFileObject(string2, fileObject2);
    }

    @Requires(value={"location != null"})
    public List<? extends File> getLocation(JavaFileManager.Location location) {
        Iterable<? extends File> iterable = ((StandardJavaFileManager)this.fileManager).getLocation(location);
        if (iterable == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : iterable) {
            arrayList.add(file);
        }
        return arrayList;
    }

    @Requires(value={"location != null"})
    public void setLocation(JavaFileManager.Location location, List<? extends File> list) throws IOException {
        ((StandardJavaFileManager)this.fileManager).setLocation(location, list);
    }

    @Invariant(value={"file != null"})
    protected class SimpleOutputJavaFileObject
    extends SimpleJavaFileObject {
        protected FileObject file;

        @Requires(value={"binaryName != null", "file != null"})
        public SimpleOutputJavaFileObject(String string, FileObject fileObject) {
            super(Elements.getUriForClass(string, JavaFileObject.Kind.CLASS), JavaFileObject.Kind.CLASS);
            this.file = fileObject;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.file.openOutputStream();
        }
    }
}

