/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.wiggle;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.wiggle.WiggleHeader;

public class WiggleWriter {
    private WiggleHeader wHeader = null;
    private BufferedWriter wWriter = null;
    private GenomeLoc firstLoc = null;
    private StepType type = StepType.variable;
    private String myFile = "unknown";

    public WiggleWriter(File outputFile) {
        FileOutputStream outputStream;
        this.myFile = outputFile.getAbsolutePath();
        try {
            outputStream = new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e2) {
            throw new UserException.CouldNotCreateOutputFile(outputFile, "Unable to create a wiggle file ", (Exception)e2);
        }
        this.wWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public WiggleWriter(OutputStream out) {
        this.wWriter = new BufferedWriter(new OutputStreamWriter(out));
    }

    public void writeHeader(WiggleHeader header) {
        this.wHeader = header;
        this.write(this.wWriter, header.toString());
    }

    public void writeData(GenomeLoc loc, Object dataPoint) {
        if (this.firstLoc == null) {
            this.firstLoc = loc;
            this.write(this.wWriter, String.format("%n", new Object[0]));
            this.write(this.wWriter, String.format("%s\tchrom=%s", this.type.toString(), this.firstLoc.getContig()));
            this.write(this.wWriter, String.format("%n", new Object[0]));
            this.write(this.wWriter, String.format("%d\t%s", loc.getStart(), dataPoint.toString()));
        } else if (loc.compareContigs(this.firstLoc) == 0) {
            this.write(this.wWriter, String.format("%n", new Object[0]));
            this.write(this.wWriter, String.format("%d\t%s", loc.getStart(), dataPoint.toString()));
        } else {
            throw new ReviewedGATKException("Attempting to write multiple contigs into wiggle file, first contig was " + this.firstLoc.getContig() + " most recent " + loc.getContig());
        }
    }

    private void write(BufferedWriter w2, String s2) {
        try {
            w2.write(s2);
            w2.flush();
        }
        catch (IOException e2) {
            throw new UserException.CouldNotCreateOutputFile(this.myFile, String.format("Error writing the wiggle line %s", s2), (Exception)e2);
        }
    }

    static enum StepType {
        fixed("fixedStep"),
        variable("variableStep");

        String repr;

        private StepType(String repr) {
            this.repr = repr;
        }

        public String toString() {
            return this.repr;
        }
    }
}

