/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.AlternativeSpliceGraph;
import org.broad.igv.feature.AminoAcid;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.EncodePeakFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IExon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.util.collections.MultiMap;
import org.broad.igv.variant.VariantRenderer;

public class IGVFeatureRenderer
extends FeatureRenderer {
    private static Logger log = Logger.getLogger(IGVFeatureRenderer.class);
    protected static final int NORMAL_STRAND_Y_OFFSET = 14;
    protected static final int ARROW_SPACING = 30;
    protected static final int NO_STRAND_THICKNESS = 2;
    protected static final int REGION_STRAND_THICKNESS = 4;
    static final int BLOCK_HEIGHT = 14;
    static final int THIN_BLOCK_HEIGHT = 6;
    protected Color AA_COLOR_1 = new Color(92, 92, 164);
    protected Color AA_COLOR_2 = new Color(12, 12, 120);
    public static final Color DULL_BLUE = new Color(0, 0, 200);
    public static final Color DULL_RED = new Color(200, 0, 0);
    static final int NON_CODING_HEIGHT = 8;
    float viewLimitMin = Float.NaN;
    float viewLimitMax = Float.NaN;
    protected boolean drawBoundary = false;
    int blockHeight = 14;
    int thinBlockHeight = 6;
    private Map<IExon, Integer> exonMap = new HashMap<IExon, Integer>(100);
    private AlternativeSpliceGraph<Integer> exonGraph = new AlternativeSpliceGraph();
    private Set<String> drawnNames = new HashSet<String>(100);
    protected boolean isGenotypeRenderer = false;
    private static final int MAX_NAME_LENGTH = 60;

    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        double end = origin + trackRectangle.getWidth() * locScale;
        Track.DisplayMode displayMode = track.getDisplayMode();
        this.blockHeight = displayMode == Track.DisplayMode.SQUISHED ? 7 : 14;
        int n2 = this.thinBlockHeight = displayMode == Track.DisplayMode.SQUISHED ? 3 : 6;
        if (featureList != null && featureList.size() > 0) {
            Font font = FontManager.getFont(track.getFontSize());
            Graphics2D fontGraphics = (Graphics2D)context.getGraphic2DForColor(Color.BLACK).create();
            if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
                fontGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            fontGraphics.setFont(font);
            double trackRectangleX = trackRectangle.getX();
            double trackRectangleMaxX = trackRectangle.getMaxX();
            double trackRectangleY = trackRectangle.getY();
            double trackRectangleMaxY = trackRectangle.getMaxY();
            int lastNamePixelEnd = -9999;
            int lastPixelEnd = -1;
            int occludedCount = 0;
            int maxOcclusions = 2;
            boolean alternateExonColor = track instanceof FeatureTrack && ((FeatureTrack)track).isAlternateExonColor();
            for (IGVFeature feature : featureList) {
                String name;
                if ((double)feature.getEnd() < origin) continue;
                if ((double)feature.getStart() > end) break;
                double virtualPixelStart = ((double)feature.getStart() - origin) / locScale;
                double virtualPixelEnd = ((double)feature.getEnd() - origin) / locScale;
                int pixelStart = (int)Math.round(Math.max(trackRectangleX, virtualPixelStart));
                int pixelEnd = (int)Math.round(Math.min(trackRectangleMaxX, virtualPixelEnd));
                int pixelWidth = pixelEnd - pixelStart;
                if (this.isGenotypeRenderer && pixelWidth < 3) {
                    double dx = 3.0 - (double)pixelWidth;
                    pixelStart = (int)((double)pixelStart - dx / 2.0);
                    pixelEnd = (int)((double)pixelEnd + dx / 2.0);
                }
                if (pixelEnd <= lastPixelEnd) {
                    if (occludedCount >= maxOcclusions) continue;
                    ++occludedCount;
                } else {
                    occludedCount = 0;
                    lastPixelEnd = pixelEnd;
                }
                if (this.isGenotypeRenderer) {
                    this.renderGenotypeFeature(context, feature, trackRectangle, pixelStart, pixelEnd);
                    continue;
                }
                Color color = this.getFeatureColor(feature, track);
                Graphics2D g2D = context.getGraphic2DForColor(color);
                int pixelThickStart = pixelStart;
                int pixelThickEnd = pixelEnd;
                boolean hasExons = false;
                if (feature instanceof BasicFeature) {
                    BasicFeature bf = (BasicFeature)feature;
                    pixelThickStart = (int)Math.max(trackRectangleX, (double)Math.round(((double)bf.getThickStart() - origin) / locScale));
                    pixelThickEnd = (int)Math.min(trackRectangleMaxX, (double)Math.round(((double)bf.getThickEnd() - origin) / locScale));
                    hasExons = bf.hasExons();
                }
                int pixelYCenter = trackRectangle.y + 7;
                if (hasExons) {
                    if (pixelWidth < 3) {
                        this.drawFeatureBounds(pixelStart, pixelEnd, pixelYCenter, g2D);
                    } else {
                        this.drawExons(feature, pixelYCenter, context, g2D, trackRectangle, displayMode, alternateExonColor, track.getColor(), track.getAltColor());
                    }
                } else {
                    int peakPosition;
                    this.drawFeatureBlock(pixelStart, pixelEnd, pixelThickStart, pixelThickEnd, pixelYCenter, g2D);
                    Graphics2D arrowGraphics = context.getGraphic2DForColor(Color.WHITE);
                    this.drawStrandArrows(feature.getStrand(), pixelStart, pixelEnd, pixelYCenter, 0.0, displayMode, arrowGraphics);
                    if (feature instanceof EncodePeakFeature && pixelWidth > 5 && (peakPosition = ((EncodePeakFeature)feature).getPeakPosition()) > 0) {
                        Color c2 = g2D.getColor();
                        int peakPixelPosition = (int)(((double)peakPosition - origin) / locScale);
                        Color peakColor = c2 == Color.black ? Color.red : Color.black;
                        g2D.setColor(peakColor);
                        int pw = Math.min(3, pixelWidth / 5);
                        g2D.fillRect(peakPixelPosition - pw / 2, pixelYCenter - this.thinBlockHeight / 2 - 1, pw, this.thinBlockHeight + 2);
                        g2D.setColor(c2);
                    }
                }
                if (displayMode != Track.DisplayMode.SQUISHED && (name = feature.getName()) != null) {
                    if (name.length() >= 60) {
                        name = name.substring(0, 57) + " ...";
                    }
                    LineMetrics lineMetrics = font.getLineMetrics(name, g2D.getFontRenderContext());
                    int fontHeight = (int)Math.ceil(lineMetrics.getHeight());
                    int nameStart = Math.max(0, pixelStart);
                    int nameEnd = Math.min(pixelEnd, (int)trackRectangle.getWidth());
                    int textBaselineY = trackRectangle.y + trackRectangle.height - 3;
                    int verticalSpaceRequiredForText = textBaselineY - (int)trackRectangleY;
                    if (verticalSpaceRequiredForText <= trackRectangle.height) {
                        lastNamePixelEnd = this.drawFeatureName(feature, track.getDisplayMode(), nameStart, nameEnd, lastNamePixelEnd, fontGraphics, textBaselineY);
                    }
                }
                if (this.getHighlightFeature() != feature) continue;
                int yStart = pixelYCenter - this.blockHeight / 2 - 1;
                Graphics2D highlightGraphics = context.getGraphic2DForColor(Color.cyan);
                highlightGraphics.drawRect(pixelStart - 1, yStart, pixelWidth + 2, this.blockHeight + 2);
            }
            if (this.drawBoundary) {
                Graphics2D g2D = context.getGraphic2DForColor(Color.LIGHT_GRAY);
                g2D.drawLine((int)trackRectangleX, (int)trackRectangleMaxY - 1, (int)trackRectangleMaxX, (int)trackRectangleMaxY - 1);
            }
            fontGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    protected void renderGenotypeFeature(RenderContext context, IGVFeature feature, Rectangle trackRectangle, int pixelStart, int pixelEnd) {
        Color color = feature.getName().equals("HET") ? VariantRenderer.colorHet : VariantRenderer.colorHomVar;
        Graphics2D g2D = context.getGraphic2DForColor(color);
        g2D.fillRect(pixelStart, trackRectangle.y, pixelEnd - pixelStart, trackRectangle.height);
    }

    private void drawFeatureBlock(int pixelStart, int pixelEnd, int pixelThickStart, int pixelThickEnd, int yOffset, Graphics2D g2) {
        Graphics2D g2D = (Graphics2D)g2.create();
        if (pixelThickStart > pixelStart) {
            g2D.fillRect(pixelStart, yOffset - this.thinBlockHeight / 2, Math.max(1, pixelThickStart - pixelStart), this.thinBlockHeight);
        }
        if (pixelThickEnd > 0 && pixelThickEnd < pixelEnd) {
            g2D.fillRect(pixelThickEnd, yOffset - this.thinBlockHeight / 2, Math.max(1, pixelEnd - pixelThickEnd), this.thinBlockHeight);
        }
        g2D.fillRect(pixelThickStart, yOffset - (this.blockHeight - 4) / 2, Math.max(1, pixelThickEnd - pixelThickStart), this.blockHeight - 4);
        g2D.dispose();
    }

    private final void drawConnectingLine(int startX, int startY, int endX, int endY, Strand strand, Graphics2D g2) {
        Graphics2D g2D = (Graphics2D)g2.create();
        if (strand == null) {
            BasicStroke befStroke = (BasicStroke)g2.getStroke();
            float lineThickness = befStroke.getLineWidth();
            BasicStroke stroke = new BasicStroke(lineThickness *= 2.0f);
            g2D.setStroke(stroke);
        }
        g2D.drawLine(startX, startY, endX, endY);
        g2D.dispose();
    }

    private void drawFeatureBounds(int pixelStart, int pixelEnd, int yOffset, Graphics2D g2D) {
        if (pixelEnd == pixelStart) {
            int yStart = yOffset - this.blockHeight / 2;
            g2D.drawLine(pixelStart, yStart, pixelStart, yStart + this.blockHeight);
        } else {
            g2D.fillRect(pixelStart, yOffset - this.blockHeight / 2, pixelEnd - pixelStart, this.blockHeight);
        }
    }

    protected void drawExons(IGVFeature gene, int yOffset, RenderContext context, Graphics2D g2D, Rectangle trackRectangle, Track.DisplayMode mode, boolean alternateExonColor, Color color1, Color color2) {
        Graphics2D exonNumberGraphics = (Graphics2D)g2D.create();
        exonNumberGraphics.setColor(Color.BLACK);
        exonNumberGraphics.setFont(FontManager.getFont(1, 8));
        double theOrigin = context.getOrigin();
        double locationScale = context.getScale();
        Graphics2D fontGraphics = context.getGraphic2DForColor(Color.WHITE);
        if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
            exonNumberGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            fontGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        boolean colorToggle = true;
        int lastExonEndX = Integer.MIN_VALUE;
        int lastY = Integer.MIN_VALUE;
        int maxLineEndX = Integer.MIN_VALUE;
        IExon lastExon = null;
        this.exonGraph.startFeature();
        int exonCount = gene.getExons().size();
        for (int idx = 0; idx < exonCount; ++idx) {
            int pClippedWidth;
            int pClippedEnd;
            Exon exon = gene.getExons().get(idx);
            Float exprValue = null;
            MultiMap<String, String> attributes = exon.getAttributes();
            if (attributes != null && attributes.containsKey("expr")) {
                try {
                    exprValue = Float.valueOf(Float.parseFloat(attributes.get("expr")));
                }
                catch (NumberFormatException e2) {
                    log.error("Error parsing expression tag " + attributes.get("expr"), e2);
                }
            }
            if (exprValue != null) {
                ContinuousColorScale colorScale = PreferenceManager.getInstance().getColorScale(TrackType.GENE_EXPRESSION);
                Color chartColor = colorScale.getColor(exprValue.floatValue());
                g2D = context.getGraphic2DForColor(chartColor);
            }
            Graphics2D blockGraphics = g2D;
            Graphics2D edgeGraphics = context.getGraphic2DForColor(Color.gray);
            if (alternateExonColor) {
                Color color = colorToggle ? color1 : color2;
                blockGraphics = context.getGraphic2DForColor(color);
                colorToggle = !colorToggle;
            }
            int curYOffset = yOffset;
            boolean drawConnectingLine = true;
            if (mode == Track.DisplayMode.ALTERNATIVE_SPLICE) {
                IExon eProx = Exon.getExonProxy(exon);
                boolean bl = drawConnectingLine = !this.exonGraph.containsEdge(lastExon, eProx);
                if (this.exonGraph.hasParameter(eProx)) {
                    curYOffset = this.exonGraph.getParameter(eProx);
                } else {
                    this.exonGraph.put(eProx, curYOffset);
                }
                lastExon = eProx;
            }
            int pStart = this.getPixelFromChromosomeLocation(exon.getChr(), exon.getStart(), theOrigin, locationScale);
            int pEnd = this.getPixelFromChromosomeLocation(exon.getChr(), exon.getEnd(), theOrigin, locationScale);
            Graphics2D arrowGraphics = context.getGraphic2DForColor(Color.blue);
            if (drawConnectingLine && lastExonEndX > Integer.MIN_VALUE && lastY > Integer.MIN_VALUE && lastExonEndX >= maxLineEndX) {
                this.drawConnectingLine(lastExonEndX, lastY, pStart, curYOffset, exon.getStrand(), blockGraphics);
                double angle = Math.atan((double)(-(curYOffset - lastY)) / ((double)(pStart - lastExonEndX) + 1.0E-12));
                this.drawStrandArrows(gene.getStrand(), lastExonEndX, pStart, lastY, angle, mode, arrowGraphics);
                maxLineEndX = Math.max(maxLineEndX, pStart);
            }
            lastExonEndX = pEnd;
            lastY = curYOffset;
            if (!((double)pEnd >= trackRectangle.getX()) || !((double)pStart <= trackRectangle.getMaxX())) continue;
            int pCdStart = Math.min(pEnd, Math.max(pStart, this.getPixelFromChromosomeLocation(exon.getChr(), exon.getCdStart(), theOrigin, locationScale)));
            int pCdEnd = Math.max(pStart, Math.min(pEnd, this.getPixelFromChromosomeLocation(exon.getChr(), exon.getCdEnd(), theOrigin, locationScale)));
            if (exon.isNonCoding()) {
                int pClippedStart = (int)Math.max((double)pStart, trackRectangle.getX());
                pClippedEnd = (int)Math.min((double)pEnd, trackRectangle.getMaxX());
                pClippedWidth = pClippedEnd - pClippedStart;
                this.drawExonRect(blockGraphics, exon, pClippedStart, curYOffset - 4, pClippedWidth, 8);
            } else {
                if (pCdStart > pStart) {
                    int pClippedStart = (int)Math.max((double)pStart, trackRectangle.getX());
                    pClippedEnd = (int)Math.min((double)pCdStart, trackRectangle.getMaxX());
                    pClippedWidth = pClippedEnd - pClippedStart;
                    this.drawExonRect(blockGraphics, exon, pClippedStart, curYOffset - 4, pClippedWidth, 8);
                    pStart = pCdStart;
                }
                if (pCdEnd < pEnd) {
                    int pClippedStart = (int)Math.max((double)pCdEnd, trackRectangle.getX());
                    pClippedEnd = (int)Math.min((double)pEnd, trackRectangle.getMaxX());
                    pClippedWidth = pClippedEnd - pClippedStart;
                    this.drawExonRect(blockGraphics, exon, pClippedStart, curYOffset - 4, pClippedWidth, 8);
                    pEnd = pCdEnd;
                }
                if (exon.getCdStart() < exon.getEnd() && exon.getCdEnd() > exon.getStart()) {
                    int pClippedStart = (int)Math.max((double)pStart, trackRectangle.getX());
                    pClippedEnd = (int)Math.min((double)pEnd, trackRectangle.getMaxX());
                    pClippedWidth = Math.max(2, pClippedEnd - pClippedStart);
                    this.drawExonRect(blockGraphics, exon, pClippedStart, curYOffset - this.blockHeight / 2, pClippedWidth, this.blockHeight);
                }
            }
            Graphics2D whiteArrowGraphics = context.getGraphic2DForColor(Color.white);
            this.drawStrandArrows(gene.getStrand(), pStart + 15, pEnd, curYOffset, 0.0, mode, whiteArrowGraphics);
            if (locationScale < 0.25) {
                this.labelAminoAcids(pStart, fontGraphics, theOrigin, context, gene, locationScale, curYOffset, trackRectangle, idx);
            }
            if (!FrameManager.isExomeMode()) continue;
            int halfHeight = this.blockHeight / 2;
            edgeGraphics.drawLine(pStart, curYOffset - halfHeight, pStart, curYOffset + halfHeight - 1);
            edgeGraphics.drawLine(pEnd, curYOffset - halfHeight, pEnd, curYOffset + halfHeight - 1);
        }
        exonNumberGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        fontGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
    }

    protected void drawExonRect(Graphics blockGraphics, Exon exon, int x2, int y, int width, int height) {
        blockGraphics.fillRect(x2, y, width, height);
    }

    protected void drawStrandArrows(Strand strand, int startX, int endX, int startY, double angle, Track.DisplayMode mode, Graphics2D g2D) {
        if (!strand.equals((Object)Strand.POSITIVE) && !strand.equals((Object)Strand.NEGATIVE)) {
            return;
        }
        int distance = endX - startX;
        if (distance < 6) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g2D.create();
        boolean vStart = false;
        int vEnd = 10000;
        int sz = mode == Track.DisplayMode.EXPANDED ? 3 : 2;
        sz = strand.equals((Object)Strand.POSITIVE) ? -sz : sz;
        int asz = Math.abs(sz);
        g2.translate(startX, startY);
        g2.rotate(-angle);
        double endXInFrame = (double)distance / Math.cos(angle);
        int ii = 15;
        while ((double)ii < endXInFrame) {
            g2.drawLine(ii, 0, ii + sz, asz);
            g2.drawLine(ii, 0, ii + sz, -asz);
            ii += 30;
        }
    }

    private final int drawFeatureName(IGVFeature feature, Track.DisplayMode mode, int pixelStart, int pixelEnd, int lastFeatureEndedAtPixelX, Graphics2D g2D, int textBaselineY) {
        String name = feature.getName();
        if (name == null || this.drawnNames.contains(name) && mode == Track.DisplayMode.ALTERNATIVE_SPLICE) {
            return lastFeatureEndedAtPixelX;
        }
        FontMetrics fm = g2D.getFontMetrics();
        int fontSize = fm.getFont().getSize();
        int nameWidth = fm.stringWidth(name);
        int nameStart = (pixelStart + pixelEnd - nameWidth) / 2;
        Rectangle2D sb = fm.getStringBounds(name, g2D);
        if (nameStart > lastFeatureEndedAtPixelX + fontSize && sb.getWidth() < g2D.getClipBounds().getWidth()) {
            g2D.drawString(name, nameStart, textBaselineY);
            lastFeatureEndedAtPixelX = nameStart + nameWidth;
            this.drawnNames.add(name);
        }
        return lastFeatureEndedAtPixelX;
    }

    public void labelAminoAcids(int pStart, Graphics2D fontGraphics, double theOrigin, RenderContext context, IGVFeature gene, double locationScale, int yOffset, Rectangle trackRectangle, int idx) {
        Exon nextExon;
        Exon prevExon;
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        Exon exon = gene.getExons().get(idx);
        AminoAcidSequence aaSequence = exon.getAminoAcidSequence(genome, prevExon = idx == 0 ? null : gene.getExons().get(idx - 1), nextExon = idx + 1 < gene.getExons().size() ? gene.getExons().get(idx + 1) : null);
        if (aaSequence != null && aaSequence.hasNonNullSequence()) {
            Rectangle aaRect = new Rectangle(pStart, yOffset - this.blockHeight / 2, 1, this.blockHeight);
            int aaSeqStartPosition = aaSequence.getStartPosition();
            boolean odd = exon.getAminoAcidNumber(exon.getCdStart()) % 2 == 1;
            for (AminoAcid acid : aaSequence.getSequence()) {
                if (acid == null) continue;
                int start = Math.max(exon.getStart(), aaSeqStartPosition);
                int end = Math.min(exon.getEnd(), aaSeqStartPosition + 3);
                int px = this.getPixelFromChromosomeLocation(exon.getChr(), start, theOrigin, locationScale);
                int px2 = this.getPixelFromChromosomeLocation(exon.getChr(), end, theOrigin, locationScale);
                if ((double)px <= trackRectangle.getMaxX() && (double)px2 >= trackRectangle.getX()) {
                    aaRect.x = px;
                    aaRect.width = px2 - px;
                    Graphics2D bgGraphics = context.getGraphic2DForColor(odd ? this.AA_COLOR_1 : this.AA_COLOR_2);
                    if (acid.getSymbol() == 'M' && (gene.getStrand() == Strand.POSITIVE && aaSeqStartPosition == exon.getCdStart() || gene.getStrand() == Strand.NEGATIVE && aaSeqStartPosition == exon.getCdEnd() - 3)) {
                        bgGraphics = context.getGraphic2DForColor(Color.green);
                    } else if (acid.getSymbol() == '*') {
                        bgGraphics = context.getGraphic2DForColor(Color.RED);
                    }
                    bgGraphics.fill(aaRect);
                    String tmp = new String(new char[]{acid.getSymbol()});
                    GraphicUtils.drawCenteredText(tmp, aaRect, fontGraphics);
                }
                odd = !odd;
                aaSeqStartPosition += 3;
            }
            if (aaSeqStartPosition < exon.getEnd()) {
                int cdEnd = Math.min(exon.getCdEnd(), exon.getEnd());
                aaRect.x = this.getPixelFromChromosomeLocation(exon.getChr(), aaSeqStartPosition, theOrigin, locationScale);
                aaRect.width = this.getPixelFromChromosomeLocation(exon.getChr(), cdEnd, theOrigin, locationScale) - aaRect.x;
                Graphics2D bgGraphics = context.getGraphic2DForColor(odd ? this.AA_COLOR_1 : this.AA_COLOR_2);
                odd = !odd;
                bgGraphics.fill(aaRect);
            }
        }
    }

    public String getDisplayName() {
        return "Basic Feature";
    }

    protected Color getFeatureColor(IGVFeature feature, Track track) {
        Color color = null;
        if (track.isItemRGB()) {
            color = feature.getColor();
        }
        if (color == null) {
            color = track.getTrackType() == TrackType.CNV ? (feature.getName().equals("gain") ? DULL_RED : DULL_BLUE) : track.getColor();
        }
        if (track.isUseScore()) {
            float min = this.getViewLimitMin(track);
            float max = this.getViewLimitMax(track);
            float score = feature.getScore();
            float alpha = Float.isNaN(score) ? 1.0f : this.getAlpha(min, max, feature.getScore());
            color = ColorUtilities.getCompositeColor(color, alpha);
        }
        return color;
    }

    float getViewLimitMin(Track track) {
        if (Float.isNaN(this.viewLimitMin)) {
            this.viewLimitMin = Float.isNaN(track.getViewLimitMin()) ? 0.0f : track.getViewLimitMin();
        }
        return this.viewLimitMin;
    }

    float getViewLimitMax(Track track) {
        if (Float.isNaN(this.viewLimitMax)) {
            this.viewLimitMax = Float.isNaN(track.getViewLimitMax()) ? 1000.0f : track.getViewLimitMax();
        }
        return this.viewLimitMax;
    }

    private float getAlpha(float minRange, float maxRange, float value) {
        float binWidth = (maxRange - minRange) / 9.0f;
        int binNumber = (int)((value - minRange) / binWidth);
        return Math.min(1.0f, 0.2f + (float)binNumber * 0.8f / 9.0f);
    }

    protected int getPixelFromChromosomeLocation(String chr, int chromosomeLocation, double origin, double locationScale) {
        return (int)Math.round(((double)chromosomeLocation - origin) / locationScale);
    }

    @Override
    public void reset() {
        this.exonMap.clear();
        this.exonGraph = new AlternativeSpliceGraph();
        this.drawnNames.clear();
    }
}

