/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import org.broad.igv.cursor.CursorMainPanel;
import org.broad.igv.cursor.CursorModel;
import org.broad.igv.cursor.CursorRegion;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.feature.BasicFeature;

public class CursorTrackPanel
extends JComponent
implements Serializable {
    CursorModel model;
    CursorTrack track;
    private CursorMainPanel mainPanel;
    private List<RegionFrame> renderedFrames = new ArrayList<RegionFrame>(1000);

    public CursorTrackPanel(CursorTrack t2, CursorModel cursorModel, CursorMainPanel mainPanel) {
        this.track = t2;
        this.model = cursorModel;
        this.mainPanel = mainPanel;
        MouseHandler ma = new MouseHandler();
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        this.setToolTipText("");
    }

    public void setTrack(CursorTrack track) {
        this.track = track;
    }

    private void showPopup(int x2, int y) {
        JPopupMenu menu = new JPopupMenu();
        CursorTrack.SignalField[] signalFields = this.track.getAllSignalFields();
        if (signalFields.length > 1) {
            ButtonGroup group = new ButtonGroup();
            for (CursorTrack.SignalField sf : signalFields) {
                final JRadioButton button = new JRadioButton(sf.toString());
                group.add(button);
                menu.add(button);
                if (sf == this.track.getSignalField()) {
                    button.setSelected(true);
                }
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        CursorTrack.SignalField sf = CursorTrack.SignalField.valueOf(button.getText());
                        CursorTrackPanel.this.track.setSignalField(sf);
                        CursorTrackPanel.this.mainPanel.repaint();
                    }
                });
            }
        }
        menu.show(this, x2, y);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.renderedFrames.clear();
        if (this.model == null || this.track == null) {
            return;
        }
        List<CursorRegion> regionsList = this.model.getFilteredRegions();
        if (regionsList == null) {
            return;
        }
        int frameMargin = this.model.getFrameMargin();
        if (frameMargin < 1) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Color c2 = this.track.getColor();
        graphics.setColor(c2);
        double framePixelWidth = this.model.getFramePixelWidth();
        int frameBPWidth = this.model.getFrameBPWidth();
        double scale = (double)frameBPWidth / (framePixelWidth - (double)frameMargin);
        double origin = this.model.getOrigin();
        double end = origin + (double)this.getWidth() / framePixelWidth;
        int startRegionNumber = (int)origin;
        if (startRegionNumber >= regionsList.size()) {
            return;
        }
        int h2 = this.getHeight();
        int sampleInterval = Math.max(1, (int)Math.round(1.0 / framePixelWidth));
        double max = this.track.getScale().getMax();
        for (int regionNumber = startRegionNumber; regionNumber < regionsList.size() && !((double)regionNumber > end); regionNumber += sampleInterval) {
            List<BasicFeature> features;
            CursorRegion region = regionsList.get(regionNumber);
            String chr = region.getChr();
            int pxStart = (int)(((double)regionNumber - origin) * framePixelWidth + (double)(frameMargin / 2));
            int pxEnd = (int)(framePixelWidth > 1.0 ? (double)pxStart + framePixelWidth : ((double)(regionNumber + 1) - origin) * (double)frameBPWidth) - frameMargin;
            this.renderedFrames.add(new RegionFrame(pxStart, pxEnd, region));
            int maxFeatureHeight = h2 - 10;
            if (frameMargin > 0) {
                int pxWidth = pxEnd - pxStart;
                graphics.setColor(Color.white);
                graphics.fillRect(pxStart, 0, pxWidth, h2);
            }
            if ((features = this.track.getFeatures(chr)) == null) continue;
            int l2 = this.track.getLongestFeatureLength(chr);
            CursorRegion.FeatureIterator regionFeatures = region.getFeatureIterator(features, l2, this.model.getFrameBPWidth());
            double bpStart = region.getLocation() - frameBPWidth / 2;
            while (regionFeatures.hasNext()) {
                BasicFeature feature = (BasicFeature)regionFeatures.next();
                float score = this.track.getSignal(feature);
                if (Float.isNaN(score)) continue;
                int pStart = (int)Math.min((double)pxEnd, Math.max((double)pxStart, (double)pxStart + ((double)feature.getStart() - bpStart) / scale));
                int pEnd = (int)Math.min((double)pxEnd, (double)pxStart + ((double)feature.getEnd() - bpStart) / scale);
                int pw = Math.max(1, pEnd - pStart);
                graphics.setColor(c2);
                int fh = (int)((double)score / max * (double)maxFeatureHeight);
                graphics.fillRect(pStart, h2 - fh, pw, fh);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawString(this.track.getName(), 10, 12);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.renderedFrames != null) {
            for (RegionFrame f2 : this.renderedFrames) {
                int x2 = event.getX();
                if (x2 <= f2.pxStart || x2 > f2.pxEnd) continue;
                int bpw = this.model.getFrameBPWidth();
                int center = f2.region.getLocation();
                int start = center - bpw / 2;
                int end = center + bpw / 2;
                StringBuffer sb = new StringBuffer("<html>");
                sb.append("Region " + f2.region.getChr() + ":" + start + "-" + end);
                String chr = f2.region.chr;
                List<BasicFeature> features = this.track.getFeatures(chr);
                if (features != null) {
                    int longest = this.track.getLongestFeatureLength(chr);
                    CursorRegion.FeatureIterator iter = f2.region.getFeatureIterator(features, longest, bpw);
                    while (iter.hasNext()) {
                        BasicFeature rf = (BasicFeature)iter.next();
                        sb.append("<br/>" + rf.getChr() + ":" + rf.getStart() + "-" + rf.getEnd() + " : " + this.track.getSignal(rf));
                    }
                }
                return sb.toString();
            }
        }
        return "";
    }

    private void evaluatePopup(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.showPopup(e2.getX(), e2.getY());
        }
    }

    static class RegionFrame {
        int pxStart;
        int pxEnd;
        CursorRegion region;

        RegionFrame(int pxStart, int pxEnd, CursorRegion region) {
            this.pxStart = pxStart;
            this.pxEnd = pxEnd;
            this.region = region;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        int mouseX;

        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.mouseX = e2.getX();
            CursorTrackPanel.this.evaluatePopup(e2);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            CursorTrackPanel.this.evaluatePopup(e2);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int delta = this.mouseX - mouseEvent.getX();
            CursorTrackPanel.this.model.shiftOriginPixels(delta);
            this.mouseX = mouseEvent.getX();
            CursorTrackPanel.this.mainPanel.repaint();
        }
    }
}

