/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.EncodePeakFeature;
import org.broad.igv.feature.SignalFeature;
import org.broad.igv.util.collections.DoubleArrayList;

public class CursorTrack {
    Map<String, List<BasicFeature>> featureMap;
    Map<String, Integer> longestFeature;
    private Color color = new Color(0, 0, 150);
    private String name;
    Class featureType;
    boolean hasScore = false;
    private SignalField signalField = SignalField.Score;
    private Map<SignalField, Range> scales;
    private static SignalField[] noSignalsArray = new SignalField[0];
    private static SignalField[] scoreOnlyArray = new SignalField[]{SignalField.Score};
    private static SignalField[] signalsArray = new SignalField[]{SignalField.Score, SignalField.Signal, SignalField.PValue, SignalField.QValue};

    public CursorTrack(Map<String, List<BasicFeature>> featureMap, Class featureType) {
        this.featureMap = featureMap;
        this.featureType = featureType;
        this.longestFeature = new HashMap<String, Integer>();
        boolean isEncodePeak = featureType == EncodePeakFeature.class;
        DoubleArrayList signals = isEncodePeak ? new DoubleArrayList(50000) : null;
        DoubleArrayList qvalues = isEncodePeak ? new DoubleArrayList(50000) : null;
        DoubleArrayList pvalues = isEncodePeak ? new DoubleArrayList(50000) : null;
        for (Map.Entry<String, List<BasicFeature>> entry : featureMap.entrySet()) {
            String chr = entry.getKey();
            List<BasicFeature> features = entry.getValue();
            int longest = 0;
            for (BasicFeature f2 : features) {
                int length;
                float s2 = f2.getScore();
                boolean bl = this.hasScore = this.hasScore || !Float.isNaN(s2);
                if (isEncodePeak) {
                    EncodePeakFeature pf = (EncodePeakFeature)f2;
                    signals.add(pf.getSignal());
                    qvalues.add(pf.getQValue());
                    pvalues.add(pf.getPValue());
                }
                if ((length = f2.getLength()) <= longest) continue;
                longest = length;
            }
            this.longestFeature.put(chr, longest);
        }
        this.scales = new HashMap<SignalField, Range>();
        this.scales.put(SignalField.Score, new Range(0.0, 1000.0));
        double[] s3 = signals.toArray();
        double sMin = 0.0;
        double sMax = StatUtils.percentile(s3, 90.0);
        this.scales.put(SignalField.Signal, new Range(sMin, sMax));
        double[] q2 = qvalues.toArray();
        this.scales.put(SignalField.QValue, new Range(0.0, StatUtils.percentile(q2, 90.0)));
        double[] p2 = pvalues.toArray();
        this.scales.put(SignalField.PValue, new Range(0.0, StatUtils.percentile(p2, 90.0)));
    }

    public Range getScale() {
        return this.scales.get((Object)this.signalField);
    }

    public List<BasicFeature> getFeatures(String chr) {
        return this.featureMap.get(chr);
    }

    public int getLongestFeatureLength(String chr) {
        Integer lf = this.longestFeature.get(chr);
        return lf == null ? -1 : lf;
    }

    public Map<String, List<BasicFeature>> getFeatureMap() {
        return this.featureMap;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SignalField getSignalField() {
        return this.signalField;
    }

    public void setSignalField(SignalField signalField) {
        System.out.println("Set signal field: " + (Object)((Object)signalField));
        this.signalField = signalField;
    }

    public SignalField[] getAllSignalFields() {
        if (!this.hasScore) {
            return noSignalsArray;
        }
        if (this.featureType == EncodePeakFeature.class) {
            return signalsArray;
        }
        return scoreOnlyArray;
    }

    public float getSignal(BasicFeature feature) {
        if (this.signalField == SignalField.Score) {
            return feature.getScore();
        }
        SignalFeature sf = (SignalFeature)((Object)feature);
        switch (this.signalField) {
            case Signal: {
                return sf.getSignal();
            }
            case QValue: {
                return sf.getQValue();
            }
            case PValue: {
                return sf.getPValue();
            }
        }
        return feature.getScore();
    }

    public static class Range {
        double min;
        double max;

        private Range(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public double getMax() {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }
    }

    public static enum SignalField {
        Score,
        Signal,
        PValue,
        QValue;

    }
}

