/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.ObjectDigestInfo;

public class V2Form
extends ASN1Object {
    GeneralNames issuerName;
    IssuerSerial baseCertificateID;
    ObjectDigestInfo objectDigestInfo;

    public static V2Form getInstance(ASN1TaggedObject obj, boolean explicit) {
        return V2Form.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static V2Form getInstance(Object obj) {
        if (obj == null || obj instanceof V2Form) {
            return (V2Form)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new V2Form((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public V2Form(GeneralNames issuerName) {
        this.issuerName = issuerName;
    }

    public V2Form(ASN1Sequence seq) {
        if (seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int index = 0;
        if (!(seq.getObjectAt(0) instanceof ASN1TaggedObject)) {
            ++index;
            this.issuerName = GeneralNames.getInstance(seq.getObjectAt(0));
        }
        for (int i2 = index; i2 != seq.size(); ++i2) {
            ASN1TaggedObject o2 = ASN1TaggedObject.getInstance(seq.getObjectAt(i2));
            if (o2.getTagNo() == 0) {
                this.baseCertificateID = IssuerSerial.getInstance(o2, false);
                continue;
            }
            if (o2.getTagNo() == 1) {
                this.objectDigestInfo = ObjectDigestInfo.getInstance(o2, false);
                continue;
            }
            throw new IllegalArgumentException("Bad tag number: " + o2.getTagNo());
        }
    }

    public GeneralNames getIssuerName() {
        return this.issuerName;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.baseCertificateID;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.issuerName != null) {
            v2.add(this.issuerName);
        }
        if (this.baseCertificateID != null) {
            v2.add(new DERTaggedObject(false, 0, this.baseCertificateID));
        }
        if (this.objectDigestInfo != null) {
            v2.add(new DERTaggedObject(false, 1, this.objectDigestInfo));
        }
        return new DERSequence(v2);
    }
}

