/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.CauchyDistribution;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class CauchyDistributionImpl
extends AbstractContinuousDistribution
implements CauchyDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private double median = 0.0;
    private double scale = 1.0;
    private final double solverAbsoluteAccuracy;

    public CauchyDistributionImpl() {
        this(0.0, 1.0);
    }

    public CauchyDistributionImpl(double median, double s2) {
        this(median, s2, 1.0E-9);
    }

    public CauchyDistributionImpl(double median, double s2, double inverseCumAccuracy) {
        this.setMedianInternal(median);
        this.setScaleInternal(s2);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public double cumulativeProbability(double x2) {
        return 0.5 + FastMath.atan((x2 - this.median) / this.scale) / Math.PI;
    }

    public double getMedian() {
        return this.median;
    }

    public double getScale() {
        return this.scale;
    }

    public double density(double x2) {
        double dev = x2 - this.median;
        return 0.3183098861837907 * (this.scale / (dev * dev + this.scale * this.scale));
    }

    public double inverseCumulativeProbability(double p2) {
        if (p2 < 0.0 || p2 > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, p2, 0.0, 1.0);
        }
        double ret = p2 == 0.0 ? Double.NEGATIVE_INFINITY : (p2 == 1.0 ? Double.POSITIVE_INFINITY : this.median + this.scale * FastMath.tan(Math.PI * (p2 - 0.5)));
        return ret;
    }

    @Deprecated
    public void setMedian(double median) {
        this.setMedianInternal(median);
    }

    private void setMedianInternal(double newMedian) {
        this.median = newMedian;
    }

    @Deprecated
    public void setScale(double s2) {
        this.setScaleInternal(s2);
    }

    private void setScaleInternal(double s2) {
        if (s2 <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_SCALE, s2);
        }
        this.scale = s2;
    }

    protected double getDomainLowerBound(double p2) {
        double ret = p2 < 0.5 ? -1.7976931348623157E308 : this.median;
        return ret;
    }

    protected double getDomainUpperBound(double p2) {
        double ret = p2 < 0.5 ? this.median : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p2) {
        double ret = p2 < 0.5 ? this.median - this.scale : (p2 > 0.5 ? this.median + this.scale : this.median);
        return ret;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public double getNumericalMean() {
        return Double.NaN;
    }

    public double getNumericalVariance() {
        return Double.NaN;
    }
}

