/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileBlock;
import org.apache.batik.ext.awt.image.rendered.TileCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public abstract class AbstractTiledRed
extends AbstractRed
implements TileGenerator {
    private TileStore tiles;
    private static int defaultTileSize = 128;

    public static int getDefaultTileSize() {
        return defaultTileSize;
    }

    protected AbstractTiledRed() {
    }

    protected AbstractTiledRed(Rectangle bounds, Map props) {
        super(bounds, props);
    }

    protected AbstractTiledRed(CachableRed src, Map props) {
        super(src, props);
    }

    protected AbstractTiledRed(CachableRed src, Rectangle bounds, Map props) {
        super(src, bounds, props);
    }

    protected AbstractTiledRed(CachableRed src, Rectangle bounds, ColorModel cm, SampleModel sm, Map props) {
        super(src, bounds, cm, sm, props);
    }

    protected AbstractTiledRed(CachableRed src, Rectangle bounds, ColorModel cm, SampleModel sm, int tileGridXOff, int tileGridYOff, Map props) {
        super(src, bounds, cm, sm, tileGridXOff, tileGridYOff, props);
    }

    protected void init(CachableRed src, Rectangle bounds, ColorModel cm, SampleModel sm, int tileGridXOff, int tileGridYOff, Map props) {
        this.init(src, bounds, cm, sm, tileGridXOff, tileGridYOff, null, props);
    }

    protected void init(CachableRed src, Rectangle bounds, ColorModel cm, SampleModel sm, int tileGridXOff, int tileGridYOff, TileStore tiles, Map props) {
        super.init(src, bounds, cm, sm, tileGridXOff, tileGridYOff, props);
        this.tiles = tiles;
        if (this.tiles == null) {
            this.tiles = this.createTileStore();
        }
    }

    protected AbstractTiledRed(List srcs, Rectangle bounds, Map props) {
        super(srcs, bounds, props);
    }

    protected AbstractTiledRed(List srcs, Rectangle bounds, ColorModel cm, SampleModel sm, Map props) {
        super(srcs, bounds, cm, sm, props);
    }

    protected AbstractTiledRed(List srcs, Rectangle bounds, ColorModel cm, SampleModel sm, int tileGridXOff, int tileGridYOff, Map props) {
        super(srcs, bounds, cm, sm, tileGridXOff, tileGridYOff, props);
    }

    protected void init(List srcs, Rectangle bounds, ColorModel cm, SampleModel sm, int tileGridXOff, int tileGridYOff, Map props) {
        super.init(srcs, bounds, cm, sm, tileGridXOff, tileGridYOff, props);
        this.tiles = this.createTileStore();
    }

    public TileStore getTileStore() {
        return this.tiles;
    }

    protected void setTileStore(TileStore tiles) {
        this.tiles = tiles;
    }

    protected TileStore createTileStore() {
        return TileCache.getTileMap(this);
    }

    public WritableRaster copyData(WritableRaster wr) {
        this.copyToRasterByBlocks(wr);
        return wr;
    }

    public Raster getData(Rectangle rect) {
        int xt0 = this.getXTile(rect.x);
        int xt1 = this.getXTile(rect.x + rect.width - 1);
        int yt0 = this.getYTile(rect.y);
        int yt1 = this.getYTile(rect.y + rect.height - 1);
        if (xt0 == xt1 && yt0 == yt1) {
            Raster r2 = this.getTile(xt0, yt0);
            return r2.createChild(rect.x, rect.y, rect.width, rect.height, rect.x, rect.y, null);
        }
        return super.getData(rect);
    }

    public Raster getTile(int x2, int y) {
        return this.tiles.getTile(x2, y);
    }

    public Raster genTile(int x2, int y) {
        WritableRaster wr = this.makeTile(x2, y);
        this.genRect(wr);
        return wr;
    }

    public abstract void genRect(WritableRaster var1);

    public void setTile(int x2, int y, Raster ras) {
        this.tiles.setTile(x2, y, ras);
    }

    public void copyToRasterByBlocks(WritableRaster wr) {
        Raster ras;
        int ty;
        boolean is_INT_PACK = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        Rectangle bounds = this.getBounds();
        Rectangle wrR = wr.getBounds();
        int tx0 = this.getXTile(wrR.x);
        int ty0 = this.getYTile(wrR.y);
        int tx1 = this.getXTile(wrR.x + wrR.width - 1);
        int ty1 = this.getYTile(wrR.y + wrR.height - 1);
        if (tx0 < this.minTileX) {
            tx0 = this.minTileX;
        }
        if (ty0 < this.minTileY) {
            ty0 = this.minTileY;
        }
        if (tx1 >= this.minTileX + this.numXTiles) {
            tx1 = this.minTileX + this.numXTiles - 1;
        }
        if (ty1 >= this.minTileY + this.numYTiles) {
            ty1 = this.minTileY + this.numYTiles - 1;
        }
        if (tx1 < tx0 || ty1 < ty0) {
            return;
        }
        int insideTx0 = tx0;
        int insideTx1 = tx1;
        int insideTy0 = ty0;
        int insideTy1 = ty1;
        int tx = tx0 * this.tileWidth + this.tileGridXOff;
        if (tx < wrR.x && bounds.x != wrR.x) {
            ++insideTx0;
        }
        if ((ty = ty0 * this.tileHeight + this.tileGridYOff) < wrR.y && bounds.y != wrR.y) {
            ++insideTy0;
        }
        if ((tx = (tx1 + 1) * this.tileWidth + this.tileGridXOff - 1) >= wrR.x + wrR.width && bounds.x + bounds.width != wrR.x + wrR.width) {
            --insideTx1;
        }
        if ((ty = (ty1 + 1) * this.tileHeight + this.tileGridYOff - 1) >= wrR.y + wrR.height && bounds.y + bounds.height != wrR.y + wrR.height) {
            --insideTy1;
        }
        int xtiles = insideTx1 - insideTx0 + 1;
        int ytiles = insideTy1 - insideTy0 + 1;
        boolean[] occupied = null;
        if (xtiles > 0 && ytiles > 0) {
            occupied = new boolean[xtiles * ytiles];
        }
        boolean[] got = new boolean[2 * (tx1 - tx0 + 1) + 2 * (ty1 - ty0 + 1)];
        int idx = 0;
        int numFound = 0;
        int y = ty0;
        while (y <= ty1) {
            int x2 = tx0;
            while (x2 <= tx1) {
                boolean found;
                ras = this.tiles.getTileNoCompute(x2, y);
                boolean bl = found = ras != null;
                if (y >= insideTy0 && y <= insideTy1 && x2 >= insideTx0 && x2 <= insideTx1) {
                    occupied[x2 - insideTx0 + (y - insideTy0) * xtiles] = found;
                } else {
                    got[idx++] = found;
                }
                if (found) {
                    ++numFound;
                    if (is_INT_PACK) {
                        GraphicsUtil.copyData_INT_PACK(ras, wr);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(ras, wr);
                    }
                }
                ++x2;
            }
            ++y;
        }
        if (xtiles > 0 && ytiles > 0) {
            TileBlock block = new TileBlock(insideTx0, insideTy0, xtiles, ytiles, occupied, 0, 0, xtiles, ytiles);
            this.drawBlock(block, wr);
        }
        Thread currentThread = Thread.currentThread();
        if (HaltingThread.hasBeenHalted()) {
            return;
        }
        idx = 0;
        ty = ty0;
        while (ty <= ty1) {
            tx = tx0;
            while (tx <= tx1) {
                ras = this.tiles.getTileNoCompute(tx, ty);
                if (ty >= insideTy0 && ty <= insideTy1 && tx >= insideTx0 && tx <= insideTx1) {
                    if (ras == null) {
                        WritableRaster tile = this.makeTile(tx, ty);
                        if (is_INT_PACK) {
                            GraphicsUtil.copyData_INT_PACK(wr, tile);
                        } else {
                            GraphicsUtil.copyData_FALLBACK(wr, tile);
                        }
                        this.tiles.setTile(tx, ty, tile);
                    }
                } else if (!got[idx++]) {
                    ras = this.getTile(tx, ty);
                    if (HaltingThread.hasBeenHalted(currentThread)) {
                        return;
                    }
                    if (is_INT_PACK) {
                        GraphicsUtil.copyData_INT_PACK(ras, wr);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(ras, wr);
                    }
                }
                ++tx;
            }
            ++ty;
        }
    }

    public void copyToRaster(WritableRaster wr) {
        Rectangle wrR = wr.getBounds();
        int tx0 = this.getXTile(wrR.x);
        int ty0 = this.getYTile(wrR.y);
        int tx1 = this.getXTile(wrR.x + wrR.width - 1);
        int ty1 = this.getYTile(wrR.y + wrR.height - 1);
        if (tx0 < this.minTileX) {
            tx0 = this.minTileX;
        }
        if (ty0 < this.minTileY) {
            ty0 = this.minTileY;
        }
        if (tx1 >= this.minTileX + this.numXTiles) {
            tx1 = this.minTileX + this.numXTiles - 1;
        }
        if (ty1 >= this.minTileY + this.numYTiles) {
            ty1 = this.minTileY + this.numYTiles - 1;
        }
        boolean is_INT_PACK = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        int xtiles = tx1 - tx0 + 1;
        boolean[] got = new boolean[xtiles * (ty1 - ty0 + 1)];
        int y = ty0;
        while (y <= ty1) {
            int x2 = tx0;
            while (x2 <= tx1) {
                Raster r2 = this.tiles.getTileNoCompute(x2, y);
                if (r2 != null) {
                    got[x2 - tx0 + (y - ty0) * xtiles] = true;
                    if (is_INT_PACK) {
                        GraphicsUtil.copyData_INT_PACK(r2, wr);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(r2, wr);
                    }
                }
                ++x2;
            }
            ++y;
        }
        int y2 = ty0;
        while (y2 <= ty1) {
            int x3 = tx0;
            while (x3 <= tx1) {
                if (!got[x3 - tx0 + (y2 - ty0) * xtiles]) {
                    Raster r3 = this.getTile(x3, y2);
                    if (is_INT_PACK) {
                        GraphicsUtil.copyData_INT_PACK(r3, wr);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(r3, wr);
                    }
                }
                ++x3;
            }
            ++y2;
        }
    }

    protected void drawBlock(TileBlock block, WritableRaster wr) {
        TileBlock[] blocks = block.getBestSplit();
        if (blocks == null) {
            return;
        }
        this.drawBlockInPlace(blocks, wr);
    }

    protected void drawBlockAndCopy(TileBlock[] blocks, WritableRaster wr) {
        if (blocks.length == 1) {
            TileBlock curr = blocks[0];
            int xloc = curr.getXLoc() * this.tileWidth + this.tileGridXOff;
            int yloc = curr.getYLoc() * this.tileHeight + this.tileGridYOff;
            if (xloc == wr.getMinX() && yloc == wr.getMinY()) {
                this.drawBlockInPlace(blocks, wr);
                return;
            }
        }
        int workTileWidth = this.tileWidth;
        int workTileHeight = this.tileHeight;
        int maxTileSize = 0;
        int i2 = 0;
        while (i2 < blocks.length) {
            TileBlock curr = blocks[i2];
            int sz = curr.getWidth() * workTileWidth * (curr.getHeight() * workTileHeight);
            if (sz > maxTileSize) {
                maxTileSize = sz;
            }
            ++i2;
        }
        DataBufferInt dbi = new DataBufferInt(maxTileSize);
        int[] masks = new int[]{0xFF0000, 65280, 255, -16777216};
        boolean use_INT_PACK = GraphicsUtil.is_INT_PACK_Data(wr.getSampleModel(), false);
        Thread currentThread = Thread.currentThread();
        int i3 = 0;
        while (i3 < blocks.length) {
            TileBlock curr = blocks[i3];
            int xloc = curr.getXLoc() * workTileWidth + this.tileGridXOff;
            int yloc = curr.getYLoc() * workTileHeight + this.tileGridYOff;
            Rectangle tb = new Rectangle(xloc, yloc, curr.getWidth() * workTileWidth, curr.getHeight() * workTileHeight);
            tb = tb.intersection(this.bounds);
            Point loc = new Point(tb.x, tb.y);
            WritableRaster child = Raster.createPackedRaster(dbi, tb.width, tb.height, tb.width, masks, loc);
            this.genRect(child);
            if (use_INT_PACK) {
                GraphicsUtil.copyData_INT_PACK(child, wr);
            } else {
                GraphicsUtil.copyData_FALLBACK(child, wr);
            }
            if (HaltingThread.hasBeenHalted(currentThread)) {
                return;
            }
            ++i3;
        }
    }

    protected void drawBlockInPlace(TileBlock[] blocks, WritableRaster wr) {
        Thread currentThread = Thread.currentThread();
        int workTileWidth = this.tileWidth;
        int workTileHeight = this.tileHeight;
        int i2 = 0;
        while (i2 < blocks.length) {
            TileBlock curr = blocks[i2];
            int xloc = curr.getXLoc() * workTileWidth + this.tileGridXOff;
            int yloc = curr.getYLoc() * workTileHeight + this.tileGridYOff;
            Rectangle tb = new Rectangle(xloc, yloc, curr.getWidth() * workTileWidth, curr.getHeight() * workTileHeight);
            tb = tb.intersection(this.bounds);
            WritableRaster child = wr.createWritableChild(tb.x, tb.y, tb.width, tb.height, tb.x, tb.y, null);
            this.genRect(child);
            if (HaltingThread.hasBeenHalted(currentThread)) {
                return;
            }
            ++i2;
        }
    }
}

