/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoCredential;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.util.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class MongoCredentialsStore {
    private final Map<String, MongoCredential> credentialsMap = new HashMap<String, MongoCredential>();
    private volatile Set<String> allDatabasesWithCredentials = new HashSet<String>();

    public MongoCredentialsStore() {
    }

    public MongoCredentialsStore(MongoCredential credentials) {
        if (credentials == null) {
            return;
        }
        this.add(credentials);
    }

    public MongoCredentialsStore(Iterable<MongoCredential> credentialsList) {
        if (credentialsList == null) {
            return;
        }
        for (MongoCredential cur : credentialsList) {
            this.add(cur);
        }
    }

    synchronized void add(MongoCredential credentials) {
        MongoCredential existingCredentials = this.credentialsMap.get(credentials.getSource());
        if (existingCredentials != null) {
            if (existingCredentials.equals(credentials)) {
                return;
            }
            throw new IllegalArgumentException("Can't add more than one credentials for the same database");
        }
        this.credentialsMap.put(credentials.getSource(), credentials);
        this.allDatabasesWithCredentials = new HashSet<String>(this.allDatabasesWithCredentials);
        this.allDatabasesWithCredentials.add(credentials.getSource());
    }

    public Set<String> getDatabases() {
        return Collections.unmodifiableSet(this.allDatabasesWithCredentials);
    }

    public synchronized MongoCredential get(String database) {
        return this.credentialsMap.get(database);
    }

    public synchronized List<MongoCredential> asList() {
        return new ArrayList<MongoCredential>(this.credentialsMap.values());
    }

    public synchronized boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MongoCredentialsStore that = (MongoCredentialsStore)o2;
        return this.credentialsMap.equals(that.credentialsMap);
    }

    public synchronized int hashCode() {
        return this.credentialsMap.hashCode();
    }

    public String toString() {
        return "{credentials=" + this.credentialsMap + '}';
    }
}

