/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;

public class JidePopupMenu
extends JPopupMenu
implements Scrollable {
    private static final String uiClassID = "JidePopupMenuUI";
    private static final String uiClassIDAlternative = "PopupMenuUI";
    private boolean _useLightWeightPopup;

    public JidePopupMenu() {
        this.setupPopupMenu();
    }

    public JidePopupMenu(String label) {
        super(label);
        this.setupPopupMenu();
    }

    public String getUIClassID() {
        return UIDefaultsLookup.getBoolean("JidePopupMenu.uiExtensionDisabled") ? uiClassIDAlternative : uiClassID;
    }

    private void setupPopupMenu() {
        this.addPopupMenuListener(new ToolTipSwitchPopupMenuListener());
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(this.getUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    public void show(Component invoker, int x2, int y) {
        Point p2 = this.getPopupMenuOrigin(invoker, x2, y);
        super.show(invoker, p2.x, p2.y);
    }

    protected Point getPopupMenuOrigin(Component invoker, int x2, int y) {
        Dimension size = this.getPreferredSize();
        if (size.width == 0) {
            size = this.getPreferredScrollableViewportSize();
        }
        Point p2 = new Point(x2, y);
        SwingUtilities.convertPointToScreen(p2, invoker);
        Rectangle bounds = PortingUtils.ensureOnScreen(new Rectangle(p2, size));
        p2 = bounds.getLocation();
        SwingUtilities.convertPointFromScreen(p2, invoker);
        return p2;
    }

    public void setLocation(int x2, int y) {
        if (this.isVisible() && y <= 0) {
            this.move(x2, y);
        } else {
            super.setLocation(x2, y);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = this.getPreferredSize();
        Dimension screenSize = PortingUtils.getLocalScreenSize(this);
        Container container = SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this);
        if (container instanceof SimpleScrollPane) {
            SimpleScrollPane scrollPane = (SimpleScrollPane)container;
            size.height = Math.min(size.height, screenSize.height - scrollPane.getScrollUpButton().getPreferredSize().height - scrollPane.getScrollDownButton().getPreferredSize().height);
        }
        return size;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return new JMenuItem((String)"ABC").getPreferredSize().height;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return new JMenuItem((String)"ABC").getPreferredSize().height * 5;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private class ToolTipSwitchPopupMenuListener
    implements PopupMenuListener {
        private ToolTipSwitchPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
            JidePopupMenu.this._useLightWeightPopup = ToolTipManager.sharedInstance().isLightWeightPopupEnabled();
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(JidePopupMenu.this._useLightWeightPopup);
        }

        public void popupMenuCanceled(PopupMenuEvent e2) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(JidePopupMenu.this._useLightWeightPopup);
        }
    }
}

