/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.pairhmm.N2MemoryPairHMM;

public final class LoglessPairHMM
extends N2MemoryPairHMM {
    protected static final double INITIAL_CONDITION = Math.pow(2.0, 1020.0);
    protected static final double INITIAL_CONDITION_LOG10 = Math.log10(INITIAL_CONDITION);
    private static final int matchToMatch = 0;
    private static final int indelToMatch = 1;
    private static final int matchToInsertion = 2;
    private static final int insertionToInsertion = 3;
    private static final int matchToDeletion = 4;
    private static final int deletionToDeletion = 5;

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        this.transition = new double[this.paddedMaxReadLength][6];
        this.prior = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
    }

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues) {
        if (this.previousHaplotypeBases == null || this.previousHaplotypeBases.length != haplotypeBases.length) {
            double initialValue = INITIAL_CONDITION / (double)haplotypeBases.length;
            for (int j = 0; j < this.paddedHaplotypeLength; ++j) {
                this.deletionMatrix[0][j] = initialValue;
            }
        }
        if (!this.constantsAreInitialized || recacheReadValues) {
            LoglessPairHMM.initializeProbabilities(this.transition, insertionGOP, deletionGOP, overallGCP);
            this.constantsAreInitialized = true;
        }
        this.initializePriors(haplotypeBases, readBases, readQuals, hapStartIndex);
        for (int i = 1; i < this.paddedReadLength; ++i) {
            for (int j = hapStartIndex + 1; j < this.paddedHaplotypeLength; ++j) {
                this.updateCell(i, j, this.prior[i][j], this.transition[i]);
            }
        }
        int endI = this.paddedReadLength - 1;
        double finalSumProbabilities = 0.0;
        for (int j = 1; j < this.paddedHaplotypeLength; ++j) {
            finalSumProbabilities += this.matchMatrix[endI][j] + this.insertionMatrix[endI][j];
        }
        return Math.log10(finalSumProbabilities) - INITIAL_CONDITION_LOG10;
    }

    public void initializePriors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i = 0; i < readBases.length; ++i) {
            byte x = readBases[i];
            byte qual = readQuals[i];
            for (int j = startIndex; j < haplotypeBases.length; ++j) {
                byte y = haplotypeBases[j];
                this.prior[i + 1][j + 1] = x == y || x == 78 || y == 78 ? QualityUtils.qualToProb(qual) : QualityUtils.qualToErrorProb(qual);
            }
        }
    }

    @Requires(value={"insertionGOP != null", "deletionGOP != null", "overallGCP != null"})
    @Ensures(value={"constantsAreInitialized"})
    protected static void initializeProbabilities(double[][] transition, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        for (int i = 0; i < insertionGOP.length; ++i) {
            int qualIndexGOP = Math.min(insertionGOP[i] + deletionGOP[i], 127);
            transition[i + 1][0] = QualityUtils.qualToProb((byte)qualIndexGOP);
            transition[i + 1][1] = QualityUtils.qualToProb(overallGCP[i]);
            transition[i + 1][2] = QualityUtils.qualToErrorProb(insertionGOP[i]);
            transition[i + 1][3] = QualityUtils.qualToErrorProb(overallGCP[i]);
            transition[i + 1][4] = QualityUtils.qualToErrorProb(deletionGOP[i]);
            transition[i + 1][5] = QualityUtils.qualToErrorProb(overallGCP[i]);
        }
    }

    private void updateCell(int indI, int indJ, double prior, double[] transition) {
        this.matchMatrix[indI][indJ] = prior * (this.matchMatrix[indI - 1][indJ - 1] * transition[0] + this.insertionMatrix[indI - 1][indJ - 1] * transition[1] + this.deletionMatrix[indI - 1][indJ - 1] * transition[1]);
        this.insertionMatrix[indI][indJ] = this.matchMatrix[indI - 1][indJ] * transition[2] + this.insertionMatrix[indI - 1][indJ] * transition[3];
        this.deletionMatrix[indI][indJ] = this.matchMatrix[indI][indJ - 1] * transition[4] + this.deletionMatrix[indI][indJ - 1] * transition[5];
    }
}

