/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.CommonInfo;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.GenotypeType;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLineCount;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;

public class VariantContext
implements Feature {
    private static final boolean WARN_ABOUT_BAD_END = true;
    private static final int MAX_ALLELE_SIZE_FOR_NON_SV = 150;
    private boolean fullyDecoded = false;
    protected CommonInfo commonInfo = null;
    public static final double NO_LOG10_PERROR = 1.0;
    public static final Set<String> PASSES_FILTERS = Collections.unmodifiableSet(new LinkedHashSet());
    protected final String contig;
    protected final long start;
    protected final long stop;
    private final String ID;
    protected Type type = null;
    protected final List<Allele> alleles;
    protected GenotypesContext genotypes = null;
    protected int[] genotypeCounts = null;
    public static final GenotypesContext NO_GENOTYPES = GenotypesContext.NO_GENOTYPES;
    private Allele REF = null;
    private Allele ALT = null;
    private Boolean monomorphic = null;
    private static final EnumSet<Validation> NO_VALIDATION = EnumSet.noneOf(Validation.class);

    public List<String> calcVCFGenotypeKeys(VCFHeader header) {
        HashSet<String> keys = new HashSet<String>();
        boolean sawGoodGT = false;
        boolean sawGoodQual = false;
        boolean sawGenotypeFilter = false;
        boolean sawDP = false;
        boolean sawAD = false;
        boolean sawPL = false;
        for (Genotype g : this.getGenotypes()) {
            keys.addAll(g.getExtendedAttributes().keySet());
            if (g.isAvailable()) {
                sawGoodGT = true;
            }
            if (g.hasGQ()) {
                sawGoodQual = true;
            }
            if (g.hasDP()) {
                sawDP = true;
            }
            if (g.hasAD()) {
                sawAD = true;
            }
            if (g.hasPL()) {
                sawPL = true;
            }
            if (!g.isFiltered()) continue;
            sawGenotypeFilter = true;
        }
        if (sawGoodQual) {
            keys.add("GQ");
        }
        if (sawDP) {
            keys.add("DP");
        }
        if (sawAD) {
            keys.add("AD");
        }
        if (sawPL) {
            keys.add("PL");
        }
        if (sawGenotypeFilter) {
            keys.add("FT");
        }
        ArrayList<String> sortedList = ParsingUtils.sortList(new ArrayList(keys));
        if (sawGoodGT) {
            ArrayList<String> newList = new ArrayList<String>(sortedList.size() + 1);
            newList.add("GT");
            newList.addAll(sortedList);
            sortedList = newList;
        }
        if (sortedList.isEmpty() && header.hasGenotypingData()) {
            return Collections.singletonList("GT");
        }
        return sortedList;
    }

    protected VariantContext(VariantContext other) {
        this(other.getSource(), other.getID(), other.getChr(), other.getStart(), other.getEnd(), other.getAlleles(), other.getGenotypes(), other.getLog10PError(), other.getFiltersMaybeNull(), other.getAttributes(), other.fullyDecoded, NO_VALIDATION);
    }

    protected VariantContext(String source, String ID, String contig, long start, long stop, Collection<Allele> alleles, GenotypesContext genotypes, double log10PError, Set<String> filters, Map<String, Object> attributes, boolean fullyDecoded, EnumSet<Validation> validationToPerform) {
        if (contig == null) {
            throw new IllegalArgumentException("Contig cannot be null");
        }
        this.contig = contig;
        this.start = start;
        this.stop = stop;
        if (ID == null || ID.equals("")) {
            throw new IllegalArgumentException("ID field cannot be the null or the empty string");
        }
        this.ID = ID.equals(".") ? "." : ID;
        this.commonInfo = new CommonInfo(source, log10PError, filters, attributes);
        if (alleles == null) {
            throw new IllegalArgumentException("Alleles cannot be null");
        }
        this.alleles = VariantContext.makeAlleles(alleles);
        this.genotypes = genotypes == null || genotypes == NO_GENOTYPES ? NO_GENOTYPES : genotypes.immutable();
        int nAlleles = alleles.size();
        for (Allele a : alleles) {
            if (a.isReference()) {
                this.REF = a;
                continue;
            }
            if (nAlleles != 2) continue;
            this.ALT = a;
        }
        this.fullyDecoded = fullyDecoded;
        if (!validationToPerform.isEmpty()) {
            this.validate(validationToPerform);
        }
    }

    public VariantContext subContextFromSamples(Set<String> sampleNames, boolean rederiveAllelesFromGenotypes) {
        if (sampleNames.containsAll(this.getSampleNames()) && !rederiveAllelesFromGenotypes) {
            return this;
        }
        VariantContextBuilder builder = new VariantContextBuilder(this);
        GenotypesContext newGenotypes = this.genotypes.subsetToSamples(sampleNames);
        if (rederiveAllelesFromGenotypes) {
            builder.alleles(this.allelesOfGenotypes(newGenotypes));
        } else {
            builder.alleles((Collection<Allele>)this.alleles);
        }
        return builder.genotypes(newGenotypes).make();
    }

    public VariantContext subContextFromSamples(Set<String> sampleNames) {
        return this.subContextFromSamples(sampleNames, true);
    }

    public VariantContext subContextFromSample(String sampleName) {
        return this.subContextFromSamples(Collections.singleton(sampleName));
    }

    private final Set<Allele> allelesOfGenotypes(Collection<Genotype> genotypes) {
        HashSet<Allele> alleles = new HashSet<Allele>();
        boolean addedref = false;
        for (Genotype g : genotypes) {
            for (Allele a : g.getAlleles()) {
                boolean bl = addedref = addedref || a.isReference();
                if (!a.isCalled()) continue;
                alleles.add(a);
            }
        }
        if (!addedref) {
            alleles.add(this.getReference());
        }
        return alleles;
    }

    public Type getType() {
        if (this.type == null) {
            this.determineType();
        }
        return this.type;
    }

    public boolean isSNP() {
        return this.getType() == Type.SNP;
    }

    public boolean isVariant() {
        return this.getType() != Type.NO_VARIATION;
    }

    public boolean isPointEvent() {
        return this.isSNP() || !this.isVariant();
    }

    public boolean isIndel() {
        return this.getType() == Type.INDEL;
    }

    public boolean isSimpleInsertion() {
        return this.isSimpleIndel() && this.getReference().length() == 1;
    }

    public boolean isSimpleDeletion() {
        return this.isSimpleIndel() && this.getAlternateAllele(0).length() == 1;
    }

    public boolean isSimpleIndel() {
        return this.getType() == Type.INDEL && this.isBiallelic() && this.getReference().length() > 0 && this.getAlternateAllele(0).length() > 0 && this.getReference().getBases()[0] == this.getAlternateAllele(0).getBases()[0] && (this.getReference().length() == 1 || this.getAlternateAllele(0).length() == 1);
    }

    public boolean isComplexIndel() {
        return this.isIndel() && !this.isSimpleDeletion() && !this.isSimpleInsertion();
    }

    public boolean isSymbolic() {
        return this.getType() == Type.SYMBOLIC;
    }

    public boolean isStructuralIndel() {
        List<Integer> sizes;
        if (this.getType() == Type.INDEL && (sizes = this.getIndelLengths()) != null) {
            for (Integer length : sizes) {
                if (length <= 150) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSymbolicOrSV() {
        return this.isSymbolic() || this.isStructuralIndel();
    }

    public boolean isMNP() {
        return this.getType() == Type.MNP;
    }

    public boolean isMixed() {
        return this.getType() == Type.MIXED;
    }

    public boolean hasID() {
        return this.getID() != ".";
    }

    public boolean emptyID() {
        return !this.hasID();
    }

    public String getID() {
        return this.ID;
    }

    public String getSource() {
        return this.commonInfo.getName();
    }

    public Set<String> getFiltersMaybeNull() {
        return this.commonInfo.getFiltersMaybeNull();
    }

    public Set<String> getFilters() {
        return this.commonInfo.getFilters();
    }

    public boolean isFiltered() {
        return this.commonInfo.isFiltered();
    }

    public boolean isNotFiltered() {
        return this.commonInfo.isNotFiltered();
    }

    public boolean filtersWereApplied() {
        return this.commonInfo.filtersWereApplied();
    }

    public boolean hasLog10PError() {
        return this.commonInfo.hasLog10PError();
    }

    public double getLog10PError() {
        return this.commonInfo.getLog10PError();
    }

    public double getPhredScaledQual() {
        return this.commonInfo.getPhredScaledQual();
    }

    public Map<String, Object> getAttributes() {
        return this.commonInfo.getAttributes();
    }

    public boolean hasAttribute(String key) {
        return this.commonInfo.hasAttribute(key);
    }

    public Object getAttribute(String key) {
        return this.commonInfo.getAttribute(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        return this.commonInfo.getAttribute(key, defaultValue);
    }

    public String getAttributeAsString(String key, String defaultValue) {
        return this.commonInfo.getAttributeAsString(key, defaultValue);
    }

    public int getAttributeAsInt(String key, int defaultValue) {
        return this.commonInfo.getAttributeAsInt(key, defaultValue);
    }

    public double getAttributeAsDouble(String key, double defaultValue) {
        return this.commonInfo.getAttributeAsDouble(key, defaultValue);
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        return this.commonInfo.getAttributeAsBoolean(key, defaultValue);
    }

    public CommonInfo getCommonInfo() {
        return this.commonInfo;
    }

    public Allele getReference() {
        Allele ref = this.REF;
        if (ref == null) {
            throw new IllegalStateException("BUG: no reference allele found at " + this);
        }
        return ref;
    }

    public boolean isBiallelic() {
        return this.getNAlleles() == 2;
    }

    public int getNAlleles() {
        return this.alleles.size();
    }

    public int getMaxPloidy(int defaultPloidy) {
        return this.genotypes.getMaxPloidy(defaultPloidy);
    }

    public Allele getAllele(String allele) {
        return this.getAllele(allele.getBytes());
    }

    public Allele getAllele(byte[] allele) {
        return Allele.getMatchingAllele(this.getAlleles(), allele);
    }

    public boolean hasAllele(Allele allele) {
        return this.hasAllele(allele, false, true);
    }

    public boolean hasAllele(Allele allele, boolean ignoreRefState) {
        return this.hasAllele(allele, ignoreRefState, true);
    }

    public boolean hasAlternateAllele(Allele allele) {
        return this.hasAllele(allele, false, false);
    }

    public boolean hasAlternateAllele(Allele allele, boolean ignoreRefState) {
        return this.hasAllele(allele, ignoreRefState, false);
    }

    private boolean hasAllele(Allele allele, boolean ignoreRefState, boolean considerRefAllele) {
        if (considerRefAllele && allele == this.REF || allele == this.ALT) {
            return true;
        }
        List<Allele> allelesToConsider = considerRefAllele ? this.getAlleles() : this.getAlternateAlleles();
        for (Allele a : allelesToConsider) {
            if (!a.equals(allele, ignoreRefState)) continue;
            return true;
        }
        return false;
    }

    public List<Allele> getAlleles() {
        return this.alleles;
    }

    public List<Allele> getAlternateAlleles() {
        return this.alleles.subList(1, this.alleles.size());
    }

    public List<Integer> getIndelLengths() {
        if (this.getType() != Type.INDEL && this.getType() != Type.MIXED) {
            return null;
        }
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (Allele a : this.getAlternateAlleles()) {
            lengths.add(a.length() - this.getReference().length());
        }
        return lengths;
    }

    public Allele getAlternateAllele(int i) {
        return this.alleles.get(i + 1);
    }

    public boolean hasSameAllelesAs(VariantContext other) {
        return this.hasSameAlternateAllelesAs(other) && other.getReference().equals(this.getReference(), false);
    }

    public boolean hasSameAlternateAllelesAs(VariantContext other) {
        List<Allele> thisAlternateAlleles = this.getAlternateAlleles();
        List<Allele> otherAlternateAlleles = other.getAlternateAlleles();
        if (thisAlternateAlleles.size() != otherAlternateAlleles.size()) {
            return false;
        }
        for (Allele allele : thisAlternateAlleles) {
            if (otherAlternateAlleles.contains(allele)) continue;
            return false;
        }
        return true;
    }

    public int getNSamples() {
        return this.genotypes.size();
    }

    public boolean hasGenotypes() {
        return !this.genotypes.isEmpty();
    }

    public boolean hasGenotypes(Collection<String> sampleNames) {
        return this.genotypes.containsSamples(sampleNames);
    }

    public GenotypesContext getGenotypes() {
        return this.genotypes;
    }

    public Iterable<Genotype> getGenotypesOrderedByName() {
        return this.genotypes.iterateInSampleNameOrder();
    }

    public Iterable<Genotype> getGenotypesOrderedBy(Iterable<String> sampleOrdering) {
        return this.genotypes.iterateInSampleNameOrder(sampleOrdering);
    }

    public GenotypesContext getGenotypes(String sampleName) {
        return this.getGenotypes(Collections.singleton(sampleName));
    }

    protected GenotypesContext getGenotypes(Collection<String> sampleNames) {
        return this.getGenotypes().subsetToSamples(new HashSet<String>(sampleNames));
    }

    public GenotypesContext getGenotypes(Set<String> sampleNames) {
        return this.getGenotypes().subsetToSamples(sampleNames);
    }

    public Set<String> getSampleNames() {
        return this.getGenotypes().getSampleNames();
    }

    public List<String> getSampleNamesOrderedByName() {
        return this.getGenotypes().getSampleNamesOrderedByName();
    }

    public Genotype getGenotype(String sample) {
        return this.getGenotypes().get(sample);
    }

    public boolean hasGenotype(String sample) {
        return this.getGenotypes().containsSample(sample);
    }

    public Genotype getGenotype(int ith) {
        return this.genotypes.get(ith);
    }

    public int getCalledChrCount() {
        Set<String> noSamples = Collections.emptySet();
        return this.getCalledChrCount(noSamples);
    }

    public int getCalledChrCount(Set<String> sampleIds) {
        int n = 0;
        GenotypesContext genotypes = sampleIds.isEmpty() ? this.getGenotypes() : this.getGenotypes(sampleIds);
        for (Genotype g : genotypes) {
            for (Allele a : g.getAlleles()) {
                n += a.isNoCall() ? 0 : 1;
            }
        }
        return n;
    }

    public int getCalledChrCount(Allele a) {
        return this.getCalledChrCount(a, new HashSet<String>(0));
    }

    public int getCalledChrCount(Allele a, Set<String> sampleIds) {
        int n = 0;
        GenotypesContext genotypes = sampleIds.isEmpty() ? this.getGenotypes() : this.getGenotypes(sampleIds);
        for (Genotype g : genotypes) {
            n += g.countAllele(a);
        }
        return n;
    }

    public boolean isMonomorphicInSamples() {
        if (this.monomorphic == null) {
            this.monomorphic = !this.isVariant() || this.hasGenotypes() && this.getCalledChrCount(this.getReference()) == this.getCalledChrCount();
        }
        return this.monomorphic;
    }

    public boolean isPolymorphicInSamples() {
        return !this.isMonomorphicInSamples();
    }

    private void calculateGenotypeCounts() {
        if (this.genotypeCounts == null) {
            this.genotypeCounts = new int[GenotypeType.values().length];
            for (Genotype g : this.getGenotypes()) {
                int n = g.getType().ordinal();
                this.genotypeCounts[n] = this.genotypeCounts[n] + 1;
            }
        }
    }

    public int getNoCallCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.NO_CALL.ordinal()];
    }

    public int getHomRefCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.HOM_REF.ordinal()];
    }

    public int getHetCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.HET.ordinal()];
    }

    public int getHomVarCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.HOM_VAR.ordinal()];
    }

    public int getMixedCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[GenotypeType.MIXED.ordinal()];
    }

    public void extraStrictValidation(Allele reportedReference, Allele observedReference, Set<String> rsIDs) {
        this.validateReferenceBases(reportedReference, observedReference);
        this.validateRSIDs(rsIDs);
        this.validateAlternateAlleles();
        this.validateChromosomeCounts();
    }

    public void validateReferenceBases(Allele reportedReference, Allele observedReference) {
        if (reportedReference != null && !reportedReference.basesMatch(observedReference)) {
            throw new TribbleException.InternalCodecException(String.format("the REF allele is incorrect for the record at position %s:%d, fasta says %s vs. VCF says %s", this.getChr(), this.getStart(), observedReference.getBaseString(), reportedReference.getBaseString()));
        }
    }

    public void validateRSIDs(Set<String> rsIDs) {
        if (rsIDs != null && this.hasID()) {
            for (String id : this.getID().split(";")) {
                if (!id.startsWith("rs") || rsIDs.contains(id)) continue;
                throw new TribbleException.InternalCodecException(String.format("the rsID %s for the record at position %s:%d is not in dbSNP", id, this.getChr(), this.getStart()));
            }
        }
    }

    public void validateAlternateAlleles() {
        if (!this.hasGenotypes()) {
            return;
        }
        List<Allele> reportedAlleles = this.getAlleles();
        HashSet<Allele> observedAlleles = new HashSet<Allele>();
        observedAlleles.add(this.getReference());
        for (Genotype g : this.getGenotypes()) {
            if (!g.isCalled()) continue;
            observedAlleles.addAll(g.getAlleles());
        }
        if (observedAlleles.contains(Allele.NO_CALL)) {
            observedAlleles.remove(Allele.NO_CALL);
        }
        if (reportedAlleles.size() != observedAlleles.size()) {
            throw new TribbleException.InternalCodecException(String.format("one or more of the ALT allele(s) for the record at position %s:%d are not observed at all in the sample genotypes", this.getChr(), this.getStart()));
        }
        int originalSize = reportedAlleles.size();
        observedAlleles.retainAll(reportedAlleles);
        if (observedAlleles.size() != originalSize) {
            throw new TribbleException.InternalCodecException(String.format("one or more of the ALT allele(s) for the record at position %s:%d are not observed at all in the sample genotypes", this.getChr(), this.getStart()));
        }
    }

    public void validateChromosomeCounts() {
        int observedAN;
        int reportedAN;
        if (!this.hasGenotypes()) {
            return;
        }
        if (this.hasAttribute("AN") && (reportedAN = Integer.valueOf(this.getAttribute("AN").toString()).intValue()) != (observedAN = this.getCalledChrCount())) {
            throw new TribbleException.InternalCodecException(String.format("the Allele Number (AN) tag is incorrect for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedAN, observedAN));
        }
        if (this.hasAttribute("AC")) {
            ArrayList<Integer> observedACs = new ArrayList<Integer>();
            if (this.getAlternateAlleles().size() > 0) {
                for (Allele allele : this.getAlternateAlleles()) {
                    observedACs.add(this.getCalledChrCount(allele));
                }
            } else {
                observedACs.add(0);
            }
            if (this.getAttribute("AC") instanceof List) {
                Collections.sort(observedACs);
                List reportedACs = (List)this.getAttribute("AC");
                Collections.sort(reportedACs);
                if (observedACs.size() != reportedACs.size()) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag doesn't have the correct number of values for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedACs.size(), observedACs.size()));
                }
                for (int i = 0; i < observedACs.size(); ++i) {
                    if (Integer.valueOf(reportedACs.get(i).toString()) == observedACs.get(i)) continue;
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag is incorrect for the record at position %s:%d, %s vs. %d", this.getChr(), this.getStart(), reportedACs.get(i), observedACs.get(i)));
                }
            } else {
                if (observedACs.size() != 1) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag doesn't have enough values for the record at position %s:%d", this.getChr(), this.getStart()));
                }
                int reportedAC = Integer.valueOf(this.getAttribute("AC").toString());
                if (reportedAC != (Integer)observedACs.get(0)) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag is incorrect for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedAC, observedACs.get(0)));
                }
            }
        }
    }

    private boolean validate(EnumSet<Validation> validationToPerform) {
        this.validateStop();
        block4: for (Validation val : validationToPerform) {
            switch (val) {
                case ALLELES: {
                    this.validateAlleles();
                    continue block4;
                }
                case GENOTYPES: {
                    this.validateGenotypes();
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unexpected validation mode " + (Object)((Object)val));
        }
        return true;
    }

    private void validateStop() {
        if (this.hasAttribute("END")) {
            int end = this.getAttributeAsInt("END", -1);
            assert (end != -1);
            if (end != this.getEnd()) {
                String message = "Badly formed variant context at location " + this.getChr() + ":" + this.getStart() + "; getEnd() was " + this.getEnd() + " but this VariantContext contains an END key with value " + end;
                throw new TribbleException(message);
            }
        } else {
            long length = this.stop - this.start + 1L;
            if (!this.hasSymbolicAlleles() && length != (long)this.getReference().length()) {
                throw new IllegalStateException("BUG: GenomeLoc " + this.contig + ":" + this.start + "-" + this.stop + " has a size == " + length + " but the variation reference allele has length " + this.getReference().length() + " this = " + this);
            }
        }
    }

    private void validateAlleles() {
        boolean alreadySeenRef = false;
        for (Allele allele : this.alleles) {
            if (allele.isReference()) {
                if (alreadySeenRef) {
                    throw new IllegalArgumentException("BUG: Received two reference tagged alleles in VariantContext " + this.alleles + " this=" + this);
                }
                alreadySeenRef = true;
            }
            if (!allele.isNoCall()) continue;
            throw new IllegalArgumentException("BUG: Cannot add a no call allele to a variant context " + this.alleles + " this=" + this);
        }
        if (!alreadySeenRef) {
            throw new IllegalArgumentException("No reference allele found in VariantContext");
        }
    }

    private void validateGenotypes() {
        if (this.genotypes == null) {
            throw new IllegalStateException("Genotypes is null");
        }
        for (Genotype g : this.genotypes) {
            if (!g.isAvailable()) continue;
            for (Allele gAllele : g.getAlleles()) {
                if (this.hasAllele(gAllele) || !gAllele.isCalled()) continue;
                throw new IllegalStateException("Allele in genotype " + gAllele + " not in the variant context " + this.alleles);
            }
        }
    }

    private void determineType() {
        if (this.type == null) {
            switch (this.getNAlleles()) {
                case 0: {
                    throw new IllegalStateException("Unexpected error: requested type of VariantContext with no alleles!" + this);
                }
                case 1: {
                    this.type = Type.NO_VARIATION;
                    break;
                }
                default: {
                    this.determinePolymorphicType();
                }
            }
        }
    }

    private void determinePolymorphicType() {
        this.type = null;
        for (Allele allele : this.alleles) {
            if (allele == this.REF) continue;
            Type biallelicType = VariantContext.typeOfBiallelicVariant(this.REF, allele);
            if (this.type == null) {
                this.type = biallelicType;
                continue;
            }
            if (biallelicType == this.type) continue;
            this.type = Type.MIXED;
            return;
        }
    }

    private static Type typeOfBiallelicVariant(Allele ref, Allele allele) {
        if (ref.isSymbolic()) {
            throw new IllegalStateException("Unexpected error: encountered a record with a symbolic reference allele");
        }
        if (allele.isSymbolic()) {
            return Type.SYMBOLIC;
        }
        if (ref.length() == allele.length()) {
            if (allele.length() == 1) {
                return Type.SNP;
            }
            return Type.MNP;
        }
        return Type.INDEL;
    }

    public String toString() {
        return String.format("[VC %s @ %s Q%s of type=%s alleles=%s attr=%s GT=%s", new Object[]{this.getSource(), this.contig + ":" + (this.start - this.stop == 0L ? Long.valueOf(this.start) : this.start + "-" + this.stop), this.hasLog10PError() ? String.format("%.2f", this.getPhredScaledQual()) : ".", this.getType(), ParsingUtils.sortList(this.getAlleles()), ParsingUtils.sortedString(this.getAttributes()), this.getGenotypes()});
    }

    public String toStringWithoutGenotypes() {
        return String.format("[VC %s @ %s Q%s of type=%s alleles=%s attr=%s", new Object[]{this.getSource(), this.contig + ":" + (this.start - this.stop == 0L ? Long.valueOf(this.start) : this.start + "-" + this.stop), this.hasLog10PError() ? String.format("%.2f", this.getPhredScaledQual()) : ".", this.getType(), ParsingUtils.sortList(this.getAlleles()), ParsingUtils.sortedString(this.getAttributes())});
    }

    private static List<Allele> makeAlleles(Collection<Allele> alleles) {
        ArrayList<Allele> alleleList = new ArrayList<Allele>(alleles.size());
        boolean sawRef = false;
        for (Allele a : alleles) {
            for (Allele b : alleleList) {
                if (!a.equals(b, true)) continue;
                throw new IllegalArgumentException("Duplicate allele added to VariantContext: " + a);
            }
            if (a.isReference()) {
                if (sawRef) {
                    throw new IllegalArgumentException("Alleles for a VariantContext must contain at most one reference allele: " + alleles);
                }
                alleleList.add(0, a);
                sawRef = true;
                continue;
            }
            alleleList.add(a);
        }
        if (alleleList.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a VariantContext with an empty allele list");
        }
        if (((Allele)alleleList.get(0)).isNonReference()) {
            throw new IllegalArgumentException("Alleles for a VariantContext must contain at least one reference allele: " + alleles);
        }
        return alleleList;
    }

    public VariantContext fullyDecode(VCFHeader header, boolean lenientDecoding) {
        if (this.isFullyDecoded()) {
            return this;
        }
        VariantContextBuilder builder = new VariantContextBuilder(this);
        this.fullyDecodeInfo(builder, header, lenientDecoding);
        this.fullyDecodeGenotypes(builder, header);
        builder.fullyDecoded(true);
        return builder.make();
    }

    public boolean isFullyDecoded() {
        return this.fullyDecoded;
    }

    private final void fullyDecodeInfo(VariantContextBuilder builder, VCFHeader header, boolean lenientDecoding) {
        builder.attributes(this.fullyDecodeAttributes(this.getAttributes(), header, lenientDecoding));
    }

    private final Map<String, Object> fullyDecodeAttributes(Map<String, Object> attributes, VCFHeader header, boolean lenientDecoding) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>(10);
        for (Map.Entry<String, Object> attr : attributes.entrySet()) {
            int expSize;
            int obsSize;
            String field = attr.getKey();
            if (field.equals("FT")) continue;
            VCFCompoundHeaderLine format = VariantContextUtils.getMetaDataForField(header, field);
            Object decoded = this.decodeValue(field, attr.getValue(), format);
            if (decoded != null && !lenientDecoding && format.getCountType() != VCFHeaderLineCount.UNBOUNDED && format.getType() != VCFHeaderLineType.Flag && (obsSize = decoded instanceof List ? ((List)decoded).size() : 1) != (expSize = format.getCount(this))) {
                throw new TribbleException.InvalidHeader("Discordant field size detected for field " + field + " at " + this.getChr() + ":" + this.getStart() + ".  Field had " + obsSize + " values " + "but the header says this should have " + expSize + " values based on header record " + format);
            }
            newAttributes.put(field, decoded);
        }
        return newAttributes;
    }

    private final Object decodeValue(String field, Object value, VCFCompoundHeaderLine format) {
        if (value instanceof String) {
            if (field.equals("PL")) {
                return GenotypeLikelihoods.fromPLField((String)value);
            }
            String string = (String)value;
            if (string.indexOf(",") != -1) {
                String[] splits = string.split(",");
                ArrayList<Object> values = new ArrayList<Object>(splits.length);
                for (int i = 0; i < splits.length; ++i) {
                    values.add(this.decodeOne(field, splits[i], format));
                }
                return values;
            }
            return this.decodeOne(field, string, format);
        }
        if (value instanceof List && ((List)value).get(0) instanceof String) {
            List asList = (List)value;
            ArrayList<Object> values = new ArrayList<Object>(asList.size());
            for (String s : asList) {
                values.add(this.decodeOne(field, s, format));
            }
            return values;
        }
        return value;
    }

    private final Object decodeOne(String field, String string, VCFCompoundHeaderLine format) {
        try {
            if (string.equals(".")) {
                return null;
            }
            switch (format.getType()) {
                case Character: {
                    return string;
                }
                case Flag: {
                    boolean b;
                    boolean bl = b = Boolean.valueOf(string) != false || string.equals("1");
                    if (!b) {
                        throw new TribbleException("VariantContext FLAG fields " + field + " cannot contain false values" + " as seen at " + this.getChr() + ":" + this.getStart());
                    }
                    return b;
                }
                case String: {
                    return string;
                }
                case Integer: {
                    return Integer.valueOf(string);
                }
                case Float: {
                    return Double.valueOf(string);
                }
            }
            throw new TribbleException("Unexpected type for field" + field);
        }
        catch (NumberFormatException e) {
            throw new TribbleException("Could not decode field " + field + " with value " + string + " of declared type " + (Object)((Object)format.getType()));
        }
    }

    private final void fullyDecodeGenotypes(VariantContextBuilder builder, VCFHeader header) {
        GenotypesContext gc = new GenotypesContext();
        for (Genotype g : this.getGenotypes()) {
            gc.add(this.fullyDecodeGenotypes(g, header));
        }
        builder.genotypesNoValidation(gc);
    }

    private final Genotype fullyDecodeGenotypes(Genotype g, VCFHeader header) {
        Map<String, Object> map = this.fullyDecodeAttributes(g.getExtendedAttributes(), header, true);
        return new GenotypeBuilder(g).attributes(map).make();
    }

    public String getChr() {
        return this.contig;
    }

    public int getStart() {
        return (int)this.start;
    }

    public int getEnd() {
        return (int)this.stop;
    }

    public boolean hasSymbolicAlleles() {
        return VariantContext.hasSymbolicAlleles(this.getAlleles());
    }

    public static boolean hasSymbolicAlleles(List<Allele> alleles) {
        for (Allele a : alleles) {
            if (!a.isSymbolic()) continue;
            return true;
        }
        return false;
    }

    public Allele getAltAlleleWithHighestAlleleCount() {
        if (this.isBiallelic()) {
            return this.getAlternateAllele(0);
        }
        Allele best = null;
        int maxAC1 = 0;
        for (Allele a : this.getAlternateAlleles()) {
            int ac = this.getCalledChrCount(a);
            if (ac < maxAC1) continue;
            maxAC1 = ac;
            best = a;
        }
        return best;
    }

    public int getAlleleIndex(Allele allele) {
        return this.getAlleles().indexOf(allele);
    }

    public List<Integer> getAlleleIndices(Collection<Allele> alleles) {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        for (Allele allele : alleles) {
            indices.add(this.getAlleleIndex(allele));
        }
        return indices;
    }

    public int[] getGLIndecesOfAlternateAllele(Allele targetAllele) {
        int index = this.getAlleleIndex(targetAllele);
        if (index == -1) {
            throw new IllegalArgumentException("Allele " + targetAllele + " not in this VariantContex " + this);
        }
        return GenotypeLikelihoods.getPLIndecesOfAlleles(0, index);
    }

    public static enum Type {
        NO_VARIATION,
        SNP,
        MNP,
        INDEL,
        SYMBOLIC,
        MIXED;

    }

    public static enum Validation {
        ALLELES,
        GENOTYPES;

    }
}

