/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimplePool<T> {
    final int _max;
    private Queue<T> _stored = new ConcurrentLinkedQueue<T>();

    public SimplePool(int max) {
        this._max = max;
    }

    public SimplePool() {
        this._max = 1000;
    }

    protected abstract T createNew();

    protected boolean ok(T t) {
        return true;
    }

    public T get() {
        T t = this._stored.poll();
        if (t != null) {
            return t;
        }
        return this.createNew();
    }

    public void done(T t) {
        if (!this.ok(t)) {
            return;
        }
        if (this._stored.size() > this._max) {
            return;
        }
        this._stored.add(t);
    }
}

