/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.nanoScheduler;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.MultiThreadedErrorTracker;
import org.broadinstitute.sting.utils.nanoScheduler.InputProducer;
import org.broadinstitute.sting.utils.nanoScheduler.MapResult;
import org.broadinstitute.sting.utils.nanoScheduler.MapResultsQueue;
import org.broadinstitute.sting.utils.nanoScheduler.NSMapFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NSProgressFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NSReduceFunction;
import org.broadinstitute.sting.utils.nanoScheduler.Reducer;
import org.broadinstitute.sting.utils.threading.NamedThreadFactory;

public class NanoScheduler<InputType, MapType, ReduceType> {
    private static final Logger logger = Logger.getLogger(NanoScheduler.class);
    private static final boolean ALLOW_SINGLE_THREAD_FASTPATH = true;
    protected static final int UPDATE_PROGRESS_FREQ = 100;
    final int bufferSize;
    final int nThreads;
    final ExecutorService masterExecutor;
    final ExecutorService mapExecutor;
    final MultiThreadedErrorTracker errorTracker = new MultiThreadedErrorTracker();
    boolean shutdown = false;
    boolean debug = false;
    private NSProgressFunction<InputType> progressFunction = null;

    public NanoScheduler(int nThreads) {
        this(nThreads * 100, nThreads);
    }

    protected NanoScheduler(int bufferSize, int nThreads) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must be >= 1, got " + bufferSize);
        }
        if (nThreads < 1) {
            throw new IllegalArgumentException("nThreads must be >= 1, got " + nThreads);
        }
        this.bufferSize = bufferSize;
        this.nThreads = nThreads;
        if (nThreads == 1) {
            this.masterExecutor = null;
            this.mapExecutor = null;
        } else {
            this.masterExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory("NS-master-thread-%d"));
            this.mapExecutor = Executors.newFixedThreadPool(nThreads, new NamedThreadFactory("NS-map-thread-%d"));
        }
    }

    @Ensures(value={"result > 0"})
    public int getnThreads() {
        return this.nThreads;
    }

    @Ensures(value={"result > 0"})
    public int getBufferSize() {
        return this.bufferSize;
    }

    public void shutdown() {
        if (this.nThreads > 1) {
            this.shutdownExecutor("mapExecutor", this.mapExecutor);
            this.shutdownExecutor("masterExecutor", this.masterExecutor);
        }
        this.shutdown = true;
    }

    @Requires(value={"name != null", "executorService != null"})
    @Ensures(value={"executorService.isShutdown()"})
    private void shutdownExecutor(String name, ExecutorService executorService) {
        if (executorService.isShutdown() || executorService.isTerminated()) {
            throw new IllegalStateException("Executor service " + name + " is already shut down!");
        }
        List<Runnable> remaining = executorService.shutdownNow();
        if (!remaining.isEmpty()) {
            throw new IllegalStateException(remaining.size() + " remaining tasks found in an executor " + name + ", unexpected behavior!");
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isDebug() {
        return this.debug;
    }

    @Requires(value={"format != null"})
    protected void debugPrint(String format, Object ... args) {
        if (this.isDebug()) {
            logger.warn((Object)("Thread " + Thread.currentThread().getId() + ":" + String.format(format, args)));
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setProgressFunction(NSProgressFunction<InputType> progressFunction) {
        this.progressFunction = progressFunction;
    }

    public ReduceType execute(Iterator<InputType> inputReader, NSMapFunction<InputType, MapType> map, ReduceType initialValue, NSReduceFunction<MapType, ReduceType> reduce) {
        if (this.isShutdown()) {
            throw new IllegalStateException("execute called on already shutdown NanoScheduler");
        }
        if (inputReader == null) {
            throw new IllegalArgumentException("inputReader cannot be null");
        }
        if (map == null) {
            throw new IllegalArgumentException("map function cannot be null");
        }
        if (reduce == null) {
            throw new IllegalArgumentException("reduce function cannot be null");
        }
        ReduceType result = this.getnThreads() == 1 ? this.executeSingleThreaded(inputReader, map, initialValue, reduce) : this.executeMultiThreaded(inputReader, map, initialValue, reduce);
        return result;
    }

    @Requires(value={"inputReader != null", "map != null", "reduce != null"})
    private ReduceType executeSingleThreaded(Iterator<InputType> inputReader, NSMapFunction<InputType, MapType> map, ReduceType initialValue, NSReduceFunction<MapType, ReduceType> reduce) {
        ReduceType sum = initialValue;
        int i = 0;
        while (inputReader.hasNext()) {
            InputType input = inputReader.next();
            MapType mapValue = map.apply(input);
            this.updateProgress(i++, input);
            sum = reduce.apply(mapValue, sum);
        }
        return sum;
    }

    private void updateProgress(int counter, InputType input) {
        if (this.progressFunction != null && counter % 100 == 0) {
            this.progressFunction.progress(input);
        }
    }

    @Requires(value={"inputReader != null", "map != null", "reduce != null"})
    private ReduceType executeMultiThreaded(Iterator<InputType> inputReader, NSMapFunction<InputType, MapType> map, ReduceType initialValue, NSReduceFunction<MapType, ReduceType> reduce) {
        this.debugPrint("Executing nanoScheduler", new Object[0]);
        MasterJob masterJob = new MasterJob(inputReader, map, initialValue, reduce);
        Future reduceResult = this.masterExecutor.submit(masterJob);
        while (true) {
            this.handleErrors();
            try {
                Object result = reduceResult.get(100L, TimeUnit.MILLISECONDS);
                this.handleErrors();
                return (ReduceType)result;
            }
            catch (TimeoutException ex) {
                continue;
            }
            catch (InterruptedException ex) {
                this.errorTracker.notifyOfError(ex);
                continue;
            }
            catch (ExecutionException ex) {
                this.errorTracker.notifyOfError(ex);
                continue;
            }
            break;
        }
    }

    private void handleErrors() {
        if (this.errorTracker.hasAnErrorOccurred()) {
            this.masterExecutor.shutdownNow();
            this.mapExecutor.shutdownNow();
            this.errorTracker.throwErrorIfPending();
        }
    }

    private class ReadMapReduceJob
    implements Runnable {
        final InputProducer<InputType> inputProducer;
        final MapResultsQueue<MapType> mapResultQueue;
        final NSMapFunction<InputType, MapType> map;
        final Reducer<MapType, ReduceType> reducer;
        final CountDownLatch runningMapJobs;

        private ReadMapReduceJob(InputProducer<InputType> inputProducer, MapResultsQueue<MapType> mapResultQueue, CountDownLatch runningMapJobs, NSMapFunction<InputType, MapType> map, Reducer<MapType, ReduceType> reducer) {
            this.inputProducer = inputProducer;
            this.mapResultQueue = mapResultQueue;
            this.runningMapJobs = runningMapJobs;
            this.map = map;
            this.reducer = reducer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean done = false;
                while (!done) {
                    InputProducer.InputValue inputWrapper = this.inputProducer.next();
                    if (!inputWrapper.isEOFMarker()) {
                        Object input = inputWrapper.getValue();
                        Object mapValue = this.map.apply(input);
                        MapResult result = new MapResult(mapValue, inputWrapper.getId());
                        this.mapResultQueue.put(result);
                        int nReduced = this.reducer.reduceAsMuchAsPossible(this.mapResultQueue, false);
                        NanoScheduler.this.updateProgress(inputWrapper.getId(), input);
                        continue;
                    }
                    done = true;
                }
            }
            catch (Throwable ex) {
                NanoScheduler.this.errorTracker.notifyOfError(ex);
            }
            finally {
                this.runningMapJobs.countDown();
            }
        }
    }

    private class MasterJob
    implements Callable<ReduceType> {
        final Iterator<InputType> inputReader;
        final NSMapFunction<InputType, MapType> map;
        final ReduceType initialValue;
        final NSReduceFunction<MapType, ReduceType> reduce;

        private MasterJob(Iterator<InputType> inputReader, NSMapFunction<InputType, MapType> map, ReduceType initialValue, NSReduceFunction<MapType, ReduceType> reduce) {
            this.inputReader = inputReader;
            this.map = map;
            this.initialValue = initialValue;
            this.reduce = reduce;
        }

        @Override
        public ReduceType call() {
            InputProducer inputProducer = new InputProducer(this.inputReader);
            MapResultsQueue mapResultQueue = new MapResultsQueue();
            Reducer reducer = new Reducer(this.reduce, NanoScheduler.this.errorTracker, this.initialValue);
            CountDownLatch runningMapJobs = new CountDownLatch(NanoScheduler.this.nThreads);
            try {
                for (int i = 0; i < NanoScheduler.this.nThreads; ++i) {
                    NanoScheduler.this.mapExecutor.submit(new ReadMapReduceJob(inputProducer, mapResultQueue, runningMapJobs, this.map, reducer));
                }
                return this.waitForCompletion(mapResultQueue, runningMapJobs, reducer);
            }
            catch (Throwable ex) {
                NanoScheduler.this.errorTracker.notifyOfError(ex);
                return this.initialValue;
            }
        }

        private ReduceType waitForCompletion(MapResultsQueue<MapType> mapResultsQueue, CountDownLatch runningMapJobs, Reducer<MapType, ReduceType> reducer) throws InterruptedException {
            runningMapJobs.await();
            reducer.reduceAsMuchAsPossible(mapResultsQueue, true);
            Object finalSum = reducer.getReduceResult();
            return finalSum;
        }
    }
}

