/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.haplotypeBAMWriter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.SAMFileWriter;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.genotyper.MostLikelyAllele;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.haplotype.Haplotype;
import org.broadinstitute.sting.utils.haplotypeBAMWriter.HaplotypeBAMWriter;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.variant.variantcontext.Allele;

class AllHaplotypeBAMWriter
extends HaplotypeBAMWriter {
    public AllHaplotypeBAMWriter(SAMFileWriter bamWriter) {
        super(bamWriter);
    }

    @Override
    public void writeReadsAlignedToHaplotypes(List<Haplotype> haplotypes, GenomeLoc paddedReferenceLoc, List<Haplotype> bestHaplotypes, Set<Haplotype> calledHaplotypes, Map<String, PerReadAlleleLikelihoodMap> stratifiedReadMap) {
        this.writeHaplotypesAsReads(haplotypes, new HashSet<Haplotype>(bestHaplotypes), paddedReferenceLoc);
        HashMap<Allele, Haplotype> alleleToHaplotypeMap = new HashMap<Allele, Haplotype>(haplotypes.size());
        for (Haplotype haplotype : haplotypes) {
            alleleToHaplotypeMap.put(Allele.create((byte[])haplotype.getBases()), haplotype);
        }
        for (PerReadAlleleLikelihoodMap readAlleleLikelihoodMap : stratifiedReadMap.values()) {
            for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> entry : readAlleleLikelihoodMap.getLikelihoodReadMap().entrySet()) {
                MostLikelyAllele bestAllele = PerReadAlleleLikelihoodMap.getMostLikelyAllele(entry.getValue());
                this.writeReadAgainstHaplotype(entry.getKey(), (Haplotype)((Object)alleleToHaplotypeMap.get(bestAllele.getMostLikelyAllele())), paddedReferenceLoc.getStart(), bestAllele.isInformative());
            }
        }
    }
}

