/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.readers.LineReader;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class MillsDevineCodec
extends AsciiFeatureCodec<VariantContext> {
    private static final String DELETION_TYPE = "DEL";
    private static final String INSERTION_TYPE = "INS";
    private static final int minimumFeatureCount = 10;
    private static final int NUM_HEADER_LINES = 1;
    private static final Pattern DBSNP_PATTERN = Pattern.compile("^dbsnp\\.\\d+:(.*)");

    public MillsDevineCodec() {
        super(VariantContext.class);
    }

    public VariantContext decode(String line) {
        long end;
        Allele ref;
        String[] array = line.split("\\t");
        String INDEL_ID = array[0];
        String CHR = array[1];
        String START = array[2];
        String STOP = array[3];
        String IS_REVERSE = array[4];
        String LEN = array[5];
        String DOUBLE_HIT = array[6];
        String DOUBLE_CENTER = array[7];
        String MEMBER = array[8];
        String REF_TYPE = array[9];
        String CHIMP_TYPE = array[10];
        String CELERA_TYPE = array[11];
        String CHIMP_CHR = array[12];
        String CHIMP_START = array[13];
        String CHIMP_STOP = array[14];
        String CELERA_CHR = array[15];
        String CELERA_START = array[16];
        String CELERA_STOP = array[17];
        String NUM_TRACES = array[18];
        String GENE_NAME = array[19];
        String GENE_TYPE = array[20];
        String GENE_COLOR = array[21];
        String IS_CODING = array[22];
        String IS_DISEASE = array[23];
        String IS_VALIDATED = array[24];
        String SEQ = array[25];
        String CLASS = array[26];
        String CLASS_TYPE = array[27];
        String HAS_TSD = array[28];
        String TSD_LEN = array[29];
        String TSD_LEFT_SEQ = array[30];
        String TSD_RIGHT_SEQ = array[31];
        String DBSNP_SUBMITTED = array[32];
        String CONTIG = array[33];
        String BIN = array[34];
        long start = Long.valueOf(START) - 1L;
        Allele alt = null;
        if (REF_TYPE.equals(INSERTION_TYPE)) {
            ref = Allele.create((String)"N", (boolean)true);
            alt = Allele.create((String)("N" + SEQ.toUpperCase()), (boolean)false);
            end = start;
        } else if (REF_TYPE.equals(DELETION_TYPE)) {
            ref = Allele.create((String)("N" + SEQ.toUpperCase()), (boolean)true);
            alt = Allele.create((String)"N", (boolean)false);
            end = start + (long)ref.length();
        } else {
            return null;
        }
        HashSet<Allele> alleles = new HashSet<Allele>();
        alleles.add(ref);
        if (alt != null) {
            alleles.add(alt);
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("CLASS", CLASS);
        attrs.put("NUM_TRACES", NUM_TRACES);
        attrs.put("DOUBLE_HIT", DOUBLE_HIT);
        attrs.put("DOUBLE_CENTER", DOUBLE_CENTER);
        attrs.put("CLASS_TYPE", CLASS_TYPE);
        attrs.put("CHIMP_TYPE", CHIMP_TYPE);
        attrs.put("CELERA_TYPE", CELERA_TYPE);
        attrs.put("LEN", LEN);
        attrs.put("IS_CODING", IS_CODING);
        attrs.put("IS_DISEASE", IS_DISEASE);
        attrs.put("IS_VALIDATED", IS_VALIDATED);
        VariantContext vc = new VariantContextBuilder("Mills", CHR, start, end, alleles).id(INDEL_ID).attributes(attrs).make();
        return vc;
    }

    public Object readHeader(LineReader reader) {
        String headerLine = null;
        try {
            for (int i = 0; i < 1; ++i) {
                headerLine = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read a line from the line reader");
        }
        return null;
    }

    private String parseID(String raw) {
        String[] ids;
        StringBuilder sb = null;
        for (String id : ids = raw.split(";")) {
            Matcher matcher = DBSNP_PATTERN.matcher(id);
            if (!matcher.matches()) continue;
            String rsID = matcher.group(1);
            if (sb == null) {
                sb = new StringBuilder(rsID);
                continue;
            }
            sb.append(";");
            sb.append(rsID);
        }
        return sb == null ? null : sb.toString();
    }
}

