/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.sf.picard.util.PeekableIterator;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.utils.SimpleTimer;
import org.broadinstitute.sting.utils.collections.LoggingNestedIntegerArray;
import org.broadinstitute.sting.utils.collections.NestedIntegerArray;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.recalibration.RecalDatum;
import org.broadinstitute.sting.utils.text.XReadLines;

public class ProfileNestedIntegerArray
extends CommandLineProgram {
    private static Logger logger = Logger.getLogger(ProfileNestedIntegerArray.class);
    @Argument(fullName="operationLog", shortName="operationLog", doc="File containing output from a LoggingNestedIntegerArray containing the update operations to perform during testing", required=true)
    private File operationLog = null;
    @Argument(fullName="threadPoolSize", shortName="threadPoolSize", doc="Size of the thread pool to use for this test", required=false)
    private int threadPoolSize = 1;
    @Argument(fullName="maxEnqueuedTasks", shortName="maxEnqueuedTasks", doc="Maximum number of tasks that can be submitted to the thread pool at once", required=false)
    private int maxEnqueuedTasks = 10000;
    @Argument(fullName="operationsPerThread", shortName="operationsPerThread", doc="Number of array operations to execute within each thread", required=false)
    private int operationsPerThread = 100000;
    @Argument(fullName="operationBufferSize", shortName="operationBufferSize", doc="Number of operations to load at a time from the log file before dispatching them for execution", required=false)
    private int operationBufferSize = 20000000;
    @Argument(fullName="debug", shortName="debug", doc="Output debugging information", required=false)
    private boolean debug = false;
    private PeekableIterator<String> operationLogIterator;
    private Iterator<ArrayOperation> operationIterator;
    private List<BulkArrayOperationRunner> bulkArrayOperationBuffer;
    private Map<String, NestedIntegerArray<RecalDatum>> arrays;
    private ExecutorService threadPool;
    private Semaphore threadPoolSlot;

    @Override
    protected int execute() throws Exception {
        this.operationLogIterator = new PeekableIterator((Iterator)new XReadLines(this.operationLog, false));
        this.arrays = new HashMap<String, NestedIntegerArray<RecalDatum>>();
        this.initializeArrays();
        this.operationIterator = new ArrayOperationIterator();
        this.bulkArrayOperationBuffer = new ArrayList<BulkArrayOperationRunner>(this.operationBufferSize / this.operationsPerThread + 1);
        this.threadPool = Executors.newFixedThreadPool(this.threadPoolSize);
        this.threadPoolSlot = new Semaphore(this.maxEnqueuedTasks);
        logger.info((Object)"Running test with settings:");
        logger.info((Object)String.format("operationLog=%s threadPoolSize=%d maxEnqueuedTasks=%d operationsPerThread=%d operationBufferSize=%d", this.operationLog, this.threadPoolSize, this.maxEnqueuedTasks, this.operationsPerThread, this.operationBufferSize));
        SimpleTimer wallClockTimer = new SimpleTimer("wallClock");
        wallClockTimer.start();
        this.runTest();
        wallClockTimer.stop();
        logger.info((Object)String.format("Total wall clock time: %.2f seconds (%.2f minutes)", wallClockTimer.getElapsedTime(), wallClockTimer.getElapsedTime() / 60.0));
        return 0;
    }

    private void initializeArrays() {
        while (this.operationLogIterator.hasNext() && ((String)this.operationLogIterator.peek()).startsWith("# ")) {
            String headerLine = ((String)this.operationLogIterator.next()).substring("# ".length());
            String[] tokens = headerLine.split("\t", -1);
            if (tokens.length < 2) {
                throw new UserException.MalformedFile(this.operationLog, "Found a header line with too few tokens (no dimensions specified)");
            }
            String arrayLabel = tokens[0];
            int[] dimensions = new int[tokens.length - 1];
            for (int i = 1; i < tokens.length; ++i) {
                try {
                    dimensions[i - 1] = Integer.parseInt(tokens[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new UserException.MalformedFile(this.operationLog, "Error parsing a numerical header field", (Exception)e);
                }
            }
            this.arrays.put(arrayLabel, new NestedIntegerArray(dimensions));
            if (!this.debug) continue;
            logger.info((Object)String.format("Created NestedIntegerArray %s with dimensions %s", arrayLabel, Arrays.toString(dimensions)));
        }
        if (this.arrays.size() == 0) {
            throw new UserException.MalformedFile(this.operationLog, "No array metadata was found in the header");
        }
    }

    private void runTest() {
        try {
            int maxObservedEnqueuedOperations = 0;
            long enqueuedOperationsRunningTotal = 0L;
            int numObservations = 0;
            do {
                this.bufferUpcomingOperations();
                for (BulkArrayOperationRunner bulkOperation : this.bulkArrayOperationBuffer) {
                    int currentlyEnqueuedOperations = this.maxEnqueuedTasks - this.threadPoolSlot.availablePermits();
                    maxObservedEnqueuedOperations = Math.max(maxObservedEnqueuedOperations, currentlyEnqueuedOperations);
                    enqueuedOperationsRunningTotal += (long)currentlyEnqueuedOperations;
                    ++numObservations;
                    this.threadPoolSlot.acquire();
                    this.threadPool.execute(bulkOperation);
                }
            } while (this.bulkArrayOperationBuffer.size() > 0);
            this.threadPool.shutdown();
            if (!this.threadPool.awaitTermination(300L, TimeUnit.SECONDS)) {
                throw new ReviewedStingException("Final tasks in thread pool did not complete within a reasonable amount of time");
            }
            logger.info((Object)String.format("Max observed enqueued operations: %d\tAverage # of enqueued operations: %.2f", maxObservedEnqueuedOperations, (double)enqueuedOperationsRunningTotal / (double)numObservations));
        }
        catch (InterruptedException e) {
            this.threadPool.shutdownNow();
            throw new ReviewedStingException("Thread interrupted during execution");
        }
    }

    private void bufferUpcomingOperations() {
        this.bulkArrayOperationBuffer.clear();
        int totalOperationsLoaded = 0;
        while (this.operationIterator.hasNext() && totalOperationsLoaded < this.operationBufferSize) {
            ArrayList<ArrayOperation> operations = new ArrayList<ArrayOperation>(this.operationsPerThread);
            while (this.operationIterator.hasNext() && operations.size() < this.operationsPerThread && totalOperationsLoaded < this.operationBufferSize) {
                operations.add(this.operationIterator.next());
                ++totalOperationsLoaded;
            }
            this.bulkArrayOperationBuffer.add(new BulkArrayOperationRunner(operations));
        }
    }

    public static void main(String[] args) {
        try {
            ProfileNestedIntegerArray instance = new ProfileNestedIntegerArray();
            ProfileNestedIntegerArray.start(instance, args);
            System.exit(CommandLineProgram.result);
        }
        catch (UserException e) {
            ProfileNestedIntegerArray.exitSystemWithUserError(e);
        }
        catch (Exception e) {
            ProfileNestedIntegerArray.exitSystemWithError(e);
        }
    }

    private class ArrayOperationIterator
    implements Iterator<ArrayOperation>,
    Iterable<ArrayOperation> {
        private ArrayOperation nextOperation = null;

        public ArrayOperationIterator() {
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextOperation != null;
        }

        @Override
        public ArrayOperation next() {
            if (this.nextOperation == null) {
                throw new NoSuchElementException("next() called when there are no more items");
            }
            ArrayOperation toReturn = this.nextOperation;
            this.advance();
            return toReturn;
        }

        private void advance() {
            LoggingNestedIntegerArray.NestedIntegerArrayOperation operationType;
            if (!ProfileNestedIntegerArray.this.operationLogIterator.hasNext()) {
                this.nextOperation = null;
                return;
            }
            String nextOperationLogEntry = (String)ProfileNestedIntegerArray.this.operationLogIterator.next();
            String[] tokens = nextOperationLogEntry.split("\t", -1);
            if (tokens.length < 4) {
                throw new UserException.MalformedFile(ProfileNestedIntegerArray.this.operationLog, String.format("Found an array operation log entry with less than 4 fields: %s", nextOperationLogEntry));
            }
            String arrayLabel = tokens[0];
            try {
                operationType = LoggingNestedIntegerArray.NestedIntegerArrayOperation.valueOf(tokens[1]);
            }
            catch (IllegalArgumentException e) {
                throw new UserException.MalformedFile(ProfileNestedIntegerArray.this.operationLog, String.format("Illegal operation type %s in log entry %s", tokens[1], nextOperationLogEntry));
            }
            RecalDatum datum = tokens[2].length() > 0 ? this.parseRecalDatumString(tokens[2]) : null;
            int[] keys = new int[tokens.length - 3];
            for (int i = 3; i < tokens.length; ++i) {
                try {
                    keys[i - 3] = Integer.parseInt(tokens[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new UserException.MalformedFile(ProfileNestedIntegerArray.this.operationLog, String.format("Found an array operation log entry with non-integer key: %s", nextOperationLogEntry), (Exception)e);
                }
            }
            this.nextOperation = new ArrayOperation(operationType, arrayLabel, datum, keys);
        }

        private RecalDatum parseRecalDatumString(String recalDatumString) {
            byte quality;
            double numMismatches;
            long numObservations;
            String[] tokens = recalDatumString.split(",", -1);
            try {
                numObservations = (long)Double.parseDouble(tokens[0]);
                numMismatches = Double.parseDouble(tokens[1]);
                quality = (byte)Math.round(Double.parseDouble(tokens[2]));
            }
            catch (NumberFormatException e) {
                throw new UserException.MalformedFile(ProfileNestedIntegerArray.this.operationLog, String.format("Failed to parse RecalDatum string %s", recalDatumString), (Exception)e);
            }
            return new RecalDatum(numObservations, numMismatches, quality);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<ArrayOperation> iterator() {
            return this;
        }
    }

    private class ArrayOperation
    implements Runnable {
        private LoggingNestedIntegerArray.NestedIntegerArrayOperation operationType;
        private String arrayLabel;
        private RecalDatum datum;
        private int[] keys;

        public ArrayOperation(LoggingNestedIntegerArray.NestedIntegerArrayOperation operationType, String arrayLabel, RecalDatum datum, int[] keys) {
            this.operationType = operationType;
            this.arrayLabel = arrayLabel;
            this.datum = datum;
            this.keys = (int[])keys.clone();
        }

        @Override
        public void run() {
            NestedIntegerArray array;
            if (ProfileNestedIntegerArray.this.debug) {
                logger.info((Object)String.format("Running task %s", this.toString()));
            }
            if ((array = (NestedIntegerArray)ProfileNestedIntegerArray.this.arrays.get(this.arrayLabel)) == null) {
                throw new ReviewedStingException(String.format("Attempted to access non-existent array %s", this.arrayLabel));
            }
            switch (this.operationType) {
                case GET: {
                    RecalDatum existingDatum = (RecalDatum)array.get(this.keys);
                    if (existingDatum == null) break;
                    existingDatum.increment(true);
                    break;
                }
                case PUT: {
                    array.put(this.datum, this.keys);
                }
            }
        }

        public String toString() {
            return String.format("[%s in table %s, datum: %s keys: %s]", new Object[]{this.operationType, this.arrayLabel, this.datum != null ? this.datum : "(none)", Arrays.toString(this.keys)});
        }
    }

    private class BulkArrayOperationRunner
    implements Runnable {
        private List<ArrayOperation> operations;

        public BulkArrayOperationRunner(List<ArrayOperation> operations) {
            this.operations = operations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (ArrayOperation operation : this.operations) {
                    operation.run();
                }
            }
            finally {
                ProfileNestedIntegerArray.this.threadPoolSlot.release();
            }
        }
    }
}

