/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.pipeline;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.pipeline.PicardAggregationUtils;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.io.IOUtils;

public class PicardAnalysisFiles {
    private static final String REFERENCE_SEQUENCE_HEADER = "REFERENCE_SEQUENCE";
    private static final String TARGET_INTERVALS_HEADER = "TARGET_INTERVALS";
    private static final String BAIT_INTERVALS_HEADER = "BAIT_INTERVALS";
    private static final String[] ANALYSIS_HEADERS = new String[]{"REFERENCE_SEQUENCE", "TARGET_INTERVALS", "BAIT_INTERVALS"};
    private static final String ANALYSIS_FILES = "analysis_files.txt";
    private String path;
    private Map<String, Set<String>> headerValues = new HashMap<String, Set<String>>();

    public PicardAnalysisFiles(String project, String sample) {
        this(PicardAggregationUtils.getSampleDir(project, sample) + ANALYSIS_FILES);
    }

    public PicardAnalysisFiles(String project, String sample, int version) {
        this(PicardAggregationUtils.getSampleDir(project, sample, version) + ANALYSIS_FILES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public PicardAnalysisFiles(String path) {
        super();
        this.path = path;
        headerIndexes = null;
        it = IOUtils.lineIterator(path);
lbl6:
        // 3 sources

        try {
            while (it.hasNext()) {
                block8: {
                    line = it.nextLine();
                    if (line.length() == 0 || line.startsWith("#")) continue;
                    values = line.split("\t");
                    if (headerIndexes != null) break block8;
                    headerIndexes = new HashMap<String, Integer>();
                    for (String header : PicardAnalysisFiles.ANALYSIS_HEADERS) {
                        headerIndexes.put(header, ArrayUtils.indexOf((Object[])values, (Object)header));
                        this.headerValues.put(header, new HashSet<E>());
                    }
                    ** GOTO lbl6
                }
                for (String header : PicardAnalysisFiles.ANALYSIS_HEADERS) {
                    index = (Integer)headerIndexes.get(header);
                    if (index < 0) continue;
                    if (values.length <= index) {
                        throw new StingException(String.format("Unable to parse line in %s: %n%s", new Object[]{path, line}));
                    }
                    value = values[index];
                    this.headerValues.get(header).add((String)value);
                }
                ** GOTO lbl6
            }
        }
        finally {
            it.close();
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getReferenceSequence() {
        return this.getSingle(REFERENCE_SEQUENCE_HEADER);
    }

    public String getTargetIntervals() {
        return this.getSingle(TARGET_INTERVALS_HEADER);
    }

    public String getBaitIntervals() {
        return this.getSingle(BAIT_INTERVALS_HEADER);
    }

    private String getSingle(String header) {
        Set<String> values = this.headerValues.get(header);
        if (values.size() > 1) {
            throw new UnsupportedOperationException(this.path + " contains more than one value for " + header + ": " + values);
        }
        if (values.size() == 0) {
            return null;
        }
        String value = values.iterator().next();
        return "null".equals(value) ? null : value;
    }
}

