/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLineCount;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class VCFEncoder {
    public static final Charset VCF_CHARSET = Charset.forName("ISO-8859-1");
    private static final String QUAL_FORMAT_STRING = "%.2f";
    private static final String QUAL_FORMAT_EXTENSION_TO_TRIM = ".00";
    private final IntGenotypeFieldAccessors GENOTYPE_FIELD_ACCESSORS = new IntGenotypeFieldAccessors();
    private VCFHeader header;
    private boolean allowMissingFieldsInHeader = false;

    public VCFEncoder(VCFHeader header, boolean allowMissingFieldsInHeader) {
        if (header == null) {
            throw new NullPointerException("The VCF header must not be null.");
        }
        this.header = header;
        this.allowMissingFieldsInHeader = allowMissingFieldsInHeader;
    }

    @Deprecated
    public void setVCFHeader(VCFHeader header) {
        this.header = header;
    }

    @Deprecated
    public void setAllowMissingFieldsInHeader(boolean allow) {
        this.allowMissingFieldsInHeader = allow;
    }

    public String encode(VariantContext context) {
        if (this.header == null) {
            throw new NullPointerException("The header field must be set on the VCFEncoder before encoding records.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(context.getChr()).append("\t");
        stringBuilder.append(String.valueOf(context.getStart())).append("\t");
        stringBuilder.append(context.getID()).append("\t");
        stringBuilder.append(context.getReference().getDisplayString()).append("\t");
        if (context.isVariant()) {
            Allele altAllele = context.getAlternateAllele(0);
            String alt = altAllele.getDisplayString();
            stringBuilder.append(alt);
            for (int i = 1; i < context.getAlternateAlleles().size(); ++i) {
                altAllele = context.getAlternateAllele(i);
                alt = altAllele.getDisplayString();
                stringBuilder.append(",");
                stringBuilder.append(alt);
            }
        } else {
            stringBuilder.append(".");
        }
        stringBuilder.append("\t");
        if (!context.hasLog10PError()) {
            stringBuilder.append(".");
        } else {
            stringBuilder.append(this.formatQualValue(context.getPhredScaledQual()));
        }
        stringBuilder.append("\t");
        stringBuilder.append(this.getFilterString(context)).append("\t");
        TreeMap<String, String> infoFields = new TreeMap<String, String>();
        for (Map.Entry<String, Object> field : context.getAttributes().entrySet()) {
            String outputValue;
            if (!this.header.hasInfoLine(field.getKey())) {
                this.fieldIsMissingFromHeaderError(context, field.getKey(), "INFO");
            }
            if ((outputValue = this.formatVCFField(field.getValue())) == null) continue;
            infoFields.put(field.getKey(), outputValue);
        }
        this.writeInfoString(infoFields, stringBuilder);
        GenotypesContext gc = context.getGenotypes();
        if (gc.isLazyWithData() && ((LazyGenotypesContext)gc).getUnparsedGenotypeData() instanceof String) {
            stringBuilder.append("\t");
            stringBuilder.append(((LazyGenotypesContext)gc).getUnparsedGenotypeData().toString());
        } else {
            List<String> genotypeAttributeKeys = context.calcVCFGenotypeKeys(this.header);
            if (!genotypeAttributeKeys.isEmpty()) {
                for (String format : genotypeAttributeKeys) {
                    if (this.header.hasFormatLine(format)) continue;
                    this.fieldIsMissingFromHeaderError(context, format, "FORMAT");
                }
                String genotypeFormatString = ParsingUtils.join((String)":", genotypeAttributeKeys);
                stringBuilder.append("\t");
                stringBuilder.append(genotypeFormatString);
                Map<Allele, String> alleleStrings = this.buildAlleleStrings(context);
                this.addGenotypeData(context, alleleStrings, genotypeAttributeKeys, stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    VCFHeader getVCFHeader() {
        return this.header;
    }

    boolean getAllowMissingFieldsInHeader() {
        return this.allowMissingFieldsInHeader;
    }

    private String getFilterString(VariantContext vc) {
        if (vc.isFiltered()) {
            for (String filter : vc.getFilters()) {
                if (this.header.hasFilterLine(filter)) continue;
                this.fieldIsMissingFromHeaderError(vc, filter, "FILTER");
            }
            return ParsingUtils.join((String)";", (Collection)ParsingUtils.sortList(vc.getFilters()));
        }
        if (vc.filtersWereApplied()) {
            return "PASS";
        }
        return ".";
    }

    private String formatQualValue(double qual) {
        String s = String.format(QUAL_FORMAT_STRING, qual);
        if (s.endsWith(QUAL_FORMAT_EXTENSION_TO_TRIM)) {
            s = s.substring(0, s.length() - QUAL_FORMAT_EXTENSION_TO_TRIM.length());
        }
        return s;
    }

    private void fieldIsMissingFromHeaderError(VariantContext vc, String id, String field) {
        if (!this.allowMissingFieldsInHeader) {
            throw new IllegalStateException("Key " + id + " found in VariantContext field " + field + " at " + vc.getChr() + ":" + vc.getStart() + " but this key isn't defined in the VCFHeader.  We require all VCFs to have" + " complete VCF headers by default.");
        }
    }

    String formatVCFField(Object val) {
        String result;
        if (val == null) {
            result = ".";
        } else if (val instanceof Double) {
            result = VCFEncoder.formatVCFDouble((Double)val);
        } else if (val instanceof Boolean) {
            result = (Boolean)val != false ? "" : null;
        } else if (val instanceof List) {
            result = this.formatVCFField(((List)val).toArray());
        } else if (val.getClass().isArray()) {
            int length = Array.getLength(val);
            if (length == 0) {
                return this.formatVCFField(null);
            }
            StringBuilder sb = new StringBuilder(this.formatVCFField(Array.get(val, 0)));
            for (int i = 1; i < length; ++i) {
                sb.append(",");
                sb.append(this.formatVCFField(Array.get(val, i)));
            }
            result = sb.toString();
        } else {
            result = val.toString();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String formatVCFDouble(double d) {
        String format;
        if (d < 1.0) {
            if (d < 0.01) {
                if (!(Math.abs(d) >= 1.0E-20)) return "0.00";
                format = "%.3e";
                return String.format(format, d);
            } else {
                format = "%.3f";
            }
            return String.format(format, d);
        } else {
            format = QUAL_FORMAT_STRING;
        }
        return String.format(format, d);
    }

    static int countOccurrences(char c, String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            count += s.charAt(i) == c ? 1 : 0;
        }
        return count;
    }

    static boolean isMissingValue(String s) {
        return VCFEncoder.countOccurrences(".".charAt(0), s) + VCFEncoder.countOccurrences(',', s) == s.length();
    }

    private void addGenotypeData(VariantContext vc, Map<Allele, String> alleleMap, List<String> genotypeFormatKeys, StringBuilder builder) {
        int ploidy = vc.getMaxPloidy(2);
        for (String sample : this.header.getGenotypeSamples()) {
            int i;
            builder.append("\t");
            Genotype g = vc.getGenotype(sample);
            if (g == null) {
                g = GenotypeBuilder.createMissing(sample, ploidy);
            }
            ArrayList<String> attrs = new ArrayList<String>(genotypeFormatKeys.size());
            for (String field : genotypeFormatKeys) {
                String outputValue;
                if (field.equals("GT")) {
                    if (!g.isAvailable()) {
                        throw new IllegalStateException("GTs cannot be missing for some samples if they are available for others in the record");
                    }
                    this.writeAllele(g.getAllele(0), alleleMap, builder);
                    for (int i2 = 1; i2 < g.getPloidy(); ++i2) {
                        builder.append(g.isPhased() ? "|" : "/");
                        this.writeAllele(g.getAllele(i2), alleleMap, builder);
                    }
                    continue;
                }
                if (field.equals("FT")) {
                    outputValue = g.isFiltered() ? g.getFilters() : "PASS";
                } else {
                    IntGenotypeFieldAccessors.Accessor accessor = this.GENOTYPE_FIELD_ACCESSORS.getAccessor(field);
                    if (accessor != null) {
                        int[] intValues = accessor.getValues(g);
                        if (intValues == null) {
                            outputValue = ".";
                        } else if (intValues.length == 1) {
                            outputValue = Integer.toString(intValues[0]);
                        } else {
                            StringBuilder sb = new StringBuilder();
                            sb.append(intValues[0]);
                            for (int i3 = 1; i3 < intValues.length; ++i3) {
                                sb.append(",");
                                sb.append(intValues[i3]);
                            }
                            outputValue = sb.toString();
                        }
                    } else {
                        int numInFormatField;
                        String val = g.hasExtendedAttribute(field) ? g.getExtendedAttribute(field) : ".";
                        VCFFormatHeaderLine metaData = this.header.getFormatHeaderLine(field);
                        if (metaData != null && (numInFormatField = metaData.getCount(vc)) > 1 && val.equals(".")) {
                            StringBuilder sb = new StringBuilder(".");
                            for (int i4 = 1; i4 < numInFormatField; ++i4) {
                                sb.append(",");
                                sb.append(".");
                            }
                            val = sb.toString();
                        }
                        outputValue = this.formatVCFField(val);
                    }
                }
                if (outputValue == null) continue;
                attrs.add(outputValue);
            }
            for (i = attrs.size() - 1; i >= 0 && VCFEncoder.isMissingValue((String)attrs.get(i)); --i) {
                attrs.remove(i);
            }
            for (i = 0; i < attrs.size(); ++i) {
                if (i > 0 || genotypeFormatKeys.contains("GT")) {
                    builder.append(":");
                }
                builder.append((String)attrs.get(i));
            }
        }
    }

    private void writeInfoString(Map<String, String> infoFields, StringBuilder builder) {
        if (infoFields.isEmpty()) {
            builder.append(".");
            return;
        }
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : infoFields.entrySet()) {
            VCFInfoHeaderLine metaData;
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(";");
            }
            builder.append(entry.getKey());
            if (entry.getValue().equals("") || (metaData = this.header.getInfoHeaderLine(entry.getKey())) != null && metaData.getCountType() == VCFHeaderLineCount.INTEGER && metaData.getCount() == 0) continue;
            builder.append("=");
            builder.append(entry.getValue());
        }
    }

    private Map<Allele, String> buildAlleleStrings(VariantContext vc) {
        HashMap<Allele, String> alleleMap = new HashMap<Allele, String>(vc.getAlleles().size() + 1);
        alleleMap.put(Allele.NO_CALL, ".");
        List<Allele> alleles = vc.getAlleles();
        for (int i = 0; i < alleles.size(); ++i) {
            alleleMap.put(alleles.get(i), String.valueOf(i));
        }
        return alleleMap;
    }

    private void writeAllele(Allele allele, Map<Allele, String> alleleMap, StringBuilder builder) {
        String encoding = alleleMap.get(allele);
        if (encoding == null) {
            throw new RuntimeException("Allele " + allele + " is not an allele in the variant context");
        }
        builder.append(encoding);
    }
}

