/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.LazyBSONCallback;
import org.bson.io.Bits;

public class LazyBSONDecoder
implements BSONDecoder {
    static final Logger LOG = Logger.getLogger(LazyBSONDecoder.class.getName());
    private static int BYTES_IN_INTEGER = 4;

    public BSONObject readObject(byte[] b2) {
        try {
            return this.readObject(new ByteArrayInputStream(b2));
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public BSONObject readObject(InputStream in) throws IOException {
        LazyBSONCallback c2 = new LazyBSONCallback();
        this.decode(in, (BSONCallback)c2);
        return (BSONObject)c2.get();
    }

    public int decode(byte[] b2, BSONCallback callback) {
        try {
            return this.decode(new ByteArrayInputStream(b2), callback);
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public int decode(InputStream in, BSONCallback callback) throws IOException {
        byte[] objSizeBuffer = new byte[BYTES_IN_INTEGER];
        Bits.readFully(in, objSizeBuffer, 0, BYTES_IN_INTEGER);
        int objSize = Bits.readInt(objSizeBuffer);
        byte[] data = new byte[objSize];
        System.arraycopy(objSizeBuffer, 0, data, 0, BYTES_IN_INTEGER);
        Bits.readFully(in, data, BYTES_IN_INTEGER, objSize - BYTES_IN_INTEGER);
        callback.gotBinary(null, (byte)0, data);
        return objSize;
    }
}

