/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sf.samtools.SAMSequenceDictionary;
import org.broad.tribble.index.IndexCreator;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.IndexingVariantContextWriter;
import org.broadinstitute.variant.vcf.VCFEncoder;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;

class VCFWriter
extends IndexingVariantContextWriter {
    private static final String VERSION_LINE = "##" + VCFHeaderVersion.VCF4_1.getFormatString() + "=" + VCFHeaderVersion.VCF4_1.getVersionString();
    private VCFEncoder vcfEncoder = null;
    protected VCFHeader mHeader = null;
    private final boolean allowMissingFieldsInHeader;
    private final boolean doNotWriteGenotypes;
    private static final int INITIAL_BUFFER_SIZE = 16384;
    private final ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream(16384);
    private final Writer writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.lineBuffer, VCFEncoder.VCF_CHARSET));

    public VCFWriter(File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes, boolean allowMissingFieldsInHeader) {
        super(VCFWriter.writerName(location, output), location, output, refDict, enableOnTheFlyIndexing);
        this.doNotWriteGenotypes = doNotWriteGenotypes;
        this.allowMissingFieldsInHeader = allowMissingFieldsInHeader;
    }

    public VCFWriter(File location, OutputStream output, SAMSequenceDictionary refDict, IndexCreator indexCreator, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes, boolean allowMissingFieldsInHeader) {
        super(VCFWriter.writerName(location, output), location, output, refDict, enableOnTheFlyIndexing, indexCreator);
        this.doNotWriteGenotypes = doNotWriteGenotypes;
        this.allowMissingFieldsInHeader = allowMissingFieldsInHeader;
    }

    private void write(String s2) throws IOException {
        this.writer.write(s2);
    }

    private void writeAndResetBuffer() throws IOException {
        this.writer.flush();
        this.getOutputStream().write(this.lineBuffer.toByteArray());
        this.lineBuffer.reset();
    }

    @Override
    public void writeHeader(VCFHeader header) {
        try {
            this.mHeader = VCFWriter.writeHeader(header, this.writer, this.doNotWriteGenotypes, VCFWriter.getVersionLine(), this.getStreamName());
            this.vcfEncoder = new VCFEncoder(this.mHeader, this.allowMissingFieldsInHeader);
            this.writeAndResetBuffer();
        }
        catch (IOException e2) {
            throw new RuntimeException("Couldn't write file " + this.getStreamName(), e2);
        }
    }

    public static String getVersionLine() {
        return VERSION_LINE;
    }

    public static VCFHeader writeHeader(VCFHeader header, Writer writer, boolean doNotWriteGenotypes, String versionLine, String streamNameForError) {
        header = doNotWriteGenotypes ? new VCFHeader(header.getMetaDataInSortedOrder()) : header;
        try {
            writer.write(versionLine + "\n");
            for (VCFHeaderLine line : header.getMetaDataInSortedOrder()) {
                if (VCFHeaderVersion.isFormatString(line.getKey())) continue;
                writer.write("##");
                writer.write(line.toString());
                writer.write("\n");
            }
            writer.write("#");
            boolean isFirst = true;
            for (VCFHeader.HEADER_FIELDS field : header.getHeaderFields()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.write("\t");
                }
                writer.write(field.toString());
            }
            if (header.hasGenotypingData()) {
                writer.write("\t");
                writer.write("FORMAT");
                for (String sample : header.getGenotypeSamples()) {
                    writer.write("\t");
                    writer.write(sample);
                }
            }
            writer.write("\n");
            writer.flush();
        }
        catch (IOException e2) {
            throw new RuntimeException("IOException writing the VCF header to " + streamNameForError, e2);
        }
        return header;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to close " + this.getStreamName(), e2);
        }
        super.close();
    }

    @Override
    public void add(VariantContext context) {
        try {
            super.add(context);
            if (this.doNotWriteGenotypes) {
                this.write(this.vcfEncoder.encode(new VariantContextBuilder(context).noGenotypes().make()));
            } else {
                this.write(this.vcfEncoder.encode(context));
            }
            this.write("\n");
            this.writeAndResetBuffer();
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to write the VCF object to " + this.getStreamName(), e2);
        }
    }
}

