/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.bcf2.BCF2Utils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.BCF2Encoder;
import org.broadinstitute.variant.variantcontext.writer.BCF2FieldEncoder;
import org.broadinstitute.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import org.broadinstitute.variant.vcf.VCFHeader;

public abstract class BCF2FieldWriter {
    private final VCFHeader header;
    private final BCF2FieldEncoder fieldEncoder;

    @Requires(value={"header != null", "fieldEncoder != null"})
    protected BCF2FieldWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
        this.header = header;
        this.fieldEncoder = fieldEncoder;
    }

    @Ensures(value={"result != null"})
    protected VCFHeader getHeader() {
        return this.header;
    }

    @Ensures(value={"result != null"})
    protected BCF2FieldEncoder getFieldEncoder() {
        return this.fieldEncoder;
    }

    @Ensures(value={"result != null"})
    protected String getField() {
        return this.getFieldEncoder().getField();
    }

    @Requires(value={"vc != null"})
    public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
        this.fieldEncoder.writeFieldKey(encoder);
    }

    public void done(BCF2Encoder encoder, VariantContext vc) throws IOException {
    }

    public String toString() {
        return "BCF2FieldWriter " + this.getClass().getSimpleName() + " with encoder " + this.getFieldEncoder();
    }

    public static class GTWriter
    extends GenotypesWriter {
        final Map<Allele, Integer> alleleMapForTriPlus = new HashMap<Allele, Integer>(5);
        Allele ref;
        Allele alt1;

        public GTWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        @Override
        public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
            if (vc.getNAlleles() > 127) {
                throw new IllegalStateException("Current BCF2 encoder cannot handle sites with > 127 alleles, but you have " + vc.getNAlleles() + " at " + vc.getChr() + ":" + vc.getStart());
            }
            this.encodingType = BCF2Type.INT8;
            this.buildAlleleMap(vc);
            this.nValuesPerGenotype = vc.getMaxPloidy(2);
            super.start(encoder, vc);
        }

        @Override
        public void addGenotype(BCF2Encoder encoder, VariantContext vc, Genotype g2) throws IOException {
            int samplePloidy = g2.getPloidy();
            for (int i2 = 0; i2 < this.nValuesPerGenotype; ++i2) {
                if (i2 < samplePloidy) {
                    Allele a2 = g2.getAllele(i2);
                    int offset = this.getAlleleOffset(a2);
                    int encoded = offset + 1 << 1 | (g2.isPhased() ? 1 : 0);
                    encoder.encodeRawBytes(encoded, this.encodingType);
                    continue;
                }
                encoder.encodeRawBytes(this.encodingType.getMissingBytes(), this.encodingType);
            }
        }

        @Requires(value={"a != null"})
        private final int getAlleleOffset(Allele a2) {
            if (a2 == this.ref) {
                return 0;
            }
            if (a2 == this.alt1) {
                return 1;
            }
            if (a2 == Allele.NO_CALL) {
                return -1;
            }
            Integer o2 = this.alleleMapForTriPlus.get(a2);
            if (o2 == null) {
                throw new IllegalStateException("BUG: Couldn't find allele offset for allele " + a2);
            }
            return o2;
        }

        private final void buildAlleleMap(VariantContext vc) {
            int nAlleles = vc.getNAlleles();
            this.ref = vc.getReference();
            Allele allele = this.alt1 = nAlleles > 1 ? vc.getAlternateAllele(0) : null;
            if (nAlleles > 2) {
                this.alleleMapForTriPlus.clear();
                List<Allele> alleles = vc.getAlleles();
                for (int i2 = 2; i2 < alleles.size(); ++i2) {
                    this.alleleMapForTriPlus.put(alleles.get(i2), i2);
                }
            }
        }
    }

    public static class FTGenotypesWriter
    extends StaticallyTypeGenotypesWriter {
        public FTGenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        @Override
        public void addGenotype(BCF2Encoder encoder, VariantContext vc, Genotype g2) throws IOException {
            String fieldValue = g2.getFilters();
            this.getFieldEncoder().encodeValue(encoder, fieldValue, this.encodingType, this.nValuesPerGenotype);
        }

        @Override
        protected int numElements(VariantContext vc, Genotype g2) {
            return this.getFieldEncoder().numElements(vc, g2.getFilters());
        }
    }

    public static class IGFGenotypesWriter
    extends GenotypesWriter {
        final IntGenotypeFieldAccessors.Accessor ige;

        public IGFGenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder, IntGenotypeFieldAccessors.Accessor ige) {
            super(header, fieldEncoder);
            this.ige = ige;
            if (!(fieldEncoder instanceof BCF2FieldEncoder.IntArray)) {
                throw new IllegalArgumentException("BUG: IntGenotypesWriter requires IntArray encoder for field " + this.getField());
            }
        }

        @Override
        public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
            this.encodingType = BCF2Type.INT8;
            for (Genotype g2 : vc.getGenotypes()) {
                int[] pls = this.ige.getValues(g2);
                BCF2Type plsType = this.getFieldEncoder().getType(pls);
                this.encodingType = BCF2Utils.maxIntegerType(this.encodingType, plsType);
                if (this.encodingType != BCF2Type.INT32) continue;
                break;
            }
            super.start(encoder, vc);
        }

        @Override
        public void addGenotype(BCF2Encoder encoder, VariantContext vc, Genotype g2) throws IOException {
            this.getFieldEncoder().encodeValue(encoder, this.ige.getValues(g2), this.encodingType, this.nValuesPerGenotype);
        }

        @Override
        protected int numElements(VariantContext vc, Genotype g2) {
            return this.ige.getSize(g2);
        }
    }

    public static class IntegerTypeGenotypesWriter
    extends GenotypesWriter {
        public IntegerTypeGenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        @Override
        public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
            ArrayList<Integer> values = new ArrayList<Integer>(vc.getNSamples());
            for (Genotype g2 : vc.getGenotypes()) {
                for (Object i2 : BCF2Utils.toList(g2.getExtendedAttribute(this.getField(), null))) {
                    if (i2 == null) continue;
                    values.add((Integer)i2);
                }
            }
            this.encodingType = BCF2Utils.determineIntegerType(values);
            super.start(encoder, vc);
        }
    }

    public static class StaticallyTypeGenotypesWriter
    extends GenotypesWriter {
        public StaticallyTypeGenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
            this.encodingType = this.getFieldEncoder().getStaticType();
        }
    }

    public static abstract class GenotypesWriter
    extends BCF2FieldWriter {
        int nValuesPerGenotype = -1;
        BCF2Type encodingType = null;

        protected GenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
            if (fieldEncoder.hasConstantNumElements()) {
                this.nValuesPerGenotype = this.getFieldEncoder().numElements();
            }
        }

        @Override
        @Requires(value={"encodingType != null", "nValuesPerGenotype >= 0 || ! getFieldEncoder().hasConstantNumElements()"})
        @Ensures(value={"nValuesPerGenotype >= 0"})
        public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
            super.start(encoder, vc);
            if (!this.getFieldEncoder().hasConstantNumElements()) {
                this.nValuesPerGenotype = this.getFieldEncoder().hasContextDeterminedNumElements() ? this.getFieldEncoder().numElements(vc) : this.computeMaxSizeOfGenotypeFieldFromValues(vc);
            }
            encoder.encodeType(this.nValuesPerGenotype, this.encodingType);
        }

        @Requires(value={"encodingType != null", "nValuesPerGenotype >= 0"})
        public void addGenotype(BCF2Encoder encoder, VariantContext vc, Genotype g2) throws IOException {
            Object fieldValue = g2.getExtendedAttribute(this.getField(), null);
            this.getFieldEncoder().encodeValue(encoder, fieldValue, this.encodingType, this.nValuesPerGenotype);
        }

        @Ensures(value={"result >= 0"})
        protected int numElements(VariantContext vc, Genotype g2) {
            return this.getFieldEncoder().numElements(vc, g2.getExtendedAttribute(this.getField()));
        }

        @Ensures(value={"result >= 0"})
        private final int computeMaxSizeOfGenotypeFieldFromValues(VariantContext vc) {
            int size = -1;
            for (Genotype g2 : vc.getGenotypes()) {
                size = Math.max(size, this.numElements(vc, g2));
            }
            return size;
        }
    }

    public static class GenericSiteWriter
    extends SiteWriter {
        public GenericSiteWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        @Override
        public void site(BCF2Encoder encoder, VariantContext vc) throws IOException {
            Object rawValue = vc.getAttribute(this.getField(), null);
            BCF2Type type = this.getFieldEncoder().getType(rawValue);
            if (rawValue == null) {
                encoder.encodeType(0, type);
            } else {
                int valueCount = this.getFieldEncoder().numElements(vc, rawValue);
                encoder.encodeType(valueCount, type);
                this.getFieldEncoder().encodeValue(encoder, rawValue, type, valueCount);
            }
        }
    }

    public static abstract class SiteWriter
    extends BCF2FieldWriter {
        protected SiteWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        public abstract void site(BCF2Encoder var1, VariantContext var2) throws IOException;
    }
}

