/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.bcf2.BCF2Utils;

public final class BCF2Encoder {
    public static final int WRITE_BUFFER_INITIAL_SIZE = 16384;
    private ByteArrayOutputStream encodeStream = new ByteArrayOutputStream(16384);

    @Ensures(value={"result != null"})
    public byte[] getRecordBytes() {
        byte[] bytes = this.encodeStream.toByteArray();
        this.encodeStream.reset();
        return bytes;
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedMissing(BCF2Type type) throws IOException {
        this.encodeType(0, type);
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTyped(Object value, BCF2Type type) throws IOException {
        if (value == null) {
            this.encodeTypedMissing(type);
        } else {
            switch (type) {
                case INT8: 
                case INT16: 
                case INT32: {
                    this.encodeTypedInt((Integer)value, type);
                    break;
                }
                case FLOAT: {
                    this.encodeTypedFloat((Double)value);
                    break;
                }
                case CHAR: {
                    this.encodeTypedString((String)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal type encountered " + (Object)((Object)type));
                }
            }
        }
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedInt(int v2) throws IOException {
        BCF2Type type = BCF2Utils.determineIntegerType(v2);
        this.encodeTypedInt(v2, type);
    }

    @Requires(value={"type.isIntegerType()"})
    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedInt(int v2, BCF2Type type) throws IOException {
        this.encodeType(1, type);
        this.encodeRawInt(v2, type);
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedString(String s2) throws IOException {
        this.encodeTypedString(s2.getBytes());
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedString(byte[] s2) throws IOException {
        if (s2 == null) {
            this.encodeType(0, BCF2Type.CHAR);
        } else {
            this.encodeType(s2.length, BCF2Type.CHAR);
            for (int i2 = 0; i2 < s2.length; ++i2) {
                this.encodeRawChar(s2[i2]);
            }
        }
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTypedFloat(double d2) throws IOException {
        this.encodeType(1, BCF2Type.FLOAT);
        this.encodeRawFloat(d2);
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeTyped(List<? extends Object> v2, BCF2Type type) throws IOException {
        if (type == BCF2Type.CHAR && v2.size() != 0) {
            String s2 = BCF2Utils.collapseStringList(v2);
            v2 = this.stringToBytes(s2);
        }
        this.encodeType(v2.size(), type);
        this.encodeRawValues(v2, type);
    }

    public final <T> void encodeRawValues(Collection<T> v2, BCF2Type type) throws IOException {
        for (T v1 : v2) {
            this.encodeRawValue(v1, type);
        }
    }

    public final <T> void encodeRawValue(T value, BCF2Type type) throws IOException {
        try {
            if (value == type.getMissingJavaValue()) {
                this.encodeRawMissingValue(type);
            } else {
                switch (type) {
                    case INT8: 
                    case INT16: 
                    case INT32: {
                        this.encodeRawBytes((Integer)value, type);
                        break;
                    }
                    case FLOAT: {
                        this.encodeRawFloat((Double)value);
                        break;
                    }
                    case CHAR: {
                        this.encodeRawChar((Byte)value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal type encountered " + (Object)((Object)type));
                    }
                }
            }
        }
        catch (ClassCastException e2) {
            throw new ClassCastException("BUG: invalid type cast to " + (Object)((Object)type) + " from " + value);
        }
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeRawMissingValue(BCF2Type type) throws IOException {
        this.encodeRawBytes(type.getMissingBytes(), type);
    }

    @Requires(value={"size >= 0"})
    public final void encodeRawMissingValues(int size, BCF2Type type) throws IOException {
        for (int i2 = 0; i2 < size; ++i2) {
            this.encodeRawMissingValue(type);
        }
    }

    public final void encodeRawChar(byte c2) throws IOException {
        this.encodeStream.write(c2);
    }

    public final void encodeRawFloat(double value) throws IOException {
        this.encodeRawBytes(Float.floatToIntBits((float)value), BCF2Type.FLOAT);
    }

    @Requires(value={"size >= 0"})
    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeType(int size, BCF2Type type) throws IOException {
        if (size <= 14) {
            byte typeByte = BCF2Utils.encodeTypeDescriptor(size, type);
            this.encodeStream.write(typeByte);
        } else {
            byte typeByte = BCF2Utils.encodeTypeDescriptor(15, type);
            this.encodeStream.write(typeByte);
            this.encodeTypedInt(size);
        }
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeRawInt(int value, BCF2Type type) throws IOException {
        type.write(value, this.encodeStream);
    }

    @Ensures(value={"encodeStream.size() > old(encodeStream.size())"})
    public final void encodeRawBytes(int value, BCF2Type type) throws IOException {
        type.write(value, this.encodeStream);
    }

    @Requires(value={"s != null", "sizeToWrite >= 0"})
    public void encodeRawString(String s2, int sizeToWrite) throws IOException {
        byte[] bytes = s2.getBytes();
        for (int i2 = 0; i2 < sizeToWrite; ++i2) {
            if (i2 < bytes.length) {
                this.encodeRawChar(bytes[i2]);
                continue;
            }
            this.encodeRawMissingValue(BCF2Type.CHAR);
        }
    }

    @Requires(value={"o != null"})
    public final BCF2Type encode(Object o2) throws IOException {
        if (o2 == null) {
            throw new IllegalArgumentException("Generic encode cannot deal with null values");
        }
        if (o2 instanceof List) {
            BCF2Type type = this.determineBCFType(((List)o2).get(0));
            this.encodeTyped((List)o2, type);
            return type;
        }
        BCF2Type type = this.determineBCFType(o2);
        this.encodeTyped(o2, type);
        return type;
    }

    @Requires(value={"arg != null"})
    private final BCF2Type determineBCFType(Object arg) {
        Object toType;
        Object object = toType = arg instanceof List ? ((List)arg).get(0) : arg;
        if (toType instanceof Integer) {
            return BCF2Utils.determineIntegerType((Integer)toType);
        }
        if (toType instanceof String) {
            return BCF2Type.CHAR;
        }
        if (toType instanceof Double) {
            return BCF2Type.FLOAT;
        }
        throw new IllegalArgumentException("No native encoding for Object of type " + arg.getClass().getSimpleName());
    }

    private final List<Byte> stringToBytes(String v2) throws IOException {
        if (v2 == null || v2.equals("")) {
            return Collections.emptyList();
        }
        byte[] bytes = v2.getBytes();
        ArrayList<Byte> l2 = new ArrayList<Byte>(bytes.length);
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            l2.add(bytes[i2]);
        }
        return l2;
    }
}

