/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class GeneralUtils {
    public static final boolean DEBUG_MODE_ENABLED = false;
    public static final double LOG10_P_OF_ZERO = -1000000.0;

    public static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        T first = iter.next();
        if (!iter.hasNext()) {
            return first.toString();
        }
        StringBuilder ret = new StringBuilder(first.toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    public static double[] normalizeFromLog10(double[] array) {
        return GeneralUtils.normalizeFromLog10(array, false);
    }

    public static double[] normalizeFromLog10(double[] array, boolean takeLog10OfOutput) {
        return GeneralUtils.normalizeFromLog10(array, takeLog10OfOutput, false);
    }

    public static double[] normalizeFromLog10(double[] array, boolean takeLog10OfOutput, boolean keepInLogSpace) {
        int i2;
        double maxValue = GeneralUtils.arrayMax(array);
        if (keepInLogSpace) {
            int i3 = 0;
            while (i3 < array.length) {
                int n2 = i3++;
                array[n2] = array[n2] - maxValue;
            }
            return array;
        }
        double[] normalized = new double[array.length];
        for (int i4 = 0; i4 < array.length; ++i4) {
            normalized[i4] = Math.pow(10.0, array[i4] - maxValue);
        }
        double sum = 0.0;
        for (i2 = 0; i2 < array.length; ++i2) {
            sum += normalized[i2];
        }
        for (i2 = 0; i2 < array.length; ++i2) {
            double x2 = normalized[i2] / sum;
            if (takeLog10OfOutput && ((x2 = Math.log10(x2)) < -1000000.0 || Double.isInfinite(x2))) {
                x2 = array[i2] - maxValue;
            }
            normalized[i2] = x2;
        }
        return normalized;
    }

    public static double arrayMax(double[] array) {
        return array[GeneralUtils.maxElementIndex(array, array.length)];
    }

    public static int maxElementIndex(double[] array) {
        return GeneralUtils.maxElementIndex(array, array.length);
    }

    public static int maxElementIndex(double[] array, int endIndex) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int maxI = 0;
        for (int i2 = 1; i2 < endIndex; ++i2) {
            if (!(array[i2] > array[maxI])) continue;
            maxI = i2;
        }
        return maxI;
    }

    public static <T> List<T> cons(T elt, List<T> l2) {
        ArrayList<T> l22 = new ArrayList<T>();
        l22.add(elt);
        if (l2 != null) {
            l22.addAll(l2);
        }
        return l22;
    }

    public static <T> List<List<T>> makePermutations(List<T> objects, int n2, boolean withReplacement) {
        ArrayList<List<T>> combinations;
        block5: {
            combinations = new ArrayList<List<T>>();
            if (n2 <= 0) break block5;
            if (n2 == 1) {
                for (T o2 : objects) {
                    combinations.add(Collections.singletonList(o2));
                }
            } else {
                List<List<T>> sub = GeneralUtils.makePermutations(objects, n2 - 1, withReplacement);
                for (List<T> subI : sub) {
                    for (T a2 : objects) {
                        if (!withReplacement && subI.contains(a2)) continue;
                        combinations.add(GeneralUtils.cons(a2, subI));
                    }
                }
            }
        }
        return combinations;
    }

    public static byte compareDoubles(double a2, double b2) {
        return GeneralUtils.compareDoubles(a2, b2, 1.0E-6);
    }

    public static byte compareDoubles(double a2, double b2, double epsilon) {
        if (Math.abs(a2 - b2) < epsilon) {
            return 0;
        }
        if (a2 > b2) {
            return -1;
        }
        return 1;
    }

    public static final <T> List<T> reverse(List<T> l2) {
        ArrayList<T> newL = new ArrayList<T>(l2);
        Collections.reverse(newL);
        return newL;
    }
}

